<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SalesInvoiceCommissions StructType
 * @subpackage Structs
 */
class SalesInvoiceCommissions extends Entity
{
    /**
     * The CommissionAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $CommissionAmount;
    /**
     * The SalesPersons
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SalesPersons_1
     */
    public $SalesPersons;
    /**
     * The TotalCommissionableAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $TotalCommissionableAmount;
    /**
     * Constructor method for SalesInvoiceCommissions
     * @uses SalesInvoiceCommissions::setCommissionAmount()
     * @uses SalesInvoiceCommissions::setSalesPersons()
     * @uses SalesInvoiceCommissions::setTotalCommissionableAmount()
     * @param \StructType\DecimalValue $commissionAmount
     * @param \StructType\SalesPersons_1 $salesPersons
     * @param \StructType\DecimalValue $totalCommissionableAmount
     */
    public function __construct(\StructType\DecimalValue $commissionAmount = null, \StructType\SalesPersons_1 $salesPersons = null, \StructType\DecimalValue $totalCommissionableAmount = null)
    {
        $this
            ->setCommissionAmount($commissionAmount)
            ->setSalesPersons($salesPersons)
            ->setTotalCommissionableAmount($totalCommissionableAmount);
    }
    /**
     * Get CommissionAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getCommissionAmount()
    {
        return isset($this->CommissionAmount) ? $this->CommissionAmount : null;
    }
    /**
     * Set CommissionAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $commissionAmount
     * @return \StructType\SalesInvoiceCommissions
     */
    public function setCommissionAmount(\StructType\DecimalValue $commissionAmount = null)
    {
        if (is_null($commissionAmount) || (is_array($commissionAmount) && empty($commissionAmount))) {
            unset($this->CommissionAmount);
        } else {
            $this->CommissionAmount = $commissionAmount;
        }
        return $this;
    }
    /**
     * Get SalesPersons value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SalesPersons_1|null
     */
    public function getSalesPersons()
    {
        return isset($this->SalesPersons) ? $this->SalesPersons : null;
    }
    /**
     * Set SalesPersons value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\SalesPersons_1 $salesPersons
     * @return \StructType\SalesInvoiceCommissions
     */
    public function setSalesPersons(\StructType\SalesPersons_1 $salesPersons = null)
    {
        if (is_null($salesPersons) || (is_array($salesPersons) && empty($salesPersons))) {
            unset($this->SalesPersons);
        } else {
            $this->SalesPersons = $salesPersons;
        }
        return $this;
    }
    /**
     * Get TotalCommissionableAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getTotalCommissionableAmount()
    {
        return isset($this->TotalCommissionableAmount) ? $this->TotalCommissionableAmount : null;
    }
    /**
     * Set TotalCommissionableAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $totalCommissionableAmount
     * @return \StructType\SalesInvoiceCommissions
     */
    public function setTotalCommissionableAmount(\StructType\DecimalValue $totalCommissionableAmount = null)
    {
        if (is_null($totalCommissionableAmount) || (is_array($totalCommissionableAmount) && empty($totalCommissionableAmount))) {
            unset($this->TotalCommissionableAmount);
        } else {
            $this->TotalCommissionableAmount = $totalCommissionableAmount;
        }
        return $this;
    }
}
