<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Roles StructType
 * @subpackage Structs
 */
class Roles extends AbstractStructBase
{
    /**
     * The ContactRoles
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ContactRoles[]
     */
    public $ContactRoles;
    /**
     * Constructor method for Roles
     * @uses Roles::setContactRoles()
     * @param \StructType\ContactRoles[] $contactRoles
     */
    public function __construct(array $contactRoles = array())
    {
        $this
            ->setContactRoles($contactRoles);
    }
    /**
     * Get ContactRoles value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ContactRoles[]|null
     */
    public function getContactRoles()
    {
        return isset($this->ContactRoles) ? $this->ContactRoles : null;
    }
    /**
     * This method is responsible for validating the values passed to the setContactRoles method
     * This method is willingly generated in order to preserve the one-line inline validation within the setContactRoles method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateContactRolesForArrayConstraintsFromSetContactRoles(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $rolesContactRolesItem) {
            // validation for constraint: itemType
            if (!$rolesContactRolesItem instanceof \StructType\ContactRoles) {
                $invalidValues[] = is_object($rolesContactRolesItem) ? get_class($rolesContactRolesItem) : sprintf('%s(%s)', gettype($rolesContactRolesItem), var_export($rolesContactRolesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ContactRoles property can only contain items of type \StructType\ContactRoles, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ContactRoles value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ContactRoles[] $contactRoles
     * @return \StructType\Roles
     */
    public function setContactRoles(array $contactRoles = array())
    {
        // validation for constraint: array
        if ('' !== ($contactRolesArrayErrorMessage = self::validateContactRolesForArrayConstraintsFromSetContactRoles($contactRoles))) {
            throw new \InvalidArgumentException($contactRolesArrayErrorMessage, __LINE__);
        }
        if (is_null($contactRoles) || (is_array($contactRoles) && empty($contactRoles))) {
            unset($this->ContactRoles);
        } else {
            $this->ContactRoles = $contactRoles;
        }
        return $this;
    }
    /**
     * Add item to ContactRoles value
     * @throws \InvalidArgumentException
     * @param \StructType\ContactRoles $item
     * @return \StructType\Roles
     */
    public function addToContactRoles(\StructType\ContactRoles $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ContactRoles) {
            throw new \InvalidArgumentException(sprintf('The ContactRoles property can only contain items of type \StructType\ContactRoles, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ContactRoles[] = $item;
        return $this;
    }
}
