<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProjectTaskProperties StructType
 * @subpackage Structs
 */
class ProjectTaskProperties extends Entity
{
    /**
     * The Approver
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Approver;
    /**
     * The Completed
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $Completed;
    /**
     * The CompletionMethod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $CompletionMethod;
    /**
     * The EndDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DateTimeValue
     */
    public $EndDate;
    /**
     * The PlannedEndDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DateTimeValue
     */
    public $PlannedEndDate;
    /**
     * The PlannedStartDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DateTimeValue
     */
    public $PlannedStartDate;
    /**
     * The StartDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DateTimeValue
     */
    public $StartDate;
    /**
     * Constructor method for ProjectTaskProperties
     * @uses ProjectTaskProperties::setApprover()
     * @uses ProjectTaskProperties::setCompleted()
     * @uses ProjectTaskProperties::setCompletionMethod()
     * @uses ProjectTaskProperties::setEndDate()
     * @uses ProjectTaskProperties::setPlannedEndDate()
     * @uses ProjectTaskProperties::setPlannedStartDate()
     * @uses ProjectTaskProperties::setStartDate()
     * @param \StructType\StringValue $approver
     * @param \StructType\DecimalValue $completed
     * @param \StructType\StringValue $completionMethod
     * @param \StructType\DateTimeValue $endDate
     * @param \StructType\DateTimeValue $plannedEndDate
     * @param \StructType\DateTimeValue $plannedStartDate
     * @param \StructType\DateTimeValue $startDate
     */
    public function __construct(\StructType\StringValue $approver = null, \StructType\DecimalValue $completed = null, \StructType\StringValue $completionMethod = null, \StructType\DateTimeValue $endDate = null, \StructType\DateTimeValue $plannedEndDate = null, \StructType\DateTimeValue $plannedStartDate = null, \StructType\DateTimeValue $startDate = null)
    {
        $this
            ->setApprover($approver)
            ->setCompleted($completed)
            ->setCompletionMethod($completionMethod)
            ->setEndDate($endDate)
            ->setPlannedEndDate($plannedEndDate)
            ->setPlannedStartDate($plannedStartDate)
            ->setStartDate($startDate);
    }
    /**
     * Get Approver value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getApprover()
    {
        return isset($this->Approver) ? $this->Approver : null;
    }
    /**
     * Set Approver value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $approver
     * @return \StructType\ProjectTaskProperties
     */
    public function setApprover(\StructType\StringValue $approver = null)
    {
        if (is_null($approver) || (is_array($approver) && empty($approver))) {
            unset($this->Approver);
        } else {
            $this->Approver = $approver;
        }
        return $this;
    }
    /**
     * Get Completed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getCompleted()
    {
        return isset($this->Completed) ? $this->Completed : null;
    }
    /**
     * Set Completed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $completed
     * @return \StructType\ProjectTaskProperties
     */
    public function setCompleted(\StructType\DecimalValue $completed = null)
    {
        if (is_null($completed) || (is_array($completed) && empty($completed))) {
            unset($this->Completed);
        } else {
            $this->Completed = $completed;
        }
        return $this;
    }
    /**
     * Get CompletionMethod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getCompletionMethod()
    {
        return isset($this->CompletionMethod) ? $this->CompletionMethod : null;
    }
    /**
     * Set CompletionMethod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $completionMethod
     * @return \StructType\ProjectTaskProperties
     */
    public function setCompletionMethod(\StructType\StringValue $completionMethod = null)
    {
        if (is_null($completionMethod) || (is_array($completionMethod) && empty($completionMethod))) {
            unset($this->CompletionMethod);
        } else {
            $this->CompletionMethod = $completionMethod;
        }
        return $this;
    }
    /**
     * Get EndDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DateTimeValue|null
     */
    public function getEndDate()
    {
        return isset($this->EndDate) ? $this->EndDate : null;
    }
    /**
     * Set EndDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DateTimeValue $endDate
     * @return \StructType\ProjectTaskProperties
     */
    public function setEndDate(\StructType\DateTimeValue $endDate = null)
    {
        if (is_null($endDate) || (is_array($endDate) && empty($endDate))) {
            unset($this->EndDate);
        } else {
            $this->EndDate = $endDate;
        }
        return $this;
    }
    /**
     * Get PlannedEndDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DateTimeValue|null
     */
    public function getPlannedEndDate()
    {
        return isset($this->PlannedEndDate) ? $this->PlannedEndDate : null;
    }
    /**
     * Set PlannedEndDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DateTimeValue $plannedEndDate
     * @return \StructType\ProjectTaskProperties
     */
    public function setPlannedEndDate(\StructType\DateTimeValue $plannedEndDate = null)
    {
        if (is_null($plannedEndDate) || (is_array($plannedEndDate) && empty($plannedEndDate))) {
            unset($this->PlannedEndDate);
        } else {
            $this->PlannedEndDate = $plannedEndDate;
        }
        return $this;
    }
    /**
     * Get PlannedStartDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DateTimeValue|null
     */
    public function getPlannedStartDate()
    {
        return isset($this->PlannedStartDate) ? $this->PlannedStartDate : null;
    }
    /**
     * Set PlannedStartDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DateTimeValue $plannedStartDate
     * @return \StructType\ProjectTaskProperties
     */
    public function setPlannedStartDate(\StructType\DateTimeValue $plannedStartDate = null)
    {
        if (is_null($plannedStartDate) || (is_array($plannedStartDate) && empty($plannedStartDate))) {
            unset($this->PlannedStartDate);
        } else {
            $this->PlannedStartDate = $plannedStartDate;
        }
        return $this;
    }
    /**
     * Get StartDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DateTimeValue|null
     */
    public function getStartDate()
    {
        return isset($this->StartDate) ? $this->StartDate : null;
    }
    /**
     * Set StartDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DateTimeValue $startDate
     * @return \StructType\ProjectTaskProperties
     */
    public function setStartDate(\StructType\DateTimeValue $startDate = null)
    {
        if (is_null($startDate) || (is_array($startDate) && empty($startDate))) {
            unset($this->StartDate);
        } else {
            $this->StartDate = $startDate;
        }
        return $this;
    }
}
