<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProjectBilling StructType
 * @subpackage Structs
 */
class ProjectBilling extends Entity
{
    /**
     * The Customer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Customer;
    /**
     * The CustomerClass
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $CustomerClass;
    /**
     * The Details
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Details
     */
    public $Details;
    /**
     * The InvoiceDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DateTimeValue
     */
    public $InvoiceDate;
    /**
     * The PostPeriod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $PostPeriod;
    /**
     * The ProjectTemplate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ProjectTemplate;
    /**
     * The StatementCycle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $StatementCycle;
    /**
     * Constructor method for ProjectBilling
     * @uses ProjectBilling::setCustomer()
     * @uses ProjectBilling::setCustomerClass()
     * @uses ProjectBilling::setDetails()
     * @uses ProjectBilling::setInvoiceDate()
     * @uses ProjectBilling::setPostPeriod()
     * @uses ProjectBilling::setProjectTemplate()
     * @uses ProjectBilling::setStatementCycle()
     * @param \StructType\StringValue $customer
     * @param \StructType\StringValue $customerClass
     * @param \StructType\Details $details
     * @param \StructType\DateTimeValue $invoiceDate
     * @param \StructType\StringValue $postPeriod
     * @param \StructType\StringValue $projectTemplate
     * @param \StructType\StringValue $statementCycle
     */
    public function __construct(\StructType\StringValue $customer = null, \StructType\StringValue $customerClass = null, \StructType\Details $details = null, \StructType\DateTimeValue $invoiceDate = null, \StructType\StringValue $postPeriod = null, \StructType\StringValue $projectTemplate = null, \StructType\StringValue $statementCycle = null)
    {
        $this
            ->setCustomer($customer)
            ->setCustomerClass($customerClass)
            ->setDetails($details)
            ->setInvoiceDate($invoiceDate)
            ->setPostPeriod($postPeriod)
            ->setProjectTemplate($projectTemplate)
            ->setStatementCycle($statementCycle);
    }
    /**
     * Get Customer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getCustomer()
    {
        return isset($this->Customer) ? $this->Customer : null;
    }
    /**
     * Set Customer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $customer
     * @return \StructType\ProjectBilling
     */
    public function setCustomer(\StructType\StringValue $customer = null)
    {
        if (is_null($customer) || (is_array($customer) && empty($customer))) {
            unset($this->Customer);
        } else {
            $this->Customer = $customer;
        }
        return $this;
    }
    /**
     * Get CustomerClass value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getCustomerClass()
    {
        return isset($this->CustomerClass) ? $this->CustomerClass : null;
    }
    /**
     * Set CustomerClass value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $customerClass
     * @return \StructType\ProjectBilling
     */
    public function setCustomerClass(\StructType\StringValue $customerClass = null)
    {
        if (is_null($customerClass) || (is_array($customerClass) && empty($customerClass))) {
            unset($this->CustomerClass);
        } else {
            $this->CustomerClass = $customerClass;
        }
        return $this;
    }
    /**
     * Get Details value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Details|null
     */
    public function getDetails()
    {
        return isset($this->Details) ? $this->Details : null;
    }
    /**
     * Set Details value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Details $details
     * @return \StructType\ProjectBilling
     */
    public function setDetails(\StructType\Details $details = null)
    {
        if (is_null($details) || (is_array($details) && empty($details))) {
            unset($this->Details);
        } else {
            $this->Details = $details;
        }
        return $this;
    }
    /**
     * Get InvoiceDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DateTimeValue|null
     */
    public function getInvoiceDate()
    {
        return isset($this->InvoiceDate) ? $this->InvoiceDate : null;
    }
    /**
     * Set InvoiceDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DateTimeValue $invoiceDate
     * @return \StructType\ProjectBilling
     */
    public function setInvoiceDate(\StructType\DateTimeValue $invoiceDate = null)
    {
        if (is_null($invoiceDate) || (is_array($invoiceDate) && empty($invoiceDate))) {
            unset($this->InvoiceDate);
        } else {
            $this->InvoiceDate = $invoiceDate;
        }
        return $this;
    }
    /**
     * Get PostPeriod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getPostPeriod()
    {
        return isset($this->PostPeriod) ? $this->PostPeriod : null;
    }
    /**
     * Set PostPeriod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $postPeriod
     * @return \StructType\ProjectBilling
     */
    public function setPostPeriod(\StructType\StringValue $postPeriod = null)
    {
        if (is_null($postPeriod) || (is_array($postPeriod) && empty($postPeriod))) {
            unset($this->PostPeriod);
        } else {
            $this->PostPeriod = $postPeriod;
        }
        return $this;
    }
    /**
     * Get ProjectTemplate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getProjectTemplate()
    {
        return isset($this->ProjectTemplate) ? $this->ProjectTemplate : null;
    }
    /**
     * Set ProjectTemplate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $projectTemplate
     * @return \StructType\ProjectBilling
     */
    public function setProjectTemplate(\StructType\StringValue $projectTemplate = null)
    {
        if (is_null($projectTemplate) || (is_array($projectTemplate) && empty($projectTemplate))) {
            unset($this->ProjectTemplate);
        } else {
            $this->ProjectTemplate = $projectTemplate;
        }
        return $this;
    }
    /**
     * Get StatementCycle value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getStatementCycle()
    {
        return isset($this->StatementCycle) ? $this->StatementCycle : null;
    }
    /**
     * Set StatementCycle value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $statementCycle
     * @return \StructType\ProjectBilling
     */
    public function setStatementCycle(\StructType\StringValue $statementCycle = null)
    {
        if (is_null($statementCycle) || (is_array($statementCycle) && empty($statementCycle))) {
            unset($this->StatementCycle);
        } else {
            $this->StatementCycle = $statementCycle;
        }
        return $this;
    }
}
