<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProjectActivity StructType
 * @subpackage Structs
 */
class ProjectActivity extends Entity
{
    /**
     * The Billable
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $Billable;
    /**
     * The BillableOvertime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $BillableOvertime;
    /**
     * The BillableTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $BillableTime;
    /**
     * The Category
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Category;
    /**
     * The Overtime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Overtime;
    /**
     * The Owner
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Owner;
    /**
     * The StartDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DateTimeValue
     */
    public $StartDate;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Status;
    /**
     * The Summary
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Summary;
    /**
     * The TimeSpent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $TimeSpent;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Type;
    /**
     * The Workgroup
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Workgroup;
    /**
     * Constructor method for ProjectActivity
     * @uses ProjectActivity::setBillable()
     * @uses ProjectActivity::setBillableOvertime()
     * @uses ProjectActivity::setBillableTime()
     * @uses ProjectActivity::setCategory()
     * @uses ProjectActivity::setOvertime()
     * @uses ProjectActivity::setOwner()
     * @uses ProjectActivity::setStartDate()
     * @uses ProjectActivity::setStatus()
     * @uses ProjectActivity::setSummary()
     * @uses ProjectActivity::setTimeSpent()
     * @uses ProjectActivity::setType()
     * @uses ProjectActivity::setWorkgroup()
     * @param \StructType\BooleanValue $billable
     * @param \StructType\StringValue $billableOvertime
     * @param \StructType\StringValue $billableTime
     * @param \StructType\StringValue $category
     * @param \StructType\StringValue $overtime
     * @param \StructType\StringValue $owner
     * @param \StructType\DateTimeValue $startDate
     * @param \StructType\StringValue $status
     * @param \StructType\StringValue $summary
     * @param \StructType\StringValue $timeSpent
     * @param \StructType\StringValue $type
     * @param \StructType\StringValue $workgroup
     */
    public function __construct(\StructType\BooleanValue $billable = null, \StructType\StringValue $billableOvertime = null, \StructType\StringValue $billableTime = null, \StructType\StringValue $category = null, \StructType\StringValue $overtime = null, \StructType\StringValue $owner = null, \StructType\DateTimeValue $startDate = null, \StructType\StringValue $status = null, \StructType\StringValue $summary = null, \StructType\StringValue $timeSpent = null, \StructType\StringValue $type = null, \StructType\StringValue $workgroup = null)
    {
        $this
            ->setBillable($billable)
            ->setBillableOvertime($billableOvertime)
            ->setBillableTime($billableTime)
            ->setCategory($category)
            ->setOvertime($overtime)
            ->setOwner($owner)
            ->setStartDate($startDate)
            ->setStatus($status)
            ->setSummary($summary)
            ->setTimeSpent($timeSpent)
            ->setType($type)
            ->setWorkgroup($workgroup);
    }
    /**
     * Get Billable value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getBillable()
    {
        return isset($this->Billable) ? $this->Billable : null;
    }
    /**
     * Set Billable value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $billable
     * @return \StructType\ProjectActivity
     */
    public function setBillable(\StructType\BooleanValue $billable = null)
    {
        if (is_null($billable) || (is_array($billable) && empty($billable))) {
            unset($this->Billable);
        } else {
            $this->Billable = $billable;
        }
        return $this;
    }
    /**
     * Get BillableOvertime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getBillableOvertime()
    {
        return isset($this->BillableOvertime) ? $this->BillableOvertime : null;
    }
    /**
     * Set BillableOvertime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $billableOvertime
     * @return \StructType\ProjectActivity
     */
    public function setBillableOvertime(\StructType\StringValue $billableOvertime = null)
    {
        if (is_null($billableOvertime) || (is_array($billableOvertime) && empty($billableOvertime))) {
            unset($this->BillableOvertime);
        } else {
            $this->BillableOvertime = $billableOvertime;
        }
        return $this;
    }
    /**
     * Get BillableTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getBillableTime()
    {
        return isset($this->BillableTime) ? $this->BillableTime : null;
    }
    /**
     * Set BillableTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $billableTime
     * @return \StructType\ProjectActivity
     */
    public function setBillableTime(\StructType\StringValue $billableTime = null)
    {
        if (is_null($billableTime) || (is_array($billableTime) && empty($billableTime))) {
            unset($this->BillableTime);
        } else {
            $this->BillableTime = $billableTime;
        }
        return $this;
    }
    /**
     * Get Category value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getCategory()
    {
        return isset($this->Category) ? $this->Category : null;
    }
    /**
     * Set Category value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $category
     * @return \StructType\ProjectActivity
     */
    public function setCategory(\StructType\StringValue $category = null)
    {
        if (is_null($category) || (is_array($category) && empty($category))) {
            unset($this->Category);
        } else {
            $this->Category = $category;
        }
        return $this;
    }
    /**
     * Get Overtime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getOvertime()
    {
        return isset($this->Overtime) ? $this->Overtime : null;
    }
    /**
     * Set Overtime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $overtime
     * @return \StructType\ProjectActivity
     */
    public function setOvertime(\StructType\StringValue $overtime = null)
    {
        if (is_null($overtime) || (is_array($overtime) && empty($overtime))) {
            unset($this->Overtime);
        } else {
            $this->Overtime = $overtime;
        }
        return $this;
    }
    /**
     * Get Owner value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getOwner()
    {
        return isset($this->Owner) ? $this->Owner : null;
    }
    /**
     * Set Owner value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $owner
     * @return \StructType\ProjectActivity
     */
    public function setOwner(\StructType\StringValue $owner = null)
    {
        if (is_null($owner) || (is_array($owner) && empty($owner))) {
            unset($this->Owner);
        } else {
            $this->Owner = $owner;
        }
        return $this;
    }
    /**
     * Get StartDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DateTimeValue|null
     */
    public function getStartDate()
    {
        return isset($this->StartDate) ? $this->StartDate : null;
    }
    /**
     * Set StartDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DateTimeValue $startDate
     * @return \StructType\ProjectActivity
     */
    public function setStartDate(\StructType\DateTimeValue $startDate = null)
    {
        if (is_null($startDate) || (is_array($startDate) && empty($startDate))) {
            unset($this->StartDate);
        } else {
            $this->StartDate = $startDate;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $status
     * @return \StructType\ProjectActivity
     */
    public function setStatus(\StructType\StringValue $status = null)
    {
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get Summary value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getSummary()
    {
        return isset($this->Summary) ? $this->Summary : null;
    }
    /**
     * Set Summary value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $summary
     * @return \StructType\ProjectActivity
     */
    public function setSummary(\StructType\StringValue $summary = null)
    {
        if (is_null($summary) || (is_array($summary) && empty($summary))) {
            unset($this->Summary);
        } else {
            $this->Summary = $summary;
        }
        return $this;
    }
    /**
     * Get TimeSpent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getTimeSpent()
    {
        return isset($this->TimeSpent) ? $this->TimeSpent : null;
    }
    /**
     * Set TimeSpent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $timeSpent
     * @return \StructType\ProjectActivity
     */
    public function setTimeSpent(\StructType\StringValue $timeSpent = null)
    {
        if (is_null($timeSpent) || (is_array($timeSpent) && empty($timeSpent))) {
            unset($this->TimeSpent);
        } else {
            $this->TimeSpent = $timeSpent;
        }
        return $this;
    }
    /**
     * Get Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getType()
    {
        return isset($this->Type) ? $this->Type : null;
    }
    /**
     * Set Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $type
     * @return \StructType\ProjectActivity
     */
    public function setType(\StructType\StringValue $type = null)
    {
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->Type);
        } else {
            $this->Type = $type;
        }
        return $this;
    }
    /**
     * Get Workgroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getWorkgroup()
    {
        return isset($this->Workgroup) ? $this->Workgroup : null;
    }
    /**
     * Set Workgroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $workgroup
     * @return \StructType\ProjectActivity
     */
    public function setWorkgroup(\StructType\StringValue $workgroup = null)
    {
        if (is_null($workgroup) || (is_array($workgroup) && empty($workgroup))) {
            unset($this->Workgroup);
        } else {
            $this->Workgroup = $workgroup;
        }
        return $this;
    }
}
