<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InterBranchAccountMapping StructType
 * @subpackage Structs
 */
class InterBranchAccountMapping extends Entity
{
    /**
     * The OriginatingBranch
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $OriginatingBranch;
    /**
     * The PostingLedger
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $PostingLedger;
    /**
     * The TransactionsInDestinationBranch
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\TransactionsInDestinationBranch
     */
    public $TransactionsInDestinationBranch;
    /**
     * The TransactionsInSourceBranch
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\TransactionsInSourceBranch
     */
    public $TransactionsInSourceBranch;
    /**
     * Constructor method for InterBranchAccountMapping
     * @uses InterBranchAccountMapping::setOriginatingBranch()
     * @uses InterBranchAccountMapping::setPostingLedger()
     * @uses InterBranchAccountMapping::setTransactionsInDestinationBranch()
     * @uses InterBranchAccountMapping::setTransactionsInSourceBranch()
     * @param \StructType\StringValue $originatingBranch
     * @param \StructType\StringValue $postingLedger
     * @param \StructType\TransactionsInDestinationBranch $transactionsInDestinationBranch
     * @param \StructType\TransactionsInSourceBranch $transactionsInSourceBranch
     */
    public function __construct(\StructType\StringValue $originatingBranch = null, \StructType\StringValue $postingLedger = null, \StructType\TransactionsInDestinationBranch $transactionsInDestinationBranch = null, \StructType\TransactionsInSourceBranch $transactionsInSourceBranch = null)
    {
        $this
            ->setOriginatingBranch($originatingBranch)
            ->setPostingLedger($postingLedger)
            ->setTransactionsInDestinationBranch($transactionsInDestinationBranch)
            ->setTransactionsInSourceBranch($transactionsInSourceBranch);
    }
    /**
     * Get OriginatingBranch value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getOriginatingBranch()
    {
        return isset($this->OriginatingBranch) ? $this->OriginatingBranch : null;
    }
    /**
     * Set OriginatingBranch value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $originatingBranch
     * @return \StructType\InterBranchAccountMapping
     */
    public function setOriginatingBranch(\StructType\StringValue $originatingBranch = null)
    {
        if (is_null($originatingBranch) || (is_array($originatingBranch) && empty($originatingBranch))) {
            unset($this->OriginatingBranch);
        } else {
            $this->OriginatingBranch = $originatingBranch;
        }
        return $this;
    }
    /**
     * Get PostingLedger value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getPostingLedger()
    {
        return isset($this->PostingLedger) ? $this->PostingLedger : null;
    }
    /**
     * Set PostingLedger value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $postingLedger
     * @return \StructType\InterBranchAccountMapping
     */
    public function setPostingLedger(\StructType\StringValue $postingLedger = null)
    {
        if (is_null($postingLedger) || (is_array($postingLedger) && empty($postingLedger))) {
            unset($this->PostingLedger);
        } else {
            $this->PostingLedger = $postingLedger;
        }
        return $this;
    }
    /**
     * Get TransactionsInDestinationBranch value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\TransactionsInDestinationBranch|null
     */
    public function getTransactionsInDestinationBranch()
    {
        return isset($this->TransactionsInDestinationBranch) ? $this->TransactionsInDestinationBranch : null;
    }
    /**
     * Set TransactionsInDestinationBranch value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\TransactionsInDestinationBranch $transactionsInDestinationBranch
     * @return \StructType\InterBranchAccountMapping
     */
    public function setTransactionsInDestinationBranch(\StructType\TransactionsInDestinationBranch $transactionsInDestinationBranch = null)
    {
        if (is_null($transactionsInDestinationBranch) || (is_array($transactionsInDestinationBranch) && empty($transactionsInDestinationBranch))) {
            unset($this->TransactionsInDestinationBranch);
        } else {
            $this->TransactionsInDestinationBranch = $transactionsInDestinationBranch;
        }
        return $this;
    }
    /**
     * Get TransactionsInSourceBranch value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\TransactionsInSourceBranch|null
     */
    public function getTransactionsInSourceBranch()
    {
        return isset($this->TransactionsInSourceBranch) ? $this->TransactionsInSourceBranch : null;
    }
    /**
     * Set TransactionsInSourceBranch value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\TransactionsInSourceBranch $transactionsInSourceBranch
     * @return \StructType\InterBranchAccountMapping
     */
    public function setTransactionsInSourceBranch(\StructType\TransactionsInSourceBranch $transactionsInSourceBranch = null)
    {
        if (is_null($transactionsInSourceBranch) || (is_array($transactionsInSourceBranch) && empty($transactionsInSourceBranch))) {
            unset($this->TransactionsInSourceBranch);
        } else {
            $this->TransactionsInSourceBranch = $transactionsInSourceBranch;
        }
        return $this;
    }
}
