<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExpenseClaim StructType
 * @subpackage Structs
 */
class ExpenseClaim extends Entity
{
    /**
     * The ApprovalDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DateTimeValue
     */
    public $ApprovalDate;
    /**
     * The ApprovalDetails
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ApprovalDetails
     */
    public $ApprovalDetails;
    /**
     * The BaseCurrencyID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $BaseCurrencyID;
    /**
     * The ClaimedBy
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ClaimedBy;
    /**
     * The ClaimTotal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $ClaimTotal;
    /**
     * The CurrencyID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $CurrencyID;
    /**
     * The CurrencyRate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $CurrencyRate;
    /**
     * The CustomerID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $CustomerID;
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DateTimeValue
     */
    public $Date;
    /**
     * The DepartmentID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $DepartmentID;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Description;
    /**
     * The Details
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Details
     */
    public $Details;
    /**
     * The FinancialDetails
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ExpenseClaimFinancialDetail
     */
    public $FinancialDetails;
    /**
     * The LastModifiedDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DateTimeValue
     */
    public $LastModifiedDateTime;
    /**
     * The LocationID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $LocationID;
    /**
     * The ReciprocalRate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $ReciprocalRate;
    /**
     * The RefNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $RefNbr;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Status;
    /**
     * The TaxDetails
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\TaxDetails
     */
    public $TaxDetails;
    /**
     * The TaxTotal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $TaxTotal;
    /**
     * The VATExemptTotal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $VATExemptTotal;
    /**
     * The VATTaxableTotal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $VATTaxableTotal;
    /**
     * Constructor method for ExpenseClaim
     * @uses ExpenseClaim::setApprovalDate()
     * @uses ExpenseClaim::setApprovalDetails()
     * @uses ExpenseClaim::setBaseCurrencyID()
     * @uses ExpenseClaim::setClaimedBy()
     * @uses ExpenseClaim::setClaimTotal()
     * @uses ExpenseClaim::setCurrencyID()
     * @uses ExpenseClaim::setCurrencyRate()
     * @uses ExpenseClaim::setCustomerID()
     * @uses ExpenseClaim::setDate()
     * @uses ExpenseClaim::setDepartmentID()
     * @uses ExpenseClaim::setDescription()
     * @uses ExpenseClaim::setDetails()
     * @uses ExpenseClaim::setFinancialDetails()
     * @uses ExpenseClaim::setLastModifiedDateTime()
     * @uses ExpenseClaim::setLocationID()
     * @uses ExpenseClaim::setReciprocalRate()
     * @uses ExpenseClaim::setRefNbr()
     * @uses ExpenseClaim::setStatus()
     * @uses ExpenseClaim::setTaxDetails()
     * @uses ExpenseClaim::setTaxTotal()
     * @uses ExpenseClaim::setVATExemptTotal()
     * @uses ExpenseClaim::setVATTaxableTotal()
     * @param \StructType\DateTimeValue $approvalDate
     * @param \StructType\ApprovalDetails $approvalDetails
     * @param \StructType\StringValue $baseCurrencyID
     * @param \StructType\StringValue $claimedBy
     * @param \StructType\DecimalValue $claimTotal
     * @param \StructType\StringValue $currencyID
     * @param \StructType\DecimalValue $currencyRate
     * @param \StructType\StringValue $customerID
     * @param \StructType\DateTimeValue $date
     * @param \StructType\StringValue $departmentID
     * @param \StructType\StringValue $description
     * @param \StructType\Details $details
     * @param \StructType\ExpenseClaimFinancialDetail $financialDetails
     * @param \StructType\DateTimeValue $lastModifiedDateTime
     * @param \StructType\StringValue $locationID
     * @param \StructType\DecimalValue $reciprocalRate
     * @param \StructType\StringValue $refNbr
     * @param \StructType\StringValue $status
     * @param \StructType\TaxDetails $taxDetails
     * @param \StructType\DecimalValue $taxTotal
     * @param \StructType\DecimalValue $vATExemptTotal
     * @param \StructType\DecimalValue $vATTaxableTotal
     */
    public function __construct(\StructType\DateTimeValue $approvalDate = null, \StructType\ApprovalDetails $approvalDetails = null, \StructType\StringValue $baseCurrencyID = null, \StructType\StringValue $claimedBy = null, \StructType\DecimalValue $claimTotal = null, \StructType\StringValue $currencyID = null, \StructType\DecimalValue $currencyRate = null, \StructType\StringValue $customerID = null, \StructType\DateTimeValue $date = null, \StructType\StringValue $departmentID = null, \StructType\StringValue $description = null, \StructType\Details $details = null, \StructType\ExpenseClaimFinancialDetail $financialDetails = null, \StructType\DateTimeValue $lastModifiedDateTime = null, \StructType\StringValue $locationID = null, \StructType\DecimalValue $reciprocalRate = null, \StructType\StringValue $refNbr = null, \StructType\StringValue $status = null, \StructType\TaxDetails $taxDetails = null, \StructType\DecimalValue $taxTotal = null, \StructType\DecimalValue $vATExemptTotal = null, \StructType\DecimalValue $vATTaxableTotal = null)
    {
        $this
            ->setApprovalDate($approvalDate)
            ->setApprovalDetails($approvalDetails)
            ->setBaseCurrencyID($baseCurrencyID)
            ->setClaimedBy($claimedBy)
            ->setClaimTotal($claimTotal)
            ->setCurrencyID($currencyID)
            ->setCurrencyRate($currencyRate)
            ->setCustomerID($customerID)
            ->setDate($date)
            ->setDepartmentID($departmentID)
            ->setDescription($description)
            ->setDetails($details)
            ->setFinancialDetails($financialDetails)
            ->setLastModifiedDateTime($lastModifiedDateTime)
            ->setLocationID($locationID)
            ->setReciprocalRate($reciprocalRate)
            ->setRefNbr($refNbr)
            ->setStatus($status)
            ->setTaxDetails($taxDetails)
            ->setTaxTotal($taxTotal)
            ->setVATExemptTotal($vATExemptTotal)
            ->setVATTaxableTotal($vATTaxableTotal);
    }
    /**
     * Get ApprovalDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DateTimeValue|null
     */
    public function getApprovalDate()
    {
        return isset($this->ApprovalDate) ? $this->ApprovalDate : null;
    }
    /**
     * Set ApprovalDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DateTimeValue $approvalDate
     * @return \StructType\ExpenseClaim
     */
    public function setApprovalDate(\StructType\DateTimeValue $approvalDate = null)
    {
        if (is_null($approvalDate) || (is_array($approvalDate) && empty($approvalDate))) {
            unset($this->ApprovalDate);
        } else {
            $this->ApprovalDate = $approvalDate;
        }
        return $this;
    }
    /**
     * Get ApprovalDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ApprovalDetails|null
     */
    public function getApprovalDetails()
    {
        return isset($this->ApprovalDetails) ? $this->ApprovalDetails : null;
    }
    /**
     * Set ApprovalDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ApprovalDetails $approvalDetails
     * @return \StructType\ExpenseClaim
     */
    public function setApprovalDetails(\StructType\ApprovalDetails $approvalDetails = null)
    {
        if (is_null($approvalDetails) || (is_array($approvalDetails) && empty($approvalDetails))) {
            unset($this->ApprovalDetails);
        } else {
            $this->ApprovalDetails = $approvalDetails;
        }
        return $this;
    }
    /**
     * Get BaseCurrencyID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getBaseCurrencyID()
    {
        return isset($this->BaseCurrencyID) ? $this->BaseCurrencyID : null;
    }
    /**
     * Set BaseCurrencyID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $baseCurrencyID
     * @return \StructType\ExpenseClaim
     */
    public function setBaseCurrencyID(\StructType\StringValue $baseCurrencyID = null)
    {
        if (is_null($baseCurrencyID) || (is_array($baseCurrencyID) && empty($baseCurrencyID))) {
            unset($this->BaseCurrencyID);
        } else {
            $this->BaseCurrencyID = $baseCurrencyID;
        }
        return $this;
    }
    /**
     * Get ClaimedBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getClaimedBy()
    {
        return isset($this->ClaimedBy) ? $this->ClaimedBy : null;
    }
    /**
     * Set ClaimedBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $claimedBy
     * @return \StructType\ExpenseClaim
     */
    public function setClaimedBy(\StructType\StringValue $claimedBy = null)
    {
        if (is_null($claimedBy) || (is_array($claimedBy) && empty($claimedBy))) {
            unset($this->ClaimedBy);
        } else {
            $this->ClaimedBy = $claimedBy;
        }
        return $this;
    }
    /**
     * Get ClaimTotal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getClaimTotal()
    {
        return isset($this->ClaimTotal) ? $this->ClaimTotal : null;
    }
    /**
     * Set ClaimTotal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $claimTotal
     * @return \StructType\ExpenseClaim
     */
    public function setClaimTotal(\StructType\DecimalValue $claimTotal = null)
    {
        if (is_null($claimTotal) || (is_array($claimTotal) && empty($claimTotal))) {
            unset($this->ClaimTotal);
        } else {
            $this->ClaimTotal = $claimTotal;
        }
        return $this;
    }
    /**
     * Get CurrencyID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getCurrencyID()
    {
        return isset($this->CurrencyID) ? $this->CurrencyID : null;
    }
    /**
     * Set CurrencyID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $currencyID
     * @return \StructType\ExpenseClaim
     */
    public function setCurrencyID(\StructType\StringValue $currencyID = null)
    {
        if (is_null($currencyID) || (is_array($currencyID) && empty($currencyID))) {
            unset($this->CurrencyID);
        } else {
            $this->CurrencyID = $currencyID;
        }
        return $this;
    }
    /**
     * Get CurrencyRate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getCurrencyRate()
    {
        return isset($this->CurrencyRate) ? $this->CurrencyRate : null;
    }
    /**
     * Set CurrencyRate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $currencyRate
     * @return \StructType\ExpenseClaim
     */
    public function setCurrencyRate(\StructType\DecimalValue $currencyRate = null)
    {
        if (is_null($currencyRate) || (is_array($currencyRate) && empty($currencyRate))) {
            unset($this->CurrencyRate);
        } else {
            $this->CurrencyRate = $currencyRate;
        }
        return $this;
    }
    /**
     * Get CustomerID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getCustomerID()
    {
        return isset($this->CustomerID) ? $this->CustomerID : null;
    }
    /**
     * Set CustomerID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $customerID
     * @return \StructType\ExpenseClaim
     */
    public function setCustomerID(\StructType\StringValue $customerID = null)
    {
        if (is_null($customerID) || (is_array($customerID) && empty($customerID))) {
            unset($this->CustomerID);
        } else {
            $this->CustomerID = $customerID;
        }
        return $this;
    }
    /**
     * Get Date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DateTimeValue|null
     */
    public function getDate()
    {
        return isset($this->Date) ? $this->Date : null;
    }
    /**
     * Set Date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DateTimeValue $date
     * @return \StructType\ExpenseClaim
     */
    public function setDate(\StructType\DateTimeValue $date = null)
    {
        if (is_null($date) || (is_array($date) && empty($date))) {
            unset($this->Date);
        } else {
            $this->Date = $date;
        }
        return $this;
    }
    /**
     * Get DepartmentID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getDepartmentID()
    {
        return isset($this->DepartmentID) ? $this->DepartmentID : null;
    }
    /**
     * Set DepartmentID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $departmentID
     * @return \StructType\ExpenseClaim
     */
    public function setDepartmentID(\StructType\StringValue $departmentID = null)
    {
        if (is_null($departmentID) || (is_array($departmentID) && empty($departmentID))) {
            unset($this->DepartmentID);
        } else {
            $this->DepartmentID = $departmentID;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $description
     * @return \StructType\ExpenseClaim
     */
    public function setDescription(\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get Details value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Details|null
     */
    public function getDetails()
    {
        return isset($this->Details) ? $this->Details : null;
    }
    /**
     * Set Details value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Details $details
     * @return \StructType\ExpenseClaim
     */
    public function setDetails(\StructType\Details $details = null)
    {
        if (is_null($details) || (is_array($details) && empty($details))) {
            unset($this->Details);
        } else {
            $this->Details = $details;
        }
        return $this;
    }
    /**
     * Get FinancialDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ExpenseClaimFinancialDetail|null
     */
    public function getFinancialDetails()
    {
        return isset($this->FinancialDetails) ? $this->FinancialDetails : null;
    }
    /**
     * Set FinancialDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ExpenseClaimFinancialDetail $financialDetails
     * @return \StructType\ExpenseClaim
     */
    public function setFinancialDetails(\StructType\ExpenseClaimFinancialDetail $financialDetails = null)
    {
        if (is_null($financialDetails) || (is_array($financialDetails) && empty($financialDetails))) {
            unset($this->FinancialDetails);
        } else {
            $this->FinancialDetails = $financialDetails;
        }
        return $this;
    }
    /**
     * Get LastModifiedDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DateTimeValue|null
     */
    public function getLastModifiedDateTime()
    {
        return isset($this->LastModifiedDateTime) ? $this->LastModifiedDateTime : null;
    }
    /**
     * Set LastModifiedDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DateTimeValue $lastModifiedDateTime
     * @return \StructType\ExpenseClaim
     */
    public function setLastModifiedDateTime(\StructType\DateTimeValue $lastModifiedDateTime = null)
    {
        if (is_null($lastModifiedDateTime) || (is_array($lastModifiedDateTime) && empty($lastModifiedDateTime))) {
            unset($this->LastModifiedDateTime);
        } else {
            $this->LastModifiedDateTime = $lastModifiedDateTime;
        }
        return $this;
    }
    /**
     * Get LocationID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getLocationID()
    {
        return isset($this->LocationID) ? $this->LocationID : null;
    }
    /**
     * Set LocationID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $locationID
     * @return \StructType\ExpenseClaim
     */
    public function setLocationID(\StructType\StringValue $locationID = null)
    {
        if (is_null($locationID) || (is_array($locationID) && empty($locationID))) {
            unset($this->LocationID);
        } else {
            $this->LocationID = $locationID;
        }
        return $this;
    }
    /**
     * Get ReciprocalRate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getReciprocalRate()
    {
        return isset($this->ReciprocalRate) ? $this->ReciprocalRate : null;
    }
    /**
     * Set ReciprocalRate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $reciprocalRate
     * @return \StructType\ExpenseClaim
     */
    public function setReciprocalRate(\StructType\DecimalValue $reciprocalRate = null)
    {
        if (is_null($reciprocalRate) || (is_array($reciprocalRate) && empty($reciprocalRate))) {
            unset($this->ReciprocalRate);
        } else {
            $this->ReciprocalRate = $reciprocalRate;
        }
        return $this;
    }
    /**
     * Get RefNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getRefNbr()
    {
        return isset($this->RefNbr) ? $this->RefNbr : null;
    }
    /**
     * Set RefNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $refNbr
     * @return \StructType\ExpenseClaim
     */
    public function setRefNbr(\StructType\StringValue $refNbr = null)
    {
        if (is_null($refNbr) || (is_array($refNbr) && empty($refNbr))) {
            unset($this->RefNbr);
        } else {
            $this->RefNbr = $refNbr;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $status
     * @return \StructType\ExpenseClaim
     */
    public function setStatus(\StructType\StringValue $status = null)
    {
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get TaxDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\TaxDetails|null
     */
    public function getTaxDetails()
    {
        return isset($this->TaxDetails) ? $this->TaxDetails : null;
    }
    /**
     * Set TaxDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\TaxDetails $taxDetails
     * @return \StructType\ExpenseClaim
     */
    public function setTaxDetails(\StructType\TaxDetails $taxDetails = null)
    {
        if (is_null($taxDetails) || (is_array($taxDetails) && empty($taxDetails))) {
            unset($this->TaxDetails);
        } else {
            $this->TaxDetails = $taxDetails;
        }
        return $this;
    }
    /**
     * Get TaxTotal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getTaxTotal()
    {
        return isset($this->TaxTotal) ? $this->TaxTotal : null;
    }
    /**
     * Set TaxTotal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $taxTotal
     * @return \StructType\ExpenseClaim
     */
    public function setTaxTotal(\StructType\DecimalValue $taxTotal = null)
    {
        if (is_null($taxTotal) || (is_array($taxTotal) && empty($taxTotal))) {
            unset($this->TaxTotal);
        } else {
            $this->TaxTotal = $taxTotal;
        }
        return $this;
    }
    /**
     * Get VATExemptTotal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getVATExemptTotal()
    {
        return isset($this->VATExemptTotal) ? $this->VATExemptTotal : null;
    }
    /**
     * Set VATExemptTotal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $vATExemptTotal
     * @return \StructType\ExpenseClaim
     */
    public function setVATExemptTotal(\StructType\DecimalValue $vATExemptTotal = null)
    {
        if (is_null($vATExemptTotal) || (is_array($vATExemptTotal) && empty($vATExemptTotal))) {
            unset($this->VATExemptTotal);
        } else {
            $this->VATExemptTotal = $vATExemptTotal;
        }
        return $this;
    }
    /**
     * Get VATTaxableTotal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getVATTaxableTotal()
    {
        return isset($this->VATTaxableTotal) ? $this->VATTaxableTotal : null;
    }
    /**
     * Set VATTaxableTotal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $vATTaxableTotal
     * @return \StructType\ExpenseClaim
     */
    public function setVATTaxableTotal(\StructType\DecimalValue $vATTaxableTotal = null)
    {
        if (is_null($vATTaxableTotal) || (is_array($vATTaxableTotal) && empty($vATTaxableTotal))) {
            unset($this->VATTaxableTotal);
        } else {
            $this->VATTaxableTotal = $vATTaxableTotal;
        }
        return $this;
    }
}
