<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DiscountCustomerDetail StructType
 * @subpackage Structs
 */
class DiscountCustomerDetail extends Entity
{
    /**
     * The CustomerID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $CustomerID;
    /**
     * The CustomerName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $CustomerName;
    /**
     * Constructor method for DiscountCustomerDetail
     * @uses DiscountCustomerDetail::setCustomerID()
     * @uses DiscountCustomerDetail::setCustomerName()
     * @param \StructType\StringValue $customerID
     * @param \StructType\StringValue $customerName
     */
    public function __construct(\StructType\StringValue $customerID = null, \StructType\StringValue $customerName = null)
    {
        $this
            ->setCustomerID($customerID)
            ->setCustomerName($customerName);
    }
    /**
     * Get CustomerID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getCustomerID()
    {
        return isset($this->CustomerID) ? $this->CustomerID : null;
    }
    /**
     * Set CustomerID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $customerID
     * @return \StructType\DiscountCustomerDetail
     */
    public function setCustomerID(\StructType\StringValue $customerID = null)
    {
        if (is_null($customerID) || (is_array($customerID) && empty($customerID))) {
            unset($this->CustomerID);
        } else {
            $this->CustomerID = $customerID;
        }
        return $this;
    }
    /**
     * Get CustomerName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getCustomerName()
    {
        return isset($this->CustomerName) ? $this->CustomerName : null;
    }
    /**
     * Set CustomerName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $customerName
     * @return \StructType\DiscountCustomerDetail
     */
    public function setCustomerName(\StructType\StringValue $customerName = null)
    {
        if (is_null($customerName) || (is_array($customerName) && empty($customerName))) {
            unset($this->CustomerName);
        } else {
            $this->CustomerName = $customerName;
        }
        return $this;
    }
}
