<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Customers StructType
 * @subpackage Structs
 */
class Customers extends AbstractStructBase
{
    /**
     * The DiscountCustomerDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DiscountCustomerDetail[]
     */
    public $DiscountCustomerDetail;
    /**
     * Constructor method for Customers
     * @uses Customers::setDiscountCustomerDetail()
     * @param \StructType\DiscountCustomerDetail[] $discountCustomerDetail
     */
    public function __construct(array $discountCustomerDetail = array())
    {
        $this
            ->setDiscountCustomerDetail($discountCustomerDetail);
    }
    /**
     * Get DiscountCustomerDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DiscountCustomerDetail[]|null
     */
    public function getDiscountCustomerDetail()
    {
        return isset($this->DiscountCustomerDetail) ? $this->DiscountCustomerDetail : null;
    }
    /**
     * This method is responsible for validating the values passed to the setDiscountCustomerDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDiscountCustomerDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDiscountCustomerDetailForArrayConstraintsFromSetDiscountCustomerDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customersDiscountCustomerDetailItem) {
            // validation for constraint: itemType
            if (!$customersDiscountCustomerDetailItem instanceof \StructType\DiscountCustomerDetail) {
                $invalidValues[] = is_object($customersDiscountCustomerDetailItem) ? get_class($customersDiscountCustomerDetailItem) : sprintf('%s(%s)', gettype($customersDiscountCustomerDetailItem), var_export($customersDiscountCustomerDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DiscountCustomerDetail property can only contain items of type \StructType\DiscountCustomerDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DiscountCustomerDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\DiscountCustomerDetail[] $discountCustomerDetail
     * @return \StructType\Customers
     */
    public function setDiscountCustomerDetail(array $discountCustomerDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($discountCustomerDetailArrayErrorMessage = self::validateDiscountCustomerDetailForArrayConstraintsFromSetDiscountCustomerDetail($discountCustomerDetail))) {
            throw new \InvalidArgumentException($discountCustomerDetailArrayErrorMessage, __LINE__);
        }
        if (is_null($discountCustomerDetail) || (is_array($discountCustomerDetail) && empty($discountCustomerDetail))) {
            unset($this->DiscountCustomerDetail);
        } else {
            $this->DiscountCustomerDetail = $discountCustomerDetail;
        }
        return $this;
    }
    /**
     * Add item to DiscountCustomerDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\DiscountCustomerDetail $item
     * @return \StructType\Customers
     */
    public function addToDiscountCustomerDetail(\StructType\DiscountCustomerDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DiscountCustomerDetail) {
            throw new \InvalidArgumentException(sprintf('The DiscountCustomerDetail property can only contain items of type \StructType\DiscountCustomerDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DiscountCustomerDetail[] = $item;
        return $this;
    }
}
