<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerPaymentMethod StructType
 * @subpackage Structs
 */
class CustomerPaymentMethod extends Entity
{
    /**
     * The Active
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $Active;
    /**
     * The CardAccountNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $CardAccountNbr;
    /**
     * The CashAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $CashAccount;
    /**
     * The CreatedDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DateTimeValue
     */
    public $CreatedDateTime;
    /**
     * The CustomerID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $CustomerID;
    /**
     * The CustomerProfileID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $CustomerProfileID;
    /**
     * The Details
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Details
     */
    public $Details;
    /**
     * The InstanceID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\IntValue
     */
    public $InstanceID;
    /**
     * The LastModifiedDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DateTimeValue
     */
    public $LastModifiedDateTime;
    /**
     * The PaymentMethod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $PaymentMethod;
    /**
     * The ProcCenterID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ProcCenterID;
    /**
     * Constructor method for CustomerPaymentMethod
     * @uses CustomerPaymentMethod::setActive()
     * @uses CustomerPaymentMethod::setCardAccountNbr()
     * @uses CustomerPaymentMethod::setCashAccount()
     * @uses CustomerPaymentMethod::setCreatedDateTime()
     * @uses CustomerPaymentMethod::setCustomerID()
     * @uses CustomerPaymentMethod::setCustomerProfileID()
     * @uses CustomerPaymentMethod::setDetails()
     * @uses CustomerPaymentMethod::setInstanceID()
     * @uses CustomerPaymentMethod::setLastModifiedDateTime()
     * @uses CustomerPaymentMethod::setPaymentMethod()
     * @uses CustomerPaymentMethod::setProcCenterID()
     * @param \StructType\BooleanValue $active
     * @param \StructType\StringValue $cardAccountNbr
     * @param \StructType\StringValue $cashAccount
     * @param \StructType\DateTimeValue $createdDateTime
     * @param \StructType\StringValue $customerID
     * @param \StructType\StringValue $customerProfileID
     * @param \StructType\Details $details
     * @param \StructType\IntValue $instanceID
     * @param \StructType\DateTimeValue $lastModifiedDateTime
     * @param \StructType\StringValue $paymentMethod
     * @param \StructType\StringValue $procCenterID
     */
    public function __construct(\StructType\BooleanValue $active = null, \StructType\StringValue $cardAccountNbr = null, \StructType\StringValue $cashAccount = null, \StructType\DateTimeValue $createdDateTime = null, \StructType\StringValue $customerID = null, \StructType\StringValue $customerProfileID = null, \StructType\Details $details = null, \StructType\IntValue $instanceID = null, \StructType\DateTimeValue $lastModifiedDateTime = null, \StructType\StringValue $paymentMethod = null, \StructType\StringValue $procCenterID = null)
    {
        $this
            ->setActive($active)
            ->setCardAccountNbr($cardAccountNbr)
            ->setCashAccount($cashAccount)
            ->setCreatedDateTime($createdDateTime)
            ->setCustomerID($customerID)
            ->setCustomerProfileID($customerProfileID)
            ->setDetails($details)
            ->setInstanceID($instanceID)
            ->setLastModifiedDateTime($lastModifiedDateTime)
            ->setPaymentMethod($paymentMethod)
            ->setProcCenterID($procCenterID);
    }
    /**
     * Get Active value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getActive()
    {
        return isset($this->Active) ? $this->Active : null;
    }
    /**
     * Set Active value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $active
     * @return \StructType\CustomerPaymentMethod
     */
    public function setActive(\StructType\BooleanValue $active = null)
    {
        if (is_null($active) || (is_array($active) && empty($active))) {
            unset($this->Active);
        } else {
            $this->Active = $active;
        }
        return $this;
    }
    /**
     * Get CardAccountNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getCardAccountNbr()
    {
        return isset($this->CardAccountNbr) ? $this->CardAccountNbr : null;
    }
    /**
     * Set CardAccountNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $cardAccountNbr
     * @return \StructType\CustomerPaymentMethod
     */
    public function setCardAccountNbr(\StructType\StringValue $cardAccountNbr = null)
    {
        if (is_null($cardAccountNbr) || (is_array($cardAccountNbr) && empty($cardAccountNbr))) {
            unset($this->CardAccountNbr);
        } else {
            $this->CardAccountNbr = $cardAccountNbr;
        }
        return $this;
    }
    /**
     * Get CashAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getCashAccount()
    {
        return isset($this->CashAccount) ? $this->CashAccount : null;
    }
    /**
     * Set CashAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $cashAccount
     * @return \StructType\CustomerPaymentMethod
     */
    public function setCashAccount(\StructType\StringValue $cashAccount = null)
    {
        if (is_null($cashAccount) || (is_array($cashAccount) && empty($cashAccount))) {
            unset($this->CashAccount);
        } else {
            $this->CashAccount = $cashAccount;
        }
        return $this;
    }
    /**
     * Get CreatedDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DateTimeValue|null
     */
    public function getCreatedDateTime()
    {
        return isset($this->CreatedDateTime) ? $this->CreatedDateTime : null;
    }
    /**
     * Set CreatedDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DateTimeValue $createdDateTime
     * @return \StructType\CustomerPaymentMethod
     */
    public function setCreatedDateTime(\StructType\DateTimeValue $createdDateTime = null)
    {
        if (is_null($createdDateTime) || (is_array($createdDateTime) && empty($createdDateTime))) {
            unset($this->CreatedDateTime);
        } else {
            $this->CreatedDateTime = $createdDateTime;
        }
        return $this;
    }
    /**
     * Get CustomerID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getCustomerID()
    {
        return isset($this->CustomerID) ? $this->CustomerID : null;
    }
    /**
     * Set CustomerID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $customerID
     * @return \StructType\CustomerPaymentMethod
     */
    public function setCustomerID(\StructType\StringValue $customerID = null)
    {
        if (is_null($customerID) || (is_array($customerID) && empty($customerID))) {
            unset($this->CustomerID);
        } else {
            $this->CustomerID = $customerID;
        }
        return $this;
    }
    /**
     * Get CustomerProfileID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getCustomerProfileID()
    {
        return isset($this->CustomerProfileID) ? $this->CustomerProfileID : null;
    }
    /**
     * Set CustomerProfileID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $customerProfileID
     * @return \StructType\CustomerPaymentMethod
     */
    public function setCustomerProfileID(\StructType\StringValue $customerProfileID = null)
    {
        if (is_null($customerProfileID) || (is_array($customerProfileID) && empty($customerProfileID))) {
            unset($this->CustomerProfileID);
        } else {
            $this->CustomerProfileID = $customerProfileID;
        }
        return $this;
    }
    /**
     * Get Details value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Details|null
     */
    public function getDetails()
    {
        return isset($this->Details) ? $this->Details : null;
    }
    /**
     * Set Details value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Details $details
     * @return \StructType\CustomerPaymentMethod
     */
    public function setDetails(\StructType\Details $details = null)
    {
        if (is_null($details) || (is_array($details) && empty($details))) {
            unset($this->Details);
        } else {
            $this->Details = $details;
        }
        return $this;
    }
    /**
     * Get InstanceID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\IntValue|null
     */
    public function getInstanceID()
    {
        return isset($this->InstanceID) ? $this->InstanceID : null;
    }
    /**
     * Set InstanceID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\IntValue $instanceID
     * @return \StructType\CustomerPaymentMethod
     */
    public function setInstanceID(\StructType\IntValue $instanceID = null)
    {
        if (is_null($instanceID) || (is_array($instanceID) && empty($instanceID))) {
            unset($this->InstanceID);
        } else {
            $this->InstanceID = $instanceID;
        }
        return $this;
    }
    /**
     * Get LastModifiedDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DateTimeValue|null
     */
    public function getLastModifiedDateTime()
    {
        return isset($this->LastModifiedDateTime) ? $this->LastModifiedDateTime : null;
    }
    /**
     * Set LastModifiedDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DateTimeValue $lastModifiedDateTime
     * @return \StructType\CustomerPaymentMethod
     */
    public function setLastModifiedDateTime(\StructType\DateTimeValue $lastModifiedDateTime = null)
    {
        if (is_null($lastModifiedDateTime) || (is_array($lastModifiedDateTime) && empty($lastModifiedDateTime))) {
            unset($this->LastModifiedDateTime);
        } else {
            $this->LastModifiedDateTime = $lastModifiedDateTime;
        }
        return $this;
    }
    /**
     * Get PaymentMethod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getPaymentMethod()
    {
        return isset($this->PaymentMethod) ? $this->PaymentMethod : null;
    }
    /**
     * Set PaymentMethod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $paymentMethod
     * @return \StructType\CustomerPaymentMethod
     */
    public function setPaymentMethod(\StructType\StringValue $paymentMethod = null)
    {
        if (is_null($paymentMethod) || (is_array($paymentMethod) && empty($paymentMethod))) {
            unset($this->PaymentMethod);
        } else {
            $this->PaymentMethod = $paymentMethod;
        }
        return $this;
    }
    /**
     * Get ProcCenterID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getProcCenterID()
    {
        return isset($this->ProcCenterID) ? $this->ProcCenterID : null;
    }
    /**
     * Set ProcCenterID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $procCenterID
     * @return \StructType\CustomerPaymentMethod
     */
    public function setProcCenterID(\StructType\StringValue $procCenterID = null)
    {
        if (is_null($procCenterID) || (is_array($procCenterID) && empty($procCenterID))) {
            unset($this->ProcCenterID);
        } else {
            $this->ProcCenterID = $procCenterID;
        }
        return $this;
    }
}
