<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BoxStockItem StructType
 * @subpackage Structs
 */
class BoxStockItem extends Entity
{
    /**
     * The BoxID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $BoxID;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Description;
    /**
     * The MaxQty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $MaxQty;
    /**
     * The MaxVolume
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $MaxVolume;
    /**
     * The MaxWeight
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $MaxWeight;
    /**
     * The Qty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $Qty;
    /**
     * The UOM
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $UOM;
    /**
     * Constructor method for BoxStockItem
     * @uses BoxStockItem::setBoxID()
     * @uses BoxStockItem::setDescription()
     * @uses BoxStockItem::setMaxQty()
     * @uses BoxStockItem::setMaxVolume()
     * @uses BoxStockItem::setMaxWeight()
     * @uses BoxStockItem::setQty()
     * @uses BoxStockItem::setUOM()
     * @param \StructType\StringValue $boxID
     * @param \StructType\StringValue $description
     * @param \StructType\DecimalValue $maxQty
     * @param \StructType\DecimalValue $maxVolume
     * @param \StructType\DecimalValue $maxWeight
     * @param \StructType\DecimalValue $qty
     * @param \StructType\StringValue $uOM
     */
    public function __construct(\StructType\StringValue $boxID = null, \StructType\StringValue $description = null, \StructType\DecimalValue $maxQty = null, \StructType\DecimalValue $maxVolume = null, \StructType\DecimalValue $maxWeight = null, \StructType\DecimalValue $qty = null, \StructType\StringValue $uOM = null)
    {
        $this
            ->setBoxID($boxID)
            ->setDescription($description)
            ->setMaxQty($maxQty)
            ->setMaxVolume($maxVolume)
            ->setMaxWeight($maxWeight)
            ->setQty($qty)
            ->setUOM($uOM);
    }
    /**
     * Get BoxID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getBoxID()
    {
        return isset($this->BoxID) ? $this->BoxID : null;
    }
    /**
     * Set BoxID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $boxID
     * @return \StructType\BoxStockItem
     */
    public function setBoxID(\StructType\StringValue $boxID = null)
    {
        if (is_null($boxID) || (is_array($boxID) && empty($boxID))) {
            unset($this->BoxID);
        } else {
            $this->BoxID = $boxID;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $description
     * @return \StructType\BoxStockItem
     */
    public function setDescription(\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get MaxQty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getMaxQty()
    {
        return isset($this->MaxQty) ? $this->MaxQty : null;
    }
    /**
     * Set MaxQty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $maxQty
     * @return \StructType\BoxStockItem
     */
    public function setMaxQty(\StructType\DecimalValue $maxQty = null)
    {
        if (is_null($maxQty) || (is_array($maxQty) && empty($maxQty))) {
            unset($this->MaxQty);
        } else {
            $this->MaxQty = $maxQty;
        }
        return $this;
    }
    /**
     * Get MaxVolume value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getMaxVolume()
    {
        return isset($this->MaxVolume) ? $this->MaxVolume : null;
    }
    /**
     * Set MaxVolume value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $maxVolume
     * @return \StructType\BoxStockItem
     */
    public function setMaxVolume(\StructType\DecimalValue $maxVolume = null)
    {
        if (is_null($maxVolume) || (is_array($maxVolume) && empty($maxVolume))) {
            unset($this->MaxVolume);
        } else {
            $this->MaxVolume = $maxVolume;
        }
        return $this;
    }
    /**
     * Get MaxWeight value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getMaxWeight()
    {
        return isset($this->MaxWeight) ? $this->MaxWeight : null;
    }
    /**
     * Set MaxWeight value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $maxWeight
     * @return \StructType\BoxStockItem
     */
    public function setMaxWeight(\StructType\DecimalValue $maxWeight = null)
    {
        if (is_null($maxWeight) || (is_array($maxWeight) && empty($maxWeight))) {
            unset($this->MaxWeight);
        } else {
            $this->MaxWeight = $maxWeight;
        }
        return $this;
    }
    /**
     * Get Qty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getQty()
    {
        return isset($this->Qty) ? $this->Qty : null;
    }
    /**
     * Set Qty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $qty
     * @return \StructType\BoxStockItem
     */
    public function setQty(\StructType\DecimalValue $qty = null)
    {
        if (is_null($qty) || (is_array($qty) && empty($qty))) {
            unset($this->Qty);
        } else {
            $this->Qty = $qty;
        }
        return $this;
    }
    /**
     * Get UOM value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getUOM()
    {
        return isset($this->UOM) ? $this->UOM : null;
    }
    /**
     * Set UOM value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $uOM
     * @return \StructType\BoxStockItem
     */
    public function setUOM(\StructType\StringValue $uOM = null)
    {
        if (is_null($uOM) || (is_array($uOM) && empty($uOM))) {
            unset($this->UOM);
        } else {
            $this->UOM = $uOM;
        }
        return $this;
    }
}
