<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SalesOrderCreateReceipt StructType
 * @subpackage Structs
 */
class SalesOrderCreateReceipt extends Action
{
    /**
     * The ShipmentDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DateTimeValue
     */
    public $ShipmentDate;
    /**
     * The WarehouseID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $WarehouseID;
    /**
     * Constructor method for SalesOrderCreateReceipt
     * @uses SalesOrderCreateReceipt::setShipmentDate()
     * @uses SalesOrderCreateReceipt::setWarehouseID()
     * @param \StructType\DateTimeValue $shipmentDate
     * @param \StructType\StringValue $warehouseID
     */
    public function __construct(\StructType\DateTimeValue $shipmentDate = null, \StructType\StringValue $warehouseID = null)
    {
        $this
            ->setShipmentDate($shipmentDate)
            ->setWarehouseID($warehouseID);
    }
    /**
     * Get ShipmentDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DateTimeValue|null
     */
    public function getShipmentDate()
    {
        return isset($this->ShipmentDate) ? $this->ShipmentDate : null;
    }
    /**
     * Set ShipmentDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DateTimeValue $shipmentDate
     * @return \StructType\SalesOrderCreateReceipt
     */
    public function setShipmentDate(\StructType\DateTimeValue $shipmentDate = null)
    {
        if (is_null($shipmentDate) || (is_array($shipmentDate) && empty($shipmentDate))) {
            unset($this->ShipmentDate);
        } else {
            $this->ShipmentDate = $shipmentDate;
        }
        return $this;
    }
    /**
     * Get WarehouseID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getWarehouseID()
    {
        return isset($this->WarehouseID) ? $this->WarehouseID : null;
    }
    /**
     * Set WarehouseID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $warehouseID
     * @return \StructType\SalesOrderCreateReceipt
     */
    public function setWarehouseID(\StructType\StringValue $warehouseID = null)
    {
        if (is_null($warehouseID) || (is_array($warehouseID) && empty($warehouseID))) {
            unset($this->WarehouseID);
        } else {
            $this->WarehouseID = $warehouseID;
        }
        return $this;
    }
}
