<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SalesOrderAddStockItem StructType
 * @subpackage Structs
 */
class SalesOrderAddStockItem extends Action
{
    /**
     * The BarCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $BarCode;
    /**
     * The Inventory
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Inventory;
    /**
     * The WarehouseID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $WarehouseID;
    /**
     * Constructor method for SalesOrderAddStockItem
     * @uses SalesOrderAddStockItem::setBarCode()
     * @uses SalesOrderAddStockItem::setInventory()
     * @uses SalesOrderAddStockItem::setWarehouseID()
     * @param \StructType\StringValue $barCode
     * @param \StructType\StringValue $inventory
     * @param \StructType\StringValue $warehouseID
     */
    public function __construct(\StructType\StringValue $barCode = null, \StructType\StringValue $inventory = null, \StructType\StringValue $warehouseID = null)
    {
        $this
            ->setBarCode($barCode)
            ->setInventory($inventory)
            ->setWarehouseID($warehouseID);
    }
    /**
     * Get BarCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getBarCode()
    {
        return isset($this->BarCode) ? $this->BarCode : null;
    }
    /**
     * Set BarCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $barCode
     * @return \StructType\SalesOrderAddStockItem
     */
    public function setBarCode(\StructType\StringValue $barCode = null)
    {
        if (is_null($barCode) || (is_array($barCode) && empty($barCode))) {
            unset($this->BarCode);
        } else {
            $this->BarCode = $barCode;
        }
        return $this;
    }
    /**
     * Get Inventory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getInventory()
    {
        return isset($this->Inventory) ? $this->Inventory : null;
    }
    /**
     * Set Inventory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $inventory
     * @return \StructType\SalesOrderAddStockItem
     */
    public function setInventory(\StructType\StringValue $inventory = null)
    {
        if (is_null($inventory) || (is_array($inventory) && empty($inventory))) {
            unset($this->Inventory);
        } else {
            $this->Inventory = $inventory;
        }
        return $this;
    }
    /**
     * Get WarehouseID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getWarehouseID()
    {
        return isset($this->WarehouseID) ? $this->WarehouseID : null;
    }
    /**
     * Set WarehouseID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $warehouseID
     * @return \StructType\SalesOrderAddStockItem
     */
    public function setWarehouseID(\StructType\StringValue $warehouseID = null)
    {
        if (is_null($warehouseID) || (is_array($warehouseID) && empty($warehouseID))) {
            unset($this->WarehouseID);
        } else {
            $this->WarehouseID = $warehouseID;
        }
        return $this;
    }
}
