<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SalesInvoiceFreightDetail StructType
 * @subpackage Structs
 */
class SalesInvoiceFreightDetail extends Entity
{
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Description;
    /**
     * The FreightAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $FreightAmount;
    /**
     * The FreightCost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $FreightCost;
    /**
     * The LineTotal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $LineTotal;
    /**
     * The PremiumFreightAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $PremiumFreightAmount;
    /**
     * The ShipmentNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ShipmentNbr;
    /**
     * The ShipmentType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ShipmentType;
    /**
     * The TotalFreightAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $TotalFreightAmount;
    /**
     * The Volume
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $Volume;
    /**
     * The Weight
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $Weight;
    /**
     * Constructor method for SalesInvoiceFreightDetail
     * @uses SalesInvoiceFreightDetail::setDescription()
     * @uses SalesInvoiceFreightDetail::setFreightAmount()
     * @uses SalesInvoiceFreightDetail::setFreightCost()
     * @uses SalesInvoiceFreightDetail::setLineTotal()
     * @uses SalesInvoiceFreightDetail::setPremiumFreightAmount()
     * @uses SalesInvoiceFreightDetail::setShipmentNbr()
     * @uses SalesInvoiceFreightDetail::setShipmentType()
     * @uses SalesInvoiceFreightDetail::setTotalFreightAmount()
     * @uses SalesInvoiceFreightDetail::setVolume()
     * @uses SalesInvoiceFreightDetail::setWeight()
     * @param \StructType\StringValue $description
     * @param \StructType\DecimalValue $freightAmount
     * @param \StructType\DecimalValue $freightCost
     * @param \StructType\DecimalValue $lineTotal
     * @param \StructType\DecimalValue $premiumFreightAmount
     * @param \StructType\StringValue $shipmentNbr
     * @param \StructType\StringValue $shipmentType
     * @param \StructType\DecimalValue $totalFreightAmount
     * @param \StructType\DecimalValue $volume
     * @param \StructType\DecimalValue $weight
     */
    public function __construct(\StructType\StringValue $description = null, \StructType\DecimalValue $freightAmount = null, \StructType\DecimalValue $freightCost = null, \StructType\DecimalValue $lineTotal = null, \StructType\DecimalValue $premiumFreightAmount = null, \StructType\StringValue $shipmentNbr = null, \StructType\StringValue $shipmentType = null, \StructType\DecimalValue $totalFreightAmount = null, \StructType\DecimalValue $volume = null, \StructType\DecimalValue $weight = null)
    {
        $this
            ->setDescription($description)
            ->setFreightAmount($freightAmount)
            ->setFreightCost($freightCost)
            ->setLineTotal($lineTotal)
            ->setPremiumFreightAmount($premiumFreightAmount)
            ->setShipmentNbr($shipmentNbr)
            ->setShipmentType($shipmentType)
            ->setTotalFreightAmount($totalFreightAmount)
            ->setVolume($volume)
            ->setWeight($weight);
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $description
     * @return \StructType\SalesInvoiceFreightDetail
     */
    public function setDescription(\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get FreightAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getFreightAmount()
    {
        return isset($this->FreightAmount) ? $this->FreightAmount : null;
    }
    /**
     * Set FreightAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $freightAmount
     * @return \StructType\SalesInvoiceFreightDetail
     */
    public function setFreightAmount(\StructType\DecimalValue $freightAmount = null)
    {
        if (is_null($freightAmount) || (is_array($freightAmount) && empty($freightAmount))) {
            unset($this->FreightAmount);
        } else {
            $this->FreightAmount = $freightAmount;
        }
        return $this;
    }
    /**
     * Get FreightCost value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getFreightCost()
    {
        return isset($this->FreightCost) ? $this->FreightCost : null;
    }
    /**
     * Set FreightCost value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $freightCost
     * @return \StructType\SalesInvoiceFreightDetail
     */
    public function setFreightCost(\StructType\DecimalValue $freightCost = null)
    {
        if (is_null($freightCost) || (is_array($freightCost) && empty($freightCost))) {
            unset($this->FreightCost);
        } else {
            $this->FreightCost = $freightCost;
        }
        return $this;
    }
    /**
     * Get LineTotal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getLineTotal()
    {
        return isset($this->LineTotal) ? $this->LineTotal : null;
    }
    /**
     * Set LineTotal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $lineTotal
     * @return \StructType\SalesInvoiceFreightDetail
     */
    public function setLineTotal(\StructType\DecimalValue $lineTotal = null)
    {
        if (is_null($lineTotal) || (is_array($lineTotal) && empty($lineTotal))) {
            unset($this->LineTotal);
        } else {
            $this->LineTotal = $lineTotal;
        }
        return $this;
    }
    /**
     * Get PremiumFreightAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getPremiumFreightAmount()
    {
        return isset($this->PremiumFreightAmount) ? $this->PremiumFreightAmount : null;
    }
    /**
     * Set PremiumFreightAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $premiumFreightAmount
     * @return \StructType\SalesInvoiceFreightDetail
     */
    public function setPremiumFreightAmount(\StructType\DecimalValue $premiumFreightAmount = null)
    {
        if (is_null($premiumFreightAmount) || (is_array($premiumFreightAmount) && empty($premiumFreightAmount))) {
            unset($this->PremiumFreightAmount);
        } else {
            $this->PremiumFreightAmount = $premiumFreightAmount;
        }
        return $this;
    }
    /**
     * Get ShipmentNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getShipmentNbr()
    {
        return isset($this->ShipmentNbr) ? $this->ShipmentNbr : null;
    }
    /**
     * Set ShipmentNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $shipmentNbr
     * @return \StructType\SalesInvoiceFreightDetail
     */
    public function setShipmentNbr(\StructType\StringValue $shipmentNbr = null)
    {
        if (is_null($shipmentNbr) || (is_array($shipmentNbr) && empty($shipmentNbr))) {
            unset($this->ShipmentNbr);
        } else {
            $this->ShipmentNbr = $shipmentNbr;
        }
        return $this;
    }
    /**
     * Get ShipmentType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getShipmentType()
    {
        return isset($this->ShipmentType) ? $this->ShipmentType : null;
    }
    /**
     * Set ShipmentType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $shipmentType
     * @return \StructType\SalesInvoiceFreightDetail
     */
    public function setShipmentType(\StructType\StringValue $shipmentType = null)
    {
        if (is_null($shipmentType) || (is_array($shipmentType) && empty($shipmentType))) {
            unset($this->ShipmentType);
        } else {
            $this->ShipmentType = $shipmentType;
        }
        return $this;
    }
    /**
     * Get TotalFreightAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getTotalFreightAmount()
    {
        return isset($this->TotalFreightAmount) ? $this->TotalFreightAmount : null;
    }
    /**
     * Set TotalFreightAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $totalFreightAmount
     * @return \StructType\SalesInvoiceFreightDetail
     */
    public function setTotalFreightAmount(\StructType\DecimalValue $totalFreightAmount = null)
    {
        if (is_null($totalFreightAmount) || (is_array($totalFreightAmount) && empty($totalFreightAmount))) {
            unset($this->TotalFreightAmount);
        } else {
            $this->TotalFreightAmount = $totalFreightAmount;
        }
        return $this;
    }
    /**
     * Get Volume value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getVolume()
    {
        return isset($this->Volume) ? $this->Volume : null;
    }
    /**
     * Set Volume value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $volume
     * @return \StructType\SalesInvoiceFreightDetail
     */
    public function setVolume(\StructType\DecimalValue $volume = null)
    {
        if (is_null($volume) || (is_array($volume) && empty($volume))) {
            unset($this->Volume);
        } else {
            $this->Volume = $volume;
        }
        return $this;
    }
    /**
     * Get Weight value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getWeight()
    {
        return isset($this->Weight) ? $this->Weight : null;
    }
    /**
     * Set Weight value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $weight
     * @return \StructType\SalesInvoiceFreightDetail
     */
    public function setWeight(\StructType\DecimalValue $weight = null)
    {
        if (is_null($weight) || (is_array($weight) && empty($weight))) {
            unset($this->Weight);
        } else {
            $this->Weight = $weight;
        }
        return $this;
    }
}
