<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Result StructType
 * @subpackage Structs
 */
class Result extends AbstractStructBase
{
    /**
     * The EmailProcessingRow
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\EmailProcessingRow[]
     */
    public $EmailProcessingRow;
    /**
     * Constructor method for Result
     * @uses Result::setEmailProcessingRow()
     * @param \StructType\EmailProcessingRow[] $emailProcessingRow
     */
    public function __construct(array $emailProcessingRow = array())
    {
        $this
            ->setEmailProcessingRow($emailProcessingRow);
    }
    /**
     * Get EmailProcessingRow value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\EmailProcessingRow[]|null
     */
    public function getEmailProcessingRow()
    {
        return isset($this->EmailProcessingRow) ? $this->EmailProcessingRow : null;
    }
    /**
     * This method is responsible for validating the values passed to the setEmailProcessingRow method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEmailProcessingRow method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEmailProcessingRowForArrayConstraintsFromSetEmailProcessingRow(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $resultEmailProcessingRowItem) {
            // validation for constraint: itemType
            if (!$resultEmailProcessingRowItem instanceof \StructType\EmailProcessingRow) {
                $invalidValues[] = is_object($resultEmailProcessingRowItem) ? get_class($resultEmailProcessingRowItem) : sprintf('%s(%s)', gettype($resultEmailProcessingRowItem), var_export($resultEmailProcessingRowItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The EmailProcessingRow property can only contain items of type \StructType\EmailProcessingRow, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set EmailProcessingRow value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\EmailProcessingRow[] $emailProcessingRow
     * @return \StructType\Result
     */
    public function setEmailProcessingRow(array $emailProcessingRow = array())
    {
        // validation for constraint: array
        if ('' !== ($emailProcessingRowArrayErrorMessage = self::validateEmailProcessingRowForArrayConstraintsFromSetEmailProcessingRow($emailProcessingRow))) {
            throw new \InvalidArgumentException($emailProcessingRowArrayErrorMessage, __LINE__);
        }
        if (is_null($emailProcessingRow) || (is_array($emailProcessingRow) && empty($emailProcessingRow))) {
            unset($this->EmailProcessingRow);
        } else {
            $this->EmailProcessingRow = $emailProcessingRow;
        }
        return $this;
    }
    /**
     * Add item to EmailProcessingRow value
     * @throws \InvalidArgumentException
     * @param \StructType\EmailProcessingRow $item
     * @return \StructType\Result
     */
    public function addToEmailProcessingRow(\StructType\EmailProcessingRow $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EmailProcessingRow) {
            throw new \InvalidArgumentException(sprintf('The EmailProcessingRow property can only contain items of type \StructType\EmailProcessingRow, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->EmailProcessingRow[] = $item;
        return $this;
    }
}
