<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReportingSettings StructType
 * @subpackage Structs
 */
class ReportingSettings extends Entity
{
    /**
     * The ReportingGroups
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ReportingGroups
     */
    public $ReportingGroups;
    /**
     * The TaxAgency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $TaxAgency;
    /**
     * Constructor method for ReportingSettings
     * @uses ReportingSettings::setReportingGroups()
     * @uses ReportingSettings::setTaxAgency()
     * @param \StructType\ReportingGroups $reportingGroups
     * @param \StructType\StringValue $taxAgency
     */
    public function __construct(\StructType\ReportingGroups $reportingGroups = null, \StructType\StringValue $taxAgency = null)
    {
        $this
            ->setReportingGroups($reportingGroups)
            ->setTaxAgency($taxAgency);
    }
    /**
     * Get ReportingGroups value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ReportingGroups|null
     */
    public function getReportingGroups()
    {
        return isset($this->ReportingGroups) ? $this->ReportingGroups : null;
    }
    /**
     * Set ReportingGroups value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ReportingGroups $reportingGroups
     * @return \StructType\ReportingSettings
     */
    public function setReportingGroups(\StructType\ReportingGroups $reportingGroups = null)
    {
        if (is_null($reportingGroups) || (is_array($reportingGroups) && empty($reportingGroups))) {
            unset($this->ReportingGroups);
        } else {
            $this->ReportingGroups = $reportingGroups;
        }
        return $this;
    }
    /**
     * Get TaxAgency value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getTaxAgency()
    {
        return isset($this->TaxAgency) ? $this->TaxAgency : null;
    }
    /**
     * Set TaxAgency value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $taxAgency
     * @return \StructType\ReportingSettings
     */
    public function setTaxAgency(\StructType\StringValue $taxAgency = null)
    {
        if (is_null($taxAgency) || (is_array($taxAgency) && empty($taxAgency))) {
            unset($this->TaxAgency);
        } else {
            $this->TaxAgency = $taxAgency;
        }
        return $this;
    }
}
