<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReplenishmentParameters StructType
 * @subpackage Structs
 */
class ReplenishmentParameters extends AbstractStructBase
{
    /**
     * The ReplenishmentParameterStockItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ReplenishmentParameterStockItem[]
     */
    public $ReplenishmentParameterStockItem;
    /**
     * Constructor method for ReplenishmentParameters
     * @uses ReplenishmentParameters::setReplenishmentParameterStockItem()
     * @param \StructType\ReplenishmentParameterStockItem[] $replenishmentParameterStockItem
     */
    public function __construct(array $replenishmentParameterStockItem = array())
    {
        $this
            ->setReplenishmentParameterStockItem($replenishmentParameterStockItem);
    }
    /**
     * Get ReplenishmentParameterStockItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ReplenishmentParameterStockItem[]|null
     */
    public function getReplenishmentParameterStockItem()
    {
        return isset($this->ReplenishmentParameterStockItem) ? $this->ReplenishmentParameterStockItem : null;
    }
    /**
     * This method is responsible for validating the values passed to the setReplenishmentParameterStockItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReplenishmentParameterStockItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReplenishmentParameterStockItemForArrayConstraintsFromSetReplenishmentParameterStockItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $replenishmentParametersReplenishmentParameterStockItemItem) {
            // validation for constraint: itemType
            if (!$replenishmentParametersReplenishmentParameterStockItemItem instanceof \StructType\ReplenishmentParameterStockItem) {
                $invalidValues[] = is_object($replenishmentParametersReplenishmentParameterStockItemItem) ? get_class($replenishmentParametersReplenishmentParameterStockItemItem) : sprintf('%s(%s)', gettype($replenishmentParametersReplenishmentParameterStockItemItem), var_export($replenishmentParametersReplenishmentParameterStockItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ReplenishmentParameterStockItem property can only contain items of type \StructType\ReplenishmentParameterStockItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ReplenishmentParameterStockItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ReplenishmentParameterStockItem[] $replenishmentParameterStockItem
     * @return \StructType\ReplenishmentParameters
     */
    public function setReplenishmentParameterStockItem(array $replenishmentParameterStockItem = array())
    {
        // validation for constraint: array
        if ('' !== ($replenishmentParameterStockItemArrayErrorMessage = self::validateReplenishmentParameterStockItemForArrayConstraintsFromSetReplenishmentParameterStockItem($replenishmentParameterStockItem))) {
            throw new \InvalidArgumentException($replenishmentParameterStockItemArrayErrorMessage, __LINE__);
        }
        if (is_null($replenishmentParameterStockItem) || (is_array($replenishmentParameterStockItem) && empty($replenishmentParameterStockItem))) {
            unset($this->ReplenishmentParameterStockItem);
        } else {
            $this->ReplenishmentParameterStockItem = $replenishmentParameterStockItem;
        }
        return $this;
    }
    /**
     * Add item to ReplenishmentParameterStockItem value
     * @throws \InvalidArgumentException
     * @param \StructType\ReplenishmentParameterStockItem $item
     * @return \StructType\ReplenishmentParameters
     */
    public function addToReplenishmentParameterStockItem(\StructType\ReplenishmentParameterStockItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ReplenishmentParameterStockItem) {
            throw new \InvalidArgumentException(sprintf('The ReplenishmentParameterStockItem property can only contain items of type \StructType\ReplenishmentParameterStockItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ReplenishmentParameterStockItem[] = $item;
        return $this;
    }
}
