<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProjectBudget StructType
 * @subpackage Structs
 */
class ProjectBudget extends Entity
{
    /**
     * The AccountGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $AccountGroup;
    /**
     * The ActualAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $ActualAmount;
    /**
     * The ActualPlusOpenCommittedAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $ActualPlusOpenCommittedAmount;
    /**
     * The ActualQty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $ActualQty;
    /**
     * The AutoCompleted
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $AutoCompleted;
    /**
     * The BudgetedCOAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $BudgetedCOAmount;
    /**
     * The BudgetedCOQty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $BudgetedCOQty;
    /**
     * The CommittedCOAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $CommittedCOAmount;
    /**
     * The CommittedCOQty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $CommittedCOQty;
    /**
     * The CommittedInvoicedAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $CommittedInvoicedAmount;
    /**
     * The CommittedInvoicedQty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $CommittedInvoicedQty;
    /**
     * The CommittedOpenAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $CommittedOpenAmount;
    /**
     * The CommittedOpenQty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $CommittedOpenQty;
    /**
     * The CommittedReceivedQty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $CommittedReceivedQty;
    /**
     * The Completed
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $Completed;
    /**
     * The CostAtCompletion
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $CostAtCompletion;
    /**
     * The CostCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $CostCode;
    /**
     * The CostToComplete
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $CostToComplete;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Description;
    /**
     * The DraftInvoicesAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $DraftInvoicesAmount;
    /**
     * The InventoryID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $InventoryID;
    /**
     * The LastCostAtCompletion
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $LastCostAtCompletion;
    /**
     * The LastCostToComplete
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $LastCostToComplete;
    /**
     * The LastModifiedDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DateTimeValue
     */
    public $LastModifiedDateTime;
    /**
     * The LastPercentageOfCompletion
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $LastPercentageOfCompletion;
    /**
     * The OriginalBudgetedAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $OriginalBudgetedAmount;
    /**
     * The OriginalBudgetedQty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $OriginalBudgetedQty;
    /**
     * The OriginalCommittedAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $OriginalCommittedAmount;
    /**
     * The OriginalCommittedQty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $OriginalCommittedQty;
    /**
     * The PendingInvoiceAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $PendingInvoiceAmount;
    /**
     * The PercentageOfCompletion
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $PercentageOfCompletion;
    /**
     * The Performance
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $Performance;
    /**
     * The ProjectID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ProjectID;
    /**
     * The ProjectTaskID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ProjectTaskID;
    /**
     * The Retainage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $Retainage;
    /**
     * The RevenueTask
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\IntValue
     */
    public $RevenueTask;
    /**
     * The RevisedBudgetedAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $RevisedBudgetedAmount;
    /**
     * The RevisedBudgetedQty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $RevisedBudgetedQty;
    /**
     * The RevisedCommittedAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $RevisedCommittedAmount;
    /**
     * The RevisedCommittedQty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $RevisedCommittedQty;
    /**
     * The TaxCategory
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $TaxCategory;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Type;
    /**
     * The UnitRate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $UnitRate;
    /**
     * The UOM
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $UOM;
    /**
     * The VarianceAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $VarianceAmount;
    /**
     * Constructor method for ProjectBudget
     * @uses ProjectBudget::setAccountGroup()
     * @uses ProjectBudget::setActualAmount()
     * @uses ProjectBudget::setActualPlusOpenCommittedAmount()
     * @uses ProjectBudget::setActualQty()
     * @uses ProjectBudget::setAutoCompleted()
     * @uses ProjectBudget::setBudgetedCOAmount()
     * @uses ProjectBudget::setBudgetedCOQty()
     * @uses ProjectBudget::setCommittedCOAmount()
     * @uses ProjectBudget::setCommittedCOQty()
     * @uses ProjectBudget::setCommittedInvoicedAmount()
     * @uses ProjectBudget::setCommittedInvoicedQty()
     * @uses ProjectBudget::setCommittedOpenAmount()
     * @uses ProjectBudget::setCommittedOpenQty()
     * @uses ProjectBudget::setCommittedReceivedQty()
     * @uses ProjectBudget::setCompleted()
     * @uses ProjectBudget::setCostAtCompletion()
     * @uses ProjectBudget::setCostCode()
     * @uses ProjectBudget::setCostToComplete()
     * @uses ProjectBudget::setDescription()
     * @uses ProjectBudget::setDraftInvoicesAmount()
     * @uses ProjectBudget::setInventoryID()
     * @uses ProjectBudget::setLastCostAtCompletion()
     * @uses ProjectBudget::setLastCostToComplete()
     * @uses ProjectBudget::setLastModifiedDateTime()
     * @uses ProjectBudget::setLastPercentageOfCompletion()
     * @uses ProjectBudget::setOriginalBudgetedAmount()
     * @uses ProjectBudget::setOriginalBudgetedQty()
     * @uses ProjectBudget::setOriginalCommittedAmount()
     * @uses ProjectBudget::setOriginalCommittedQty()
     * @uses ProjectBudget::setPendingInvoiceAmount()
     * @uses ProjectBudget::setPercentageOfCompletion()
     * @uses ProjectBudget::setPerformance()
     * @uses ProjectBudget::setProjectID()
     * @uses ProjectBudget::setProjectTaskID()
     * @uses ProjectBudget::setRetainage()
     * @uses ProjectBudget::setRevenueTask()
     * @uses ProjectBudget::setRevisedBudgetedAmount()
     * @uses ProjectBudget::setRevisedBudgetedQty()
     * @uses ProjectBudget::setRevisedCommittedAmount()
     * @uses ProjectBudget::setRevisedCommittedQty()
     * @uses ProjectBudget::setTaxCategory()
     * @uses ProjectBudget::setType()
     * @uses ProjectBudget::setUnitRate()
     * @uses ProjectBudget::setUOM()
     * @uses ProjectBudget::setVarianceAmount()
     * @param \StructType\StringValue $accountGroup
     * @param \StructType\DecimalValue $actualAmount
     * @param \StructType\DecimalValue $actualPlusOpenCommittedAmount
     * @param \StructType\DecimalValue $actualQty
     * @param \StructType\BooleanValue $autoCompleted
     * @param \StructType\DecimalValue $budgetedCOAmount
     * @param \StructType\DecimalValue $budgetedCOQty
     * @param \StructType\DecimalValue $committedCOAmount
     * @param \StructType\DecimalValue $committedCOQty
     * @param \StructType\DecimalValue $committedInvoicedAmount
     * @param \StructType\DecimalValue $committedInvoicedQty
     * @param \StructType\DecimalValue $committedOpenAmount
     * @param \StructType\DecimalValue $committedOpenQty
     * @param \StructType\DecimalValue $committedReceivedQty
     * @param \StructType\DecimalValue $completed
     * @param \StructType\DecimalValue $costAtCompletion
     * @param \StructType\StringValue $costCode
     * @param \StructType\DecimalValue $costToComplete
     * @param \StructType\StringValue $description
     * @param \StructType\DecimalValue $draftInvoicesAmount
     * @param \StructType\StringValue $inventoryID
     * @param \StructType\DecimalValue $lastCostAtCompletion
     * @param \StructType\DecimalValue $lastCostToComplete
     * @param \StructType\DateTimeValue $lastModifiedDateTime
     * @param \StructType\DecimalValue $lastPercentageOfCompletion
     * @param \StructType\DecimalValue $originalBudgetedAmount
     * @param \StructType\DecimalValue $originalBudgetedQty
     * @param \StructType\DecimalValue $originalCommittedAmount
     * @param \StructType\DecimalValue $originalCommittedQty
     * @param \StructType\DecimalValue $pendingInvoiceAmount
     * @param \StructType\DecimalValue $percentageOfCompletion
     * @param \StructType\DecimalValue $performance
     * @param \StructType\StringValue $projectID
     * @param \StructType\StringValue $projectTaskID
     * @param \StructType\DecimalValue $retainage
     * @param \StructType\IntValue $revenueTask
     * @param \StructType\DecimalValue $revisedBudgetedAmount
     * @param \StructType\DecimalValue $revisedBudgetedQty
     * @param \StructType\DecimalValue $revisedCommittedAmount
     * @param \StructType\DecimalValue $revisedCommittedQty
     * @param \StructType\StringValue $taxCategory
     * @param \StructType\StringValue $type
     * @param \StructType\DecimalValue $unitRate
     * @param \StructType\StringValue $uOM
     * @param \StructType\DecimalValue $varianceAmount
     */
    public function __construct(\StructType\StringValue $accountGroup = null, \StructType\DecimalValue $actualAmount = null, \StructType\DecimalValue $actualPlusOpenCommittedAmount = null, \StructType\DecimalValue $actualQty = null, \StructType\BooleanValue $autoCompleted = null, \StructType\DecimalValue $budgetedCOAmount = null, \StructType\DecimalValue $budgetedCOQty = null, \StructType\DecimalValue $committedCOAmount = null, \StructType\DecimalValue $committedCOQty = null, \StructType\DecimalValue $committedInvoicedAmount = null, \StructType\DecimalValue $committedInvoicedQty = null, \StructType\DecimalValue $committedOpenAmount = null, \StructType\DecimalValue $committedOpenQty = null, \StructType\DecimalValue $committedReceivedQty = null, \StructType\DecimalValue $completed = null, \StructType\DecimalValue $costAtCompletion = null, \StructType\StringValue $costCode = null, \StructType\DecimalValue $costToComplete = null, \StructType\StringValue $description = null, \StructType\DecimalValue $draftInvoicesAmount = null, \StructType\StringValue $inventoryID = null, \StructType\DecimalValue $lastCostAtCompletion = null, \StructType\DecimalValue $lastCostToComplete = null, \StructType\DateTimeValue $lastModifiedDateTime = null, \StructType\DecimalValue $lastPercentageOfCompletion = null, \StructType\DecimalValue $originalBudgetedAmount = null, \StructType\DecimalValue $originalBudgetedQty = null, \StructType\DecimalValue $originalCommittedAmount = null, \StructType\DecimalValue $originalCommittedQty = null, \StructType\DecimalValue $pendingInvoiceAmount = null, \StructType\DecimalValue $percentageOfCompletion = null, \StructType\DecimalValue $performance = null, \StructType\StringValue $projectID = null, \StructType\StringValue $projectTaskID = null, \StructType\DecimalValue $retainage = null, \StructType\IntValue $revenueTask = null, \StructType\DecimalValue $revisedBudgetedAmount = null, \StructType\DecimalValue $revisedBudgetedQty = null, \StructType\DecimalValue $revisedCommittedAmount = null, \StructType\DecimalValue $revisedCommittedQty = null, \StructType\StringValue $taxCategory = null, \StructType\StringValue $type = null, \StructType\DecimalValue $unitRate = null, \StructType\StringValue $uOM = null, \StructType\DecimalValue $varianceAmount = null)
    {
        $this
            ->setAccountGroup($accountGroup)
            ->setActualAmount($actualAmount)
            ->setActualPlusOpenCommittedAmount($actualPlusOpenCommittedAmount)
            ->setActualQty($actualQty)
            ->setAutoCompleted($autoCompleted)
            ->setBudgetedCOAmount($budgetedCOAmount)
            ->setBudgetedCOQty($budgetedCOQty)
            ->setCommittedCOAmount($committedCOAmount)
            ->setCommittedCOQty($committedCOQty)
            ->setCommittedInvoicedAmount($committedInvoicedAmount)
            ->setCommittedInvoicedQty($committedInvoicedQty)
            ->setCommittedOpenAmount($committedOpenAmount)
            ->setCommittedOpenQty($committedOpenQty)
            ->setCommittedReceivedQty($committedReceivedQty)
            ->setCompleted($completed)
            ->setCostAtCompletion($costAtCompletion)
            ->setCostCode($costCode)
            ->setCostToComplete($costToComplete)
            ->setDescription($description)
            ->setDraftInvoicesAmount($draftInvoicesAmount)
            ->setInventoryID($inventoryID)
            ->setLastCostAtCompletion($lastCostAtCompletion)
            ->setLastCostToComplete($lastCostToComplete)
            ->setLastModifiedDateTime($lastModifiedDateTime)
            ->setLastPercentageOfCompletion($lastPercentageOfCompletion)
            ->setOriginalBudgetedAmount($originalBudgetedAmount)
            ->setOriginalBudgetedQty($originalBudgetedQty)
            ->setOriginalCommittedAmount($originalCommittedAmount)
            ->setOriginalCommittedQty($originalCommittedQty)
            ->setPendingInvoiceAmount($pendingInvoiceAmount)
            ->setPercentageOfCompletion($percentageOfCompletion)
            ->setPerformance($performance)
            ->setProjectID($projectID)
            ->setProjectTaskID($projectTaskID)
            ->setRetainage($retainage)
            ->setRevenueTask($revenueTask)
            ->setRevisedBudgetedAmount($revisedBudgetedAmount)
            ->setRevisedBudgetedQty($revisedBudgetedQty)
            ->setRevisedCommittedAmount($revisedCommittedAmount)
            ->setRevisedCommittedQty($revisedCommittedQty)
            ->setTaxCategory($taxCategory)
            ->setType($type)
            ->setUnitRate($unitRate)
            ->setUOM($uOM)
            ->setVarianceAmount($varianceAmount);
    }
    /**
     * Get AccountGroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getAccountGroup()
    {
        return isset($this->AccountGroup) ? $this->AccountGroup : null;
    }
    /**
     * Set AccountGroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $accountGroup
     * @return \StructType\ProjectBudget
     */
    public function setAccountGroup(\StructType\StringValue $accountGroup = null)
    {
        if (is_null($accountGroup) || (is_array($accountGroup) && empty($accountGroup))) {
            unset($this->AccountGroup);
        } else {
            $this->AccountGroup = $accountGroup;
        }
        return $this;
    }
    /**
     * Get ActualAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getActualAmount()
    {
        return isset($this->ActualAmount) ? $this->ActualAmount : null;
    }
    /**
     * Set ActualAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $actualAmount
     * @return \StructType\ProjectBudget
     */
    public function setActualAmount(\StructType\DecimalValue $actualAmount = null)
    {
        if (is_null($actualAmount) || (is_array($actualAmount) && empty($actualAmount))) {
            unset($this->ActualAmount);
        } else {
            $this->ActualAmount = $actualAmount;
        }
        return $this;
    }
    /**
     * Get ActualPlusOpenCommittedAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getActualPlusOpenCommittedAmount()
    {
        return isset($this->ActualPlusOpenCommittedAmount) ? $this->ActualPlusOpenCommittedAmount : null;
    }
    /**
     * Set ActualPlusOpenCommittedAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $actualPlusOpenCommittedAmount
     * @return \StructType\ProjectBudget
     */
    public function setActualPlusOpenCommittedAmount(\StructType\DecimalValue $actualPlusOpenCommittedAmount = null)
    {
        if (is_null($actualPlusOpenCommittedAmount) || (is_array($actualPlusOpenCommittedAmount) && empty($actualPlusOpenCommittedAmount))) {
            unset($this->ActualPlusOpenCommittedAmount);
        } else {
            $this->ActualPlusOpenCommittedAmount = $actualPlusOpenCommittedAmount;
        }
        return $this;
    }
    /**
     * Get ActualQty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getActualQty()
    {
        return isset($this->ActualQty) ? $this->ActualQty : null;
    }
    /**
     * Set ActualQty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $actualQty
     * @return \StructType\ProjectBudget
     */
    public function setActualQty(\StructType\DecimalValue $actualQty = null)
    {
        if (is_null($actualQty) || (is_array($actualQty) && empty($actualQty))) {
            unset($this->ActualQty);
        } else {
            $this->ActualQty = $actualQty;
        }
        return $this;
    }
    /**
     * Get AutoCompleted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getAutoCompleted()
    {
        return isset($this->AutoCompleted) ? $this->AutoCompleted : null;
    }
    /**
     * Set AutoCompleted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $autoCompleted
     * @return \StructType\ProjectBudget
     */
    public function setAutoCompleted(\StructType\BooleanValue $autoCompleted = null)
    {
        if (is_null($autoCompleted) || (is_array($autoCompleted) && empty($autoCompleted))) {
            unset($this->AutoCompleted);
        } else {
            $this->AutoCompleted = $autoCompleted;
        }
        return $this;
    }
    /**
     * Get BudgetedCOAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getBudgetedCOAmount()
    {
        return isset($this->BudgetedCOAmount) ? $this->BudgetedCOAmount : null;
    }
    /**
     * Set BudgetedCOAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $budgetedCOAmount
     * @return \StructType\ProjectBudget
     */
    public function setBudgetedCOAmount(\StructType\DecimalValue $budgetedCOAmount = null)
    {
        if (is_null($budgetedCOAmount) || (is_array($budgetedCOAmount) && empty($budgetedCOAmount))) {
            unset($this->BudgetedCOAmount);
        } else {
            $this->BudgetedCOAmount = $budgetedCOAmount;
        }
        return $this;
    }
    /**
     * Get BudgetedCOQty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getBudgetedCOQty()
    {
        return isset($this->BudgetedCOQty) ? $this->BudgetedCOQty : null;
    }
    /**
     * Set BudgetedCOQty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $budgetedCOQty
     * @return \StructType\ProjectBudget
     */
    public function setBudgetedCOQty(\StructType\DecimalValue $budgetedCOQty = null)
    {
        if (is_null($budgetedCOQty) || (is_array($budgetedCOQty) && empty($budgetedCOQty))) {
            unset($this->BudgetedCOQty);
        } else {
            $this->BudgetedCOQty = $budgetedCOQty;
        }
        return $this;
    }
    /**
     * Get CommittedCOAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getCommittedCOAmount()
    {
        return isset($this->CommittedCOAmount) ? $this->CommittedCOAmount : null;
    }
    /**
     * Set CommittedCOAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $committedCOAmount
     * @return \StructType\ProjectBudget
     */
    public function setCommittedCOAmount(\StructType\DecimalValue $committedCOAmount = null)
    {
        if (is_null($committedCOAmount) || (is_array($committedCOAmount) && empty($committedCOAmount))) {
            unset($this->CommittedCOAmount);
        } else {
            $this->CommittedCOAmount = $committedCOAmount;
        }
        return $this;
    }
    /**
     * Get CommittedCOQty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getCommittedCOQty()
    {
        return isset($this->CommittedCOQty) ? $this->CommittedCOQty : null;
    }
    /**
     * Set CommittedCOQty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $committedCOQty
     * @return \StructType\ProjectBudget
     */
    public function setCommittedCOQty(\StructType\DecimalValue $committedCOQty = null)
    {
        if (is_null($committedCOQty) || (is_array($committedCOQty) && empty($committedCOQty))) {
            unset($this->CommittedCOQty);
        } else {
            $this->CommittedCOQty = $committedCOQty;
        }
        return $this;
    }
    /**
     * Get CommittedInvoicedAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getCommittedInvoicedAmount()
    {
        return isset($this->CommittedInvoicedAmount) ? $this->CommittedInvoicedAmount : null;
    }
    /**
     * Set CommittedInvoicedAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $committedInvoicedAmount
     * @return \StructType\ProjectBudget
     */
    public function setCommittedInvoicedAmount(\StructType\DecimalValue $committedInvoicedAmount = null)
    {
        if (is_null($committedInvoicedAmount) || (is_array($committedInvoicedAmount) && empty($committedInvoicedAmount))) {
            unset($this->CommittedInvoicedAmount);
        } else {
            $this->CommittedInvoicedAmount = $committedInvoicedAmount;
        }
        return $this;
    }
    /**
     * Get CommittedInvoicedQty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getCommittedInvoicedQty()
    {
        return isset($this->CommittedInvoicedQty) ? $this->CommittedInvoicedQty : null;
    }
    /**
     * Set CommittedInvoicedQty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $committedInvoicedQty
     * @return \StructType\ProjectBudget
     */
    public function setCommittedInvoicedQty(\StructType\DecimalValue $committedInvoicedQty = null)
    {
        if (is_null($committedInvoicedQty) || (is_array($committedInvoicedQty) && empty($committedInvoicedQty))) {
            unset($this->CommittedInvoicedQty);
        } else {
            $this->CommittedInvoicedQty = $committedInvoicedQty;
        }
        return $this;
    }
    /**
     * Get CommittedOpenAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getCommittedOpenAmount()
    {
        return isset($this->CommittedOpenAmount) ? $this->CommittedOpenAmount : null;
    }
    /**
     * Set CommittedOpenAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $committedOpenAmount
     * @return \StructType\ProjectBudget
     */
    public function setCommittedOpenAmount(\StructType\DecimalValue $committedOpenAmount = null)
    {
        if (is_null($committedOpenAmount) || (is_array($committedOpenAmount) && empty($committedOpenAmount))) {
            unset($this->CommittedOpenAmount);
        } else {
            $this->CommittedOpenAmount = $committedOpenAmount;
        }
        return $this;
    }
    /**
     * Get CommittedOpenQty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getCommittedOpenQty()
    {
        return isset($this->CommittedOpenQty) ? $this->CommittedOpenQty : null;
    }
    /**
     * Set CommittedOpenQty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $committedOpenQty
     * @return \StructType\ProjectBudget
     */
    public function setCommittedOpenQty(\StructType\DecimalValue $committedOpenQty = null)
    {
        if (is_null($committedOpenQty) || (is_array($committedOpenQty) && empty($committedOpenQty))) {
            unset($this->CommittedOpenQty);
        } else {
            $this->CommittedOpenQty = $committedOpenQty;
        }
        return $this;
    }
    /**
     * Get CommittedReceivedQty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getCommittedReceivedQty()
    {
        return isset($this->CommittedReceivedQty) ? $this->CommittedReceivedQty : null;
    }
    /**
     * Set CommittedReceivedQty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $committedReceivedQty
     * @return \StructType\ProjectBudget
     */
    public function setCommittedReceivedQty(\StructType\DecimalValue $committedReceivedQty = null)
    {
        if (is_null($committedReceivedQty) || (is_array($committedReceivedQty) && empty($committedReceivedQty))) {
            unset($this->CommittedReceivedQty);
        } else {
            $this->CommittedReceivedQty = $committedReceivedQty;
        }
        return $this;
    }
    /**
     * Get Completed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getCompleted()
    {
        return isset($this->Completed) ? $this->Completed : null;
    }
    /**
     * Set Completed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $completed
     * @return \StructType\ProjectBudget
     */
    public function setCompleted(\StructType\DecimalValue $completed = null)
    {
        if (is_null($completed) || (is_array($completed) && empty($completed))) {
            unset($this->Completed);
        } else {
            $this->Completed = $completed;
        }
        return $this;
    }
    /**
     * Get CostAtCompletion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getCostAtCompletion()
    {
        return isset($this->CostAtCompletion) ? $this->CostAtCompletion : null;
    }
    /**
     * Set CostAtCompletion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $costAtCompletion
     * @return \StructType\ProjectBudget
     */
    public function setCostAtCompletion(\StructType\DecimalValue $costAtCompletion = null)
    {
        if (is_null($costAtCompletion) || (is_array($costAtCompletion) && empty($costAtCompletion))) {
            unset($this->CostAtCompletion);
        } else {
            $this->CostAtCompletion = $costAtCompletion;
        }
        return $this;
    }
    /**
     * Get CostCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getCostCode()
    {
        return isset($this->CostCode) ? $this->CostCode : null;
    }
    /**
     * Set CostCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $costCode
     * @return \StructType\ProjectBudget
     */
    public function setCostCode(\StructType\StringValue $costCode = null)
    {
        if (is_null($costCode) || (is_array($costCode) && empty($costCode))) {
            unset($this->CostCode);
        } else {
            $this->CostCode = $costCode;
        }
        return $this;
    }
    /**
     * Get CostToComplete value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getCostToComplete()
    {
        return isset($this->CostToComplete) ? $this->CostToComplete : null;
    }
    /**
     * Set CostToComplete value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $costToComplete
     * @return \StructType\ProjectBudget
     */
    public function setCostToComplete(\StructType\DecimalValue $costToComplete = null)
    {
        if (is_null($costToComplete) || (is_array($costToComplete) && empty($costToComplete))) {
            unset($this->CostToComplete);
        } else {
            $this->CostToComplete = $costToComplete;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $description
     * @return \StructType\ProjectBudget
     */
    public function setDescription(\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get DraftInvoicesAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getDraftInvoicesAmount()
    {
        return isset($this->DraftInvoicesAmount) ? $this->DraftInvoicesAmount : null;
    }
    /**
     * Set DraftInvoicesAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $draftInvoicesAmount
     * @return \StructType\ProjectBudget
     */
    public function setDraftInvoicesAmount(\StructType\DecimalValue $draftInvoicesAmount = null)
    {
        if (is_null($draftInvoicesAmount) || (is_array($draftInvoicesAmount) && empty($draftInvoicesAmount))) {
            unset($this->DraftInvoicesAmount);
        } else {
            $this->DraftInvoicesAmount = $draftInvoicesAmount;
        }
        return $this;
    }
    /**
     * Get InventoryID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getInventoryID()
    {
        return isset($this->InventoryID) ? $this->InventoryID : null;
    }
    /**
     * Set InventoryID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $inventoryID
     * @return \StructType\ProjectBudget
     */
    public function setInventoryID(\StructType\StringValue $inventoryID = null)
    {
        if (is_null($inventoryID) || (is_array($inventoryID) && empty($inventoryID))) {
            unset($this->InventoryID);
        } else {
            $this->InventoryID = $inventoryID;
        }
        return $this;
    }
    /**
     * Get LastCostAtCompletion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getLastCostAtCompletion()
    {
        return isset($this->LastCostAtCompletion) ? $this->LastCostAtCompletion : null;
    }
    /**
     * Set LastCostAtCompletion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $lastCostAtCompletion
     * @return \StructType\ProjectBudget
     */
    public function setLastCostAtCompletion(\StructType\DecimalValue $lastCostAtCompletion = null)
    {
        if (is_null($lastCostAtCompletion) || (is_array($lastCostAtCompletion) && empty($lastCostAtCompletion))) {
            unset($this->LastCostAtCompletion);
        } else {
            $this->LastCostAtCompletion = $lastCostAtCompletion;
        }
        return $this;
    }
    /**
     * Get LastCostToComplete value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getLastCostToComplete()
    {
        return isset($this->LastCostToComplete) ? $this->LastCostToComplete : null;
    }
    /**
     * Set LastCostToComplete value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $lastCostToComplete
     * @return \StructType\ProjectBudget
     */
    public function setLastCostToComplete(\StructType\DecimalValue $lastCostToComplete = null)
    {
        if (is_null($lastCostToComplete) || (is_array($lastCostToComplete) && empty($lastCostToComplete))) {
            unset($this->LastCostToComplete);
        } else {
            $this->LastCostToComplete = $lastCostToComplete;
        }
        return $this;
    }
    /**
     * Get LastModifiedDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DateTimeValue|null
     */
    public function getLastModifiedDateTime()
    {
        return isset($this->LastModifiedDateTime) ? $this->LastModifiedDateTime : null;
    }
    /**
     * Set LastModifiedDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DateTimeValue $lastModifiedDateTime
     * @return \StructType\ProjectBudget
     */
    public function setLastModifiedDateTime(\StructType\DateTimeValue $lastModifiedDateTime = null)
    {
        if (is_null($lastModifiedDateTime) || (is_array($lastModifiedDateTime) && empty($lastModifiedDateTime))) {
            unset($this->LastModifiedDateTime);
        } else {
            $this->LastModifiedDateTime = $lastModifiedDateTime;
        }
        return $this;
    }
    /**
     * Get LastPercentageOfCompletion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getLastPercentageOfCompletion()
    {
        return isset($this->LastPercentageOfCompletion) ? $this->LastPercentageOfCompletion : null;
    }
    /**
     * Set LastPercentageOfCompletion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $lastPercentageOfCompletion
     * @return \StructType\ProjectBudget
     */
    public function setLastPercentageOfCompletion(\StructType\DecimalValue $lastPercentageOfCompletion = null)
    {
        if (is_null($lastPercentageOfCompletion) || (is_array($lastPercentageOfCompletion) && empty($lastPercentageOfCompletion))) {
            unset($this->LastPercentageOfCompletion);
        } else {
            $this->LastPercentageOfCompletion = $lastPercentageOfCompletion;
        }
        return $this;
    }
    /**
     * Get OriginalBudgetedAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getOriginalBudgetedAmount()
    {
        return isset($this->OriginalBudgetedAmount) ? $this->OriginalBudgetedAmount : null;
    }
    /**
     * Set OriginalBudgetedAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $originalBudgetedAmount
     * @return \StructType\ProjectBudget
     */
    public function setOriginalBudgetedAmount(\StructType\DecimalValue $originalBudgetedAmount = null)
    {
        if (is_null($originalBudgetedAmount) || (is_array($originalBudgetedAmount) && empty($originalBudgetedAmount))) {
            unset($this->OriginalBudgetedAmount);
        } else {
            $this->OriginalBudgetedAmount = $originalBudgetedAmount;
        }
        return $this;
    }
    /**
     * Get OriginalBudgetedQty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getOriginalBudgetedQty()
    {
        return isset($this->OriginalBudgetedQty) ? $this->OriginalBudgetedQty : null;
    }
    /**
     * Set OriginalBudgetedQty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $originalBudgetedQty
     * @return \StructType\ProjectBudget
     */
    public function setOriginalBudgetedQty(\StructType\DecimalValue $originalBudgetedQty = null)
    {
        if (is_null($originalBudgetedQty) || (is_array($originalBudgetedQty) && empty($originalBudgetedQty))) {
            unset($this->OriginalBudgetedQty);
        } else {
            $this->OriginalBudgetedQty = $originalBudgetedQty;
        }
        return $this;
    }
    /**
     * Get OriginalCommittedAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getOriginalCommittedAmount()
    {
        return isset($this->OriginalCommittedAmount) ? $this->OriginalCommittedAmount : null;
    }
    /**
     * Set OriginalCommittedAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $originalCommittedAmount
     * @return \StructType\ProjectBudget
     */
    public function setOriginalCommittedAmount(\StructType\DecimalValue $originalCommittedAmount = null)
    {
        if (is_null($originalCommittedAmount) || (is_array($originalCommittedAmount) && empty($originalCommittedAmount))) {
            unset($this->OriginalCommittedAmount);
        } else {
            $this->OriginalCommittedAmount = $originalCommittedAmount;
        }
        return $this;
    }
    /**
     * Get OriginalCommittedQty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getOriginalCommittedQty()
    {
        return isset($this->OriginalCommittedQty) ? $this->OriginalCommittedQty : null;
    }
    /**
     * Set OriginalCommittedQty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $originalCommittedQty
     * @return \StructType\ProjectBudget
     */
    public function setOriginalCommittedQty(\StructType\DecimalValue $originalCommittedQty = null)
    {
        if (is_null($originalCommittedQty) || (is_array($originalCommittedQty) && empty($originalCommittedQty))) {
            unset($this->OriginalCommittedQty);
        } else {
            $this->OriginalCommittedQty = $originalCommittedQty;
        }
        return $this;
    }
    /**
     * Get PendingInvoiceAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getPendingInvoiceAmount()
    {
        return isset($this->PendingInvoiceAmount) ? $this->PendingInvoiceAmount : null;
    }
    /**
     * Set PendingInvoiceAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $pendingInvoiceAmount
     * @return \StructType\ProjectBudget
     */
    public function setPendingInvoiceAmount(\StructType\DecimalValue $pendingInvoiceAmount = null)
    {
        if (is_null($pendingInvoiceAmount) || (is_array($pendingInvoiceAmount) && empty($pendingInvoiceAmount))) {
            unset($this->PendingInvoiceAmount);
        } else {
            $this->PendingInvoiceAmount = $pendingInvoiceAmount;
        }
        return $this;
    }
    /**
     * Get PercentageOfCompletion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getPercentageOfCompletion()
    {
        return isset($this->PercentageOfCompletion) ? $this->PercentageOfCompletion : null;
    }
    /**
     * Set PercentageOfCompletion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $percentageOfCompletion
     * @return \StructType\ProjectBudget
     */
    public function setPercentageOfCompletion(\StructType\DecimalValue $percentageOfCompletion = null)
    {
        if (is_null($percentageOfCompletion) || (is_array($percentageOfCompletion) && empty($percentageOfCompletion))) {
            unset($this->PercentageOfCompletion);
        } else {
            $this->PercentageOfCompletion = $percentageOfCompletion;
        }
        return $this;
    }
    /**
     * Get Performance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getPerformance()
    {
        return isset($this->Performance) ? $this->Performance : null;
    }
    /**
     * Set Performance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $performance
     * @return \StructType\ProjectBudget
     */
    public function setPerformance(\StructType\DecimalValue $performance = null)
    {
        if (is_null($performance) || (is_array($performance) && empty($performance))) {
            unset($this->Performance);
        } else {
            $this->Performance = $performance;
        }
        return $this;
    }
    /**
     * Get ProjectID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getProjectID()
    {
        return isset($this->ProjectID) ? $this->ProjectID : null;
    }
    /**
     * Set ProjectID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $projectID
     * @return \StructType\ProjectBudget
     */
    public function setProjectID(\StructType\StringValue $projectID = null)
    {
        if (is_null($projectID) || (is_array($projectID) && empty($projectID))) {
            unset($this->ProjectID);
        } else {
            $this->ProjectID = $projectID;
        }
        return $this;
    }
    /**
     * Get ProjectTaskID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getProjectTaskID()
    {
        return isset($this->ProjectTaskID) ? $this->ProjectTaskID : null;
    }
    /**
     * Set ProjectTaskID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $projectTaskID
     * @return \StructType\ProjectBudget
     */
    public function setProjectTaskID(\StructType\StringValue $projectTaskID = null)
    {
        if (is_null($projectTaskID) || (is_array($projectTaskID) && empty($projectTaskID))) {
            unset($this->ProjectTaskID);
        } else {
            $this->ProjectTaskID = $projectTaskID;
        }
        return $this;
    }
    /**
     * Get Retainage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getRetainage()
    {
        return isset($this->Retainage) ? $this->Retainage : null;
    }
    /**
     * Set Retainage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $retainage
     * @return \StructType\ProjectBudget
     */
    public function setRetainage(\StructType\DecimalValue $retainage = null)
    {
        if (is_null($retainage) || (is_array($retainage) && empty($retainage))) {
            unset($this->Retainage);
        } else {
            $this->Retainage = $retainage;
        }
        return $this;
    }
    /**
     * Get RevenueTask value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\IntValue|null
     */
    public function getRevenueTask()
    {
        return isset($this->RevenueTask) ? $this->RevenueTask : null;
    }
    /**
     * Set RevenueTask value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\IntValue $revenueTask
     * @return \StructType\ProjectBudget
     */
    public function setRevenueTask(\StructType\IntValue $revenueTask = null)
    {
        if (is_null($revenueTask) || (is_array($revenueTask) && empty($revenueTask))) {
            unset($this->RevenueTask);
        } else {
            $this->RevenueTask = $revenueTask;
        }
        return $this;
    }
    /**
     * Get RevisedBudgetedAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getRevisedBudgetedAmount()
    {
        return isset($this->RevisedBudgetedAmount) ? $this->RevisedBudgetedAmount : null;
    }
    /**
     * Set RevisedBudgetedAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $revisedBudgetedAmount
     * @return \StructType\ProjectBudget
     */
    public function setRevisedBudgetedAmount(\StructType\DecimalValue $revisedBudgetedAmount = null)
    {
        if (is_null($revisedBudgetedAmount) || (is_array($revisedBudgetedAmount) && empty($revisedBudgetedAmount))) {
            unset($this->RevisedBudgetedAmount);
        } else {
            $this->RevisedBudgetedAmount = $revisedBudgetedAmount;
        }
        return $this;
    }
    /**
     * Get RevisedBudgetedQty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getRevisedBudgetedQty()
    {
        return isset($this->RevisedBudgetedQty) ? $this->RevisedBudgetedQty : null;
    }
    /**
     * Set RevisedBudgetedQty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $revisedBudgetedQty
     * @return \StructType\ProjectBudget
     */
    public function setRevisedBudgetedQty(\StructType\DecimalValue $revisedBudgetedQty = null)
    {
        if (is_null($revisedBudgetedQty) || (is_array($revisedBudgetedQty) && empty($revisedBudgetedQty))) {
            unset($this->RevisedBudgetedQty);
        } else {
            $this->RevisedBudgetedQty = $revisedBudgetedQty;
        }
        return $this;
    }
    /**
     * Get RevisedCommittedAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getRevisedCommittedAmount()
    {
        return isset($this->RevisedCommittedAmount) ? $this->RevisedCommittedAmount : null;
    }
    /**
     * Set RevisedCommittedAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $revisedCommittedAmount
     * @return \StructType\ProjectBudget
     */
    public function setRevisedCommittedAmount(\StructType\DecimalValue $revisedCommittedAmount = null)
    {
        if (is_null($revisedCommittedAmount) || (is_array($revisedCommittedAmount) && empty($revisedCommittedAmount))) {
            unset($this->RevisedCommittedAmount);
        } else {
            $this->RevisedCommittedAmount = $revisedCommittedAmount;
        }
        return $this;
    }
    /**
     * Get RevisedCommittedQty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getRevisedCommittedQty()
    {
        return isset($this->RevisedCommittedQty) ? $this->RevisedCommittedQty : null;
    }
    /**
     * Set RevisedCommittedQty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $revisedCommittedQty
     * @return \StructType\ProjectBudget
     */
    public function setRevisedCommittedQty(\StructType\DecimalValue $revisedCommittedQty = null)
    {
        if (is_null($revisedCommittedQty) || (is_array($revisedCommittedQty) && empty($revisedCommittedQty))) {
            unset($this->RevisedCommittedQty);
        } else {
            $this->RevisedCommittedQty = $revisedCommittedQty;
        }
        return $this;
    }
    /**
     * Get TaxCategory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getTaxCategory()
    {
        return isset($this->TaxCategory) ? $this->TaxCategory : null;
    }
    /**
     * Set TaxCategory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $taxCategory
     * @return \StructType\ProjectBudget
     */
    public function setTaxCategory(\StructType\StringValue $taxCategory = null)
    {
        if (is_null($taxCategory) || (is_array($taxCategory) && empty($taxCategory))) {
            unset($this->TaxCategory);
        } else {
            $this->TaxCategory = $taxCategory;
        }
        return $this;
    }
    /**
     * Get Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getType()
    {
        return isset($this->Type) ? $this->Type : null;
    }
    /**
     * Set Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $type
     * @return \StructType\ProjectBudget
     */
    public function setType(\StructType\StringValue $type = null)
    {
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->Type);
        } else {
            $this->Type = $type;
        }
        return $this;
    }
    /**
     * Get UnitRate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getUnitRate()
    {
        return isset($this->UnitRate) ? $this->UnitRate : null;
    }
    /**
     * Set UnitRate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $unitRate
     * @return \StructType\ProjectBudget
     */
    public function setUnitRate(\StructType\DecimalValue $unitRate = null)
    {
        if (is_null($unitRate) || (is_array($unitRate) && empty($unitRate))) {
            unset($this->UnitRate);
        } else {
            $this->UnitRate = $unitRate;
        }
        return $this;
    }
    /**
     * Get UOM value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getUOM()
    {
        return isset($this->UOM) ? $this->UOM : null;
    }
    /**
     * Set UOM value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $uOM
     * @return \StructType\ProjectBudget
     */
    public function setUOM(\StructType\StringValue $uOM = null)
    {
        if (is_null($uOM) || (is_array($uOM) && empty($uOM))) {
            unset($this->UOM);
        } else {
            $this->UOM = $uOM;
        }
        return $this;
    }
    /**
     * Get VarianceAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getVarianceAmount()
    {
        return isset($this->VarianceAmount) ? $this->VarianceAmount : null;
    }
    /**
     * Set VarianceAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $varianceAmount
     * @return \StructType\ProjectBudget
     */
    public function setVarianceAmount(\StructType\DecimalValue $varianceAmount = null)
    {
        if (is_null($varianceAmount) || (is_array($varianceAmount) && empty($varianceAmount))) {
            unset($this->VarianceAmount);
        } else {
            $this->VarianceAmount = $varianceAmount;
        }
        return $this;
    }
}
