<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProjectBillingRules StructType
 * @subpackage Structs
 */
class ProjectBillingRules extends Entity
{
    /**
     * The Active
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $Active;
    /**
     * The BillingRuleID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $BillingRuleID;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Description;
    /**
     * Constructor method for ProjectBillingRules
     * @uses ProjectBillingRules::setActive()
     * @uses ProjectBillingRules::setBillingRuleID()
     * @uses ProjectBillingRules::setDescription()
     * @param \StructType\BooleanValue $active
     * @param \StructType\StringValue $billingRuleID
     * @param \StructType\StringValue $description
     */
    public function __construct(\StructType\BooleanValue $active = null, \StructType\StringValue $billingRuleID = null, \StructType\StringValue $description = null)
    {
        $this
            ->setActive($active)
            ->setBillingRuleID($billingRuleID)
            ->setDescription($description);
    }
    /**
     * Get Active value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getActive()
    {
        return isset($this->Active) ? $this->Active : null;
    }
    /**
     * Set Active value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $active
     * @return \StructType\ProjectBillingRules
     */
    public function setActive(\StructType\BooleanValue $active = null)
    {
        if (is_null($active) || (is_array($active) && empty($active))) {
            unset($this->Active);
        } else {
            $this->Active = $active;
        }
        return $this;
    }
    /**
     * Get BillingRuleID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getBillingRuleID()
    {
        return isset($this->BillingRuleID) ? $this->BillingRuleID : null;
    }
    /**
     * Set BillingRuleID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $billingRuleID
     * @return \StructType\ProjectBillingRules
     */
    public function setBillingRuleID(\StructType\StringValue $billingRuleID = null)
    {
        if (is_null($billingRuleID) || (is_array($billingRuleID) && empty($billingRuleID))) {
            unset($this->BillingRuleID);
        } else {
            $this->BillingRuleID = $billingRuleID;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $description
     * @return \StructType\ProjectBillingRules
     */
    public function setDescription(\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
}
