<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProjectBalance StructType
 * @subpackage Structs
 */
class ProjectBalance extends Entity
{
    /**
     * The AccountGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $AccountGroup;
    /**
     * The ActualAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $ActualAmount;
    /**
     * The ActualOpenCommittedAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $ActualOpenCommittedAmount;
    /**
     * The BudgetedCOAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $BudgetedCOAmount;
    /**
     * The CommittedCOAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $CommittedCOAmount;
    /**
     * The CommittedInvoicedAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $CommittedInvoicedAmount;
    /**
     * The CommittedOpenAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $CommittedOpenAmount;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Description;
    /**
     * The OriginalBudgetedAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $OriginalBudgetedAmount;
    /**
     * The OriginalCommittedAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $OriginalCommittedAmount;
    /**
     * The Performance
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $Performance;
    /**
     * The RevisedBudgetedAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $RevisedBudgetedAmount;
    /**
     * The RevisedCommittedAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $RevisedCommittedAmount;
    /**
     * The VarianceAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $VarianceAmount;
    /**
     * Constructor method for ProjectBalance
     * @uses ProjectBalance::setAccountGroup()
     * @uses ProjectBalance::setActualAmount()
     * @uses ProjectBalance::setActualOpenCommittedAmount()
     * @uses ProjectBalance::setBudgetedCOAmount()
     * @uses ProjectBalance::setCommittedCOAmount()
     * @uses ProjectBalance::setCommittedInvoicedAmount()
     * @uses ProjectBalance::setCommittedOpenAmount()
     * @uses ProjectBalance::setDescription()
     * @uses ProjectBalance::setOriginalBudgetedAmount()
     * @uses ProjectBalance::setOriginalCommittedAmount()
     * @uses ProjectBalance::setPerformance()
     * @uses ProjectBalance::setRevisedBudgetedAmount()
     * @uses ProjectBalance::setRevisedCommittedAmount()
     * @uses ProjectBalance::setVarianceAmount()
     * @param \StructType\StringValue $accountGroup
     * @param \StructType\DecimalValue $actualAmount
     * @param \StructType\DecimalValue $actualOpenCommittedAmount
     * @param \StructType\DecimalValue $budgetedCOAmount
     * @param \StructType\DecimalValue $committedCOAmount
     * @param \StructType\DecimalValue $committedInvoicedAmount
     * @param \StructType\DecimalValue $committedOpenAmount
     * @param \StructType\StringValue $description
     * @param \StructType\DecimalValue $originalBudgetedAmount
     * @param \StructType\DecimalValue $originalCommittedAmount
     * @param \StructType\DecimalValue $performance
     * @param \StructType\DecimalValue $revisedBudgetedAmount
     * @param \StructType\DecimalValue $revisedCommittedAmount
     * @param \StructType\DecimalValue $varianceAmount
     */
    public function __construct(\StructType\StringValue $accountGroup = null, \StructType\DecimalValue $actualAmount = null, \StructType\DecimalValue $actualOpenCommittedAmount = null, \StructType\DecimalValue $budgetedCOAmount = null, \StructType\DecimalValue $committedCOAmount = null, \StructType\DecimalValue $committedInvoicedAmount = null, \StructType\DecimalValue $committedOpenAmount = null, \StructType\StringValue $description = null, \StructType\DecimalValue $originalBudgetedAmount = null, \StructType\DecimalValue $originalCommittedAmount = null, \StructType\DecimalValue $performance = null, \StructType\DecimalValue $revisedBudgetedAmount = null, \StructType\DecimalValue $revisedCommittedAmount = null, \StructType\DecimalValue $varianceAmount = null)
    {
        $this
            ->setAccountGroup($accountGroup)
            ->setActualAmount($actualAmount)
            ->setActualOpenCommittedAmount($actualOpenCommittedAmount)
            ->setBudgetedCOAmount($budgetedCOAmount)
            ->setCommittedCOAmount($committedCOAmount)
            ->setCommittedInvoicedAmount($committedInvoicedAmount)
            ->setCommittedOpenAmount($committedOpenAmount)
            ->setDescription($description)
            ->setOriginalBudgetedAmount($originalBudgetedAmount)
            ->setOriginalCommittedAmount($originalCommittedAmount)
            ->setPerformance($performance)
            ->setRevisedBudgetedAmount($revisedBudgetedAmount)
            ->setRevisedCommittedAmount($revisedCommittedAmount)
            ->setVarianceAmount($varianceAmount);
    }
    /**
     * Get AccountGroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getAccountGroup()
    {
        return isset($this->AccountGroup) ? $this->AccountGroup : null;
    }
    /**
     * Set AccountGroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $accountGroup
     * @return \StructType\ProjectBalance
     */
    public function setAccountGroup(\StructType\StringValue $accountGroup = null)
    {
        if (is_null($accountGroup) || (is_array($accountGroup) && empty($accountGroup))) {
            unset($this->AccountGroup);
        } else {
            $this->AccountGroup = $accountGroup;
        }
        return $this;
    }
    /**
     * Get ActualAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getActualAmount()
    {
        return isset($this->ActualAmount) ? $this->ActualAmount : null;
    }
    /**
     * Set ActualAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $actualAmount
     * @return \StructType\ProjectBalance
     */
    public function setActualAmount(\StructType\DecimalValue $actualAmount = null)
    {
        if (is_null($actualAmount) || (is_array($actualAmount) && empty($actualAmount))) {
            unset($this->ActualAmount);
        } else {
            $this->ActualAmount = $actualAmount;
        }
        return $this;
    }
    /**
     * Get ActualOpenCommittedAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getActualOpenCommittedAmount()
    {
        return isset($this->ActualOpenCommittedAmount) ? $this->ActualOpenCommittedAmount : null;
    }
    /**
     * Set ActualOpenCommittedAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $actualOpenCommittedAmount
     * @return \StructType\ProjectBalance
     */
    public function setActualOpenCommittedAmount(\StructType\DecimalValue $actualOpenCommittedAmount = null)
    {
        if (is_null($actualOpenCommittedAmount) || (is_array($actualOpenCommittedAmount) && empty($actualOpenCommittedAmount))) {
            unset($this->ActualOpenCommittedAmount);
        } else {
            $this->ActualOpenCommittedAmount = $actualOpenCommittedAmount;
        }
        return $this;
    }
    /**
     * Get BudgetedCOAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getBudgetedCOAmount()
    {
        return isset($this->BudgetedCOAmount) ? $this->BudgetedCOAmount : null;
    }
    /**
     * Set BudgetedCOAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $budgetedCOAmount
     * @return \StructType\ProjectBalance
     */
    public function setBudgetedCOAmount(\StructType\DecimalValue $budgetedCOAmount = null)
    {
        if (is_null($budgetedCOAmount) || (is_array($budgetedCOAmount) && empty($budgetedCOAmount))) {
            unset($this->BudgetedCOAmount);
        } else {
            $this->BudgetedCOAmount = $budgetedCOAmount;
        }
        return $this;
    }
    /**
     * Get CommittedCOAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getCommittedCOAmount()
    {
        return isset($this->CommittedCOAmount) ? $this->CommittedCOAmount : null;
    }
    /**
     * Set CommittedCOAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $committedCOAmount
     * @return \StructType\ProjectBalance
     */
    public function setCommittedCOAmount(\StructType\DecimalValue $committedCOAmount = null)
    {
        if (is_null($committedCOAmount) || (is_array($committedCOAmount) && empty($committedCOAmount))) {
            unset($this->CommittedCOAmount);
        } else {
            $this->CommittedCOAmount = $committedCOAmount;
        }
        return $this;
    }
    /**
     * Get CommittedInvoicedAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getCommittedInvoicedAmount()
    {
        return isset($this->CommittedInvoicedAmount) ? $this->CommittedInvoicedAmount : null;
    }
    /**
     * Set CommittedInvoicedAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $committedInvoicedAmount
     * @return \StructType\ProjectBalance
     */
    public function setCommittedInvoicedAmount(\StructType\DecimalValue $committedInvoicedAmount = null)
    {
        if (is_null($committedInvoicedAmount) || (is_array($committedInvoicedAmount) && empty($committedInvoicedAmount))) {
            unset($this->CommittedInvoicedAmount);
        } else {
            $this->CommittedInvoicedAmount = $committedInvoicedAmount;
        }
        return $this;
    }
    /**
     * Get CommittedOpenAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getCommittedOpenAmount()
    {
        return isset($this->CommittedOpenAmount) ? $this->CommittedOpenAmount : null;
    }
    /**
     * Set CommittedOpenAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $committedOpenAmount
     * @return \StructType\ProjectBalance
     */
    public function setCommittedOpenAmount(\StructType\DecimalValue $committedOpenAmount = null)
    {
        if (is_null($committedOpenAmount) || (is_array($committedOpenAmount) && empty($committedOpenAmount))) {
            unset($this->CommittedOpenAmount);
        } else {
            $this->CommittedOpenAmount = $committedOpenAmount;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $description
     * @return \StructType\ProjectBalance
     */
    public function setDescription(\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get OriginalBudgetedAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getOriginalBudgetedAmount()
    {
        return isset($this->OriginalBudgetedAmount) ? $this->OriginalBudgetedAmount : null;
    }
    /**
     * Set OriginalBudgetedAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $originalBudgetedAmount
     * @return \StructType\ProjectBalance
     */
    public function setOriginalBudgetedAmount(\StructType\DecimalValue $originalBudgetedAmount = null)
    {
        if (is_null($originalBudgetedAmount) || (is_array($originalBudgetedAmount) && empty($originalBudgetedAmount))) {
            unset($this->OriginalBudgetedAmount);
        } else {
            $this->OriginalBudgetedAmount = $originalBudgetedAmount;
        }
        return $this;
    }
    /**
     * Get OriginalCommittedAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getOriginalCommittedAmount()
    {
        return isset($this->OriginalCommittedAmount) ? $this->OriginalCommittedAmount : null;
    }
    /**
     * Set OriginalCommittedAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $originalCommittedAmount
     * @return \StructType\ProjectBalance
     */
    public function setOriginalCommittedAmount(\StructType\DecimalValue $originalCommittedAmount = null)
    {
        if (is_null($originalCommittedAmount) || (is_array($originalCommittedAmount) && empty($originalCommittedAmount))) {
            unset($this->OriginalCommittedAmount);
        } else {
            $this->OriginalCommittedAmount = $originalCommittedAmount;
        }
        return $this;
    }
    /**
     * Get Performance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getPerformance()
    {
        return isset($this->Performance) ? $this->Performance : null;
    }
    /**
     * Set Performance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $performance
     * @return \StructType\ProjectBalance
     */
    public function setPerformance(\StructType\DecimalValue $performance = null)
    {
        if (is_null($performance) || (is_array($performance) && empty($performance))) {
            unset($this->Performance);
        } else {
            $this->Performance = $performance;
        }
        return $this;
    }
    /**
     * Get RevisedBudgetedAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getRevisedBudgetedAmount()
    {
        return isset($this->RevisedBudgetedAmount) ? $this->RevisedBudgetedAmount : null;
    }
    /**
     * Set RevisedBudgetedAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $revisedBudgetedAmount
     * @return \StructType\ProjectBalance
     */
    public function setRevisedBudgetedAmount(\StructType\DecimalValue $revisedBudgetedAmount = null)
    {
        if (is_null($revisedBudgetedAmount) || (is_array($revisedBudgetedAmount) && empty($revisedBudgetedAmount))) {
            unset($this->RevisedBudgetedAmount);
        } else {
            $this->RevisedBudgetedAmount = $revisedBudgetedAmount;
        }
        return $this;
    }
    /**
     * Get RevisedCommittedAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getRevisedCommittedAmount()
    {
        return isset($this->RevisedCommittedAmount) ? $this->RevisedCommittedAmount : null;
    }
    /**
     * Set RevisedCommittedAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $revisedCommittedAmount
     * @return \StructType\ProjectBalance
     */
    public function setRevisedCommittedAmount(\StructType\DecimalValue $revisedCommittedAmount = null)
    {
        if (is_null($revisedCommittedAmount) || (is_array($revisedCommittedAmount) && empty($revisedCommittedAmount))) {
            unset($this->RevisedCommittedAmount);
        } else {
            $this->RevisedCommittedAmount = $revisedCommittedAmount;
        }
        return $this;
    }
    /**
     * Get VarianceAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getVarianceAmount()
    {
        return isset($this->VarianceAmount) ? $this->VarianceAmount : null;
    }
    /**
     * Set VarianceAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $varianceAmount
     * @return \StructType\ProjectBalance
     */
    public function setVarianceAmount(\StructType\DecimalValue $varianceAmount = null)
    {
        if (is_null($varianceAmount) || (is_array($varianceAmount) && empty($varianceAmount))) {
            unset($this->VarianceAmount);
        } else {
            $this->VarianceAmount = $varianceAmount;
        }
        return $this;
    }
}
