<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentOrderDetail StructType
 * @subpackage Structs
 */
class PaymentOrderDetail extends Entity
{
    /**
     * The AppliedToOrder
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $AppliedToOrder;
    /**
     * The OrderNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $OrderNbr;
    /**
     * The OrderType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $OrderType;
    /**
     * Constructor method for PaymentOrderDetail
     * @uses PaymentOrderDetail::setAppliedToOrder()
     * @uses PaymentOrderDetail::setOrderNbr()
     * @uses PaymentOrderDetail::setOrderType()
     * @param \StructType\DecimalValue $appliedToOrder
     * @param \StructType\StringValue $orderNbr
     * @param \StructType\StringValue $orderType
     */
    public function __construct(\StructType\DecimalValue $appliedToOrder = null, \StructType\StringValue $orderNbr = null, \StructType\StringValue $orderType = null)
    {
        $this
            ->setAppliedToOrder($appliedToOrder)
            ->setOrderNbr($orderNbr)
            ->setOrderType($orderType);
    }
    /**
     * Get AppliedToOrder value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getAppliedToOrder()
    {
        return isset($this->AppliedToOrder) ? $this->AppliedToOrder : null;
    }
    /**
     * Set AppliedToOrder value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $appliedToOrder
     * @return \StructType\PaymentOrderDetail
     */
    public function setAppliedToOrder(\StructType\DecimalValue $appliedToOrder = null)
    {
        if (is_null($appliedToOrder) || (is_array($appliedToOrder) && empty($appliedToOrder))) {
            unset($this->AppliedToOrder);
        } else {
            $this->AppliedToOrder = $appliedToOrder;
        }
        return $this;
    }
    /**
     * Get OrderNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getOrderNbr()
    {
        return isset($this->OrderNbr) ? $this->OrderNbr : null;
    }
    /**
     * Set OrderNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $orderNbr
     * @return \StructType\PaymentOrderDetail
     */
    public function setOrderNbr(\StructType\StringValue $orderNbr = null)
    {
        if (is_null($orderNbr) || (is_array($orderNbr) && empty($orderNbr))) {
            unset($this->OrderNbr);
        } else {
            $this->OrderNbr = $orderNbr;
        }
        return $this;
    }
    /**
     * Get OrderType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getOrderType()
    {
        return isset($this->OrderType) ? $this->OrderType : null;
    }
    /**
     * Set OrderType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $orderType
     * @return \StructType\PaymentOrderDetail
     */
    public function setOrderType(\StructType\StringValue $orderType = null)
    {
        if (is_null($orderType) || (is_array($orderType) && empty($orderType))) {
            unset($this->OrderType);
        } else {
            $this->OrderType = $orderType;
        }
        return $this;
    }
}
