<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MarketingLists StructType
 * @subpackage Structs
 */
class MarketingLists extends AbstractStructBase
{
    /**
     * The MarketingListDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\MarketingListDetail[]
     */
    public $MarketingListDetail;
    /**
     * The BusinessAccountMarketingListDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BusinessAccountMarketingListDetail[]
     */
    public $BusinessAccountMarketingListDetail;
    /**
     * Constructor method for MarketingLists
     * @uses MarketingLists::setMarketingListDetail()
     * @uses MarketingLists::setBusinessAccountMarketingListDetail()
     * @param \StructType\MarketingListDetail[] $marketingListDetail
     * @param \StructType\BusinessAccountMarketingListDetail[] $businessAccountMarketingListDetail
     */
    public function __construct(array $marketingListDetail = array(), array $businessAccountMarketingListDetail = array())
    {
        $this
            ->setMarketingListDetail($marketingListDetail)
            ->setBusinessAccountMarketingListDetail($businessAccountMarketingListDetail);
    }
    /**
     * Get MarketingListDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\MarketingListDetail[]|null
     */
    public function getMarketingListDetail()
    {
        return isset($this->MarketingListDetail) ? $this->MarketingListDetail : null;
    }
    /**
     * This method is responsible for validating the values passed to the setMarketingListDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMarketingListDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMarketingListDetailForArrayConstraintsFromSetMarketingListDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $marketingListsMarketingListDetailItem) {
            // validation for constraint: itemType
            if (!$marketingListsMarketingListDetailItem instanceof \StructType\MarketingListDetail) {
                $invalidValues[] = is_object($marketingListsMarketingListDetailItem) ? get_class($marketingListsMarketingListDetailItem) : sprintf('%s(%s)', gettype($marketingListsMarketingListDetailItem), var_export($marketingListsMarketingListDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MarketingListDetail property can only contain items of type \StructType\MarketingListDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MarketingListDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\MarketingListDetail[] $marketingListDetail
     * @return \StructType\MarketingLists
     */
    public function setMarketingListDetail(array $marketingListDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($marketingListDetailArrayErrorMessage = self::validateMarketingListDetailForArrayConstraintsFromSetMarketingListDetail($marketingListDetail))) {
            throw new \InvalidArgumentException($marketingListDetailArrayErrorMessage, __LINE__);
        }
        if (is_null($marketingListDetail) || (is_array($marketingListDetail) && empty($marketingListDetail))) {
            unset($this->MarketingListDetail);
        } else {
            $this->MarketingListDetail = $marketingListDetail;
        }
        return $this;
    }
    /**
     * Add item to MarketingListDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\MarketingListDetail $item
     * @return \StructType\MarketingLists
     */
    public function addToMarketingListDetail(\StructType\MarketingListDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MarketingListDetail) {
            throw new \InvalidArgumentException(sprintf('The MarketingListDetail property can only contain items of type \StructType\MarketingListDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MarketingListDetail[] = $item;
        return $this;
    }
    /**
     * Get BusinessAccountMarketingListDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BusinessAccountMarketingListDetail[]|null
     */
    public function getBusinessAccountMarketingListDetail()
    {
        return isset($this->BusinessAccountMarketingListDetail) ? $this->BusinessAccountMarketingListDetail : null;
    }
    /**
     * This method is responsible for validating the values passed to the setBusinessAccountMarketingListDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBusinessAccountMarketingListDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBusinessAccountMarketingListDetailForArrayConstraintsFromSetBusinessAccountMarketingListDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $marketingListsBusinessAccountMarketingListDetailItem) {
            // validation for constraint: itemType
            if (!$marketingListsBusinessAccountMarketingListDetailItem instanceof \StructType\BusinessAccountMarketingListDetail) {
                $invalidValues[] = is_object($marketingListsBusinessAccountMarketingListDetailItem) ? get_class($marketingListsBusinessAccountMarketingListDetailItem) : sprintf('%s(%s)', gettype($marketingListsBusinessAccountMarketingListDetailItem), var_export($marketingListsBusinessAccountMarketingListDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BusinessAccountMarketingListDetail property can only contain items of type \StructType\BusinessAccountMarketingListDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BusinessAccountMarketingListDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\BusinessAccountMarketingListDetail[] $businessAccountMarketingListDetail
     * @return \StructType\MarketingLists
     */
    public function setBusinessAccountMarketingListDetail(array $businessAccountMarketingListDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($businessAccountMarketingListDetailArrayErrorMessage = self::validateBusinessAccountMarketingListDetailForArrayConstraintsFromSetBusinessAccountMarketingListDetail($businessAccountMarketingListDetail))) {
            throw new \InvalidArgumentException($businessAccountMarketingListDetailArrayErrorMessage, __LINE__);
        }
        if (is_null($businessAccountMarketingListDetail) || (is_array($businessAccountMarketingListDetail) && empty($businessAccountMarketingListDetail))) {
            unset($this->BusinessAccountMarketingListDetail);
        } else {
            $this->BusinessAccountMarketingListDetail = $businessAccountMarketingListDetail;
        }
        return $this;
    }
    /**
     * Add item to BusinessAccountMarketingListDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\BusinessAccountMarketingListDetail $item
     * @return \StructType\MarketingLists
     */
    public function addToBusinessAccountMarketingListDetail(\StructType\BusinessAccountMarketingListDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BusinessAccountMarketingListDetail) {
            throw new \InvalidArgumentException(sprintf('The BusinessAccountMarketingListDetail property can only contain items of type \StructType\BusinessAccountMarketingListDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->BusinessAccountMarketingListDetail[] = $item;
        return $this;
    }
}
