<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemSalesCategory StructType
 * @subpackage Structs
 */
class ItemSalesCategory extends Entity
{
    /**
     * The CategoryID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\IntValue
     */
    public $CategoryID;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Description;
    /**
     * The LastModifiedDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DateTimeValue
     */
    public $LastModifiedDateTime;
    /**
     * The Members
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Members
     */
    public $Members;
    /**
     * The ParentCategoryID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\IntValue
     */
    public $ParentCategoryID;
    /**
     * The Path
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Path;
    /**
     * Constructor method for ItemSalesCategory
     * @uses ItemSalesCategory::setCategoryID()
     * @uses ItemSalesCategory::setDescription()
     * @uses ItemSalesCategory::setLastModifiedDateTime()
     * @uses ItemSalesCategory::setMembers()
     * @uses ItemSalesCategory::setParentCategoryID()
     * @uses ItemSalesCategory::setPath()
     * @param \StructType\IntValue $categoryID
     * @param \StructType\StringValue $description
     * @param \StructType\DateTimeValue $lastModifiedDateTime
     * @param \StructType\Members $members
     * @param \StructType\IntValue $parentCategoryID
     * @param \StructType\StringValue $path
     */
    public function __construct(\StructType\IntValue $categoryID = null, \StructType\StringValue $description = null, \StructType\DateTimeValue $lastModifiedDateTime = null, \StructType\Members $members = null, \StructType\IntValue $parentCategoryID = null, \StructType\StringValue $path = null)
    {
        $this
            ->setCategoryID($categoryID)
            ->setDescription($description)
            ->setLastModifiedDateTime($lastModifiedDateTime)
            ->setMembers($members)
            ->setParentCategoryID($parentCategoryID)
            ->setPath($path);
    }
    /**
     * Get CategoryID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\IntValue|null
     */
    public function getCategoryID()
    {
        return isset($this->CategoryID) ? $this->CategoryID : null;
    }
    /**
     * Set CategoryID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\IntValue $categoryID
     * @return \StructType\ItemSalesCategory
     */
    public function setCategoryID(\StructType\IntValue $categoryID = null)
    {
        if (is_null($categoryID) || (is_array($categoryID) && empty($categoryID))) {
            unset($this->CategoryID);
        } else {
            $this->CategoryID = $categoryID;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $description
     * @return \StructType\ItemSalesCategory
     */
    public function setDescription(\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get LastModifiedDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DateTimeValue|null
     */
    public function getLastModifiedDateTime()
    {
        return isset($this->LastModifiedDateTime) ? $this->LastModifiedDateTime : null;
    }
    /**
     * Set LastModifiedDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DateTimeValue $lastModifiedDateTime
     * @return \StructType\ItemSalesCategory
     */
    public function setLastModifiedDateTime(\StructType\DateTimeValue $lastModifiedDateTime = null)
    {
        if (is_null($lastModifiedDateTime) || (is_array($lastModifiedDateTime) && empty($lastModifiedDateTime))) {
            unset($this->LastModifiedDateTime);
        } else {
            $this->LastModifiedDateTime = $lastModifiedDateTime;
        }
        return $this;
    }
    /**
     * Get Members value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Members|null
     */
    public function getMembers()
    {
        return isset($this->Members) ? $this->Members : null;
    }
    /**
     * Set Members value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Members $members
     * @return \StructType\ItemSalesCategory
     */
    public function setMembers(\StructType\Members $members = null)
    {
        if (is_null($members) || (is_array($members) && empty($members))) {
            unset($this->Members);
        } else {
            $this->Members = $members;
        }
        return $this;
    }
    /**
     * Get ParentCategoryID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\IntValue|null
     */
    public function getParentCategoryID()
    {
        return isset($this->ParentCategoryID) ? $this->ParentCategoryID : null;
    }
    /**
     * Set ParentCategoryID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\IntValue $parentCategoryID
     * @return \StructType\ItemSalesCategory
     */
    public function setParentCategoryID(\StructType\IntValue $parentCategoryID = null)
    {
        if (is_null($parentCategoryID) || (is_array($parentCategoryID) && empty($parentCategoryID))) {
            unset($this->ParentCategoryID);
        } else {
            $this->ParentCategoryID = $parentCategoryID;
        }
        return $this;
    }
    /**
     * Get Path value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getPath()
    {
        return isset($this->Path) ? $this->Path : null;
    }
    /**
     * Set Path value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $path
     * @return \StructType\ItemSalesCategory
     */
    public function setPath(\StructType\StringValue $path = null)
    {
        if (is_null($path) || (is_array($path) && empty($path))) {
            unset($this->Path);
        } else {
            $this->Path = $path;
        }
        return $this;
    }
}
