<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExternalCommitment StructType
 * @subpackage Structs
 */
class ExternalCommitment extends Entity
{
    /**
     * The AccountGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $AccountGroup;
    /**
     * The CommittedCOAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $CommittedCOAmount;
    /**
     * The CommittedCOQty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $CommittedCOQty;
    /**
     * The CommittedInvoicedAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $CommittedInvoicedAmount;
    /**
     * The CommittedInvoicedQty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $CommittedInvoicedQty;
    /**
     * The CommittedOpenAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $CommittedOpenAmount;
    /**
     * The CommittedOpenQty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $CommittedOpenQty;
    /**
     * The CommittedReceivedQty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $CommittedReceivedQty;
    /**
     * The CostCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $CostCode;
    /**
     * The ExternalRefNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ExternalRefNbr;
    /**
     * The InventoryID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $InventoryID;
    /**
     * The LastModifiedDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DateTimeValue
     */
    public $LastModifiedDateTime;
    /**
     * The OriginalCommittedAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $OriginalCommittedAmount;
    /**
     * The OriginalCommittedQty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $OriginalCommittedQty;
    /**
     * The ProjectID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ProjectID;
    /**
     * The ProjectTaskID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ProjectTaskID;
    /**
     * The RelatedDocument
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $RelatedDocument;
    /**
     * The RevisedCommittedAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $RevisedCommittedAmount;
    /**
     * The RevisedCommittedQty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $RevisedCommittedQty;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Type;
    /**
     * The UOM
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $UOM;
    /**
     * Constructor method for ExternalCommitment
     * @uses ExternalCommitment::setAccountGroup()
     * @uses ExternalCommitment::setCommittedCOAmount()
     * @uses ExternalCommitment::setCommittedCOQty()
     * @uses ExternalCommitment::setCommittedInvoicedAmount()
     * @uses ExternalCommitment::setCommittedInvoicedQty()
     * @uses ExternalCommitment::setCommittedOpenAmount()
     * @uses ExternalCommitment::setCommittedOpenQty()
     * @uses ExternalCommitment::setCommittedReceivedQty()
     * @uses ExternalCommitment::setCostCode()
     * @uses ExternalCommitment::setExternalRefNbr()
     * @uses ExternalCommitment::setInventoryID()
     * @uses ExternalCommitment::setLastModifiedDateTime()
     * @uses ExternalCommitment::setOriginalCommittedAmount()
     * @uses ExternalCommitment::setOriginalCommittedQty()
     * @uses ExternalCommitment::setProjectID()
     * @uses ExternalCommitment::setProjectTaskID()
     * @uses ExternalCommitment::setRelatedDocument()
     * @uses ExternalCommitment::setRevisedCommittedAmount()
     * @uses ExternalCommitment::setRevisedCommittedQty()
     * @uses ExternalCommitment::setType()
     * @uses ExternalCommitment::setUOM()
     * @param \StructType\StringValue $accountGroup
     * @param \StructType\DecimalValue $committedCOAmount
     * @param \StructType\DecimalValue $committedCOQty
     * @param \StructType\DecimalValue $committedInvoicedAmount
     * @param \StructType\DecimalValue $committedInvoicedQty
     * @param \StructType\DecimalValue $committedOpenAmount
     * @param \StructType\DecimalValue $committedOpenQty
     * @param \StructType\DecimalValue $committedReceivedQty
     * @param \StructType\StringValue $costCode
     * @param \StructType\StringValue $externalRefNbr
     * @param \StructType\StringValue $inventoryID
     * @param \StructType\DateTimeValue $lastModifiedDateTime
     * @param \StructType\DecimalValue $originalCommittedAmount
     * @param \StructType\DecimalValue $originalCommittedQty
     * @param \StructType\StringValue $projectID
     * @param \StructType\StringValue $projectTaskID
     * @param \StructType\StringValue $relatedDocument
     * @param \StructType\DecimalValue $revisedCommittedAmount
     * @param \StructType\DecimalValue $revisedCommittedQty
     * @param \StructType\StringValue $type
     * @param \StructType\StringValue $uOM
     */
    public function __construct(\StructType\StringValue $accountGroup = null, \StructType\DecimalValue $committedCOAmount = null, \StructType\DecimalValue $committedCOQty = null, \StructType\DecimalValue $committedInvoicedAmount = null, \StructType\DecimalValue $committedInvoicedQty = null, \StructType\DecimalValue $committedOpenAmount = null, \StructType\DecimalValue $committedOpenQty = null, \StructType\DecimalValue $committedReceivedQty = null, \StructType\StringValue $costCode = null, \StructType\StringValue $externalRefNbr = null, \StructType\StringValue $inventoryID = null, \StructType\DateTimeValue $lastModifiedDateTime = null, \StructType\DecimalValue $originalCommittedAmount = null, \StructType\DecimalValue $originalCommittedQty = null, \StructType\StringValue $projectID = null, \StructType\StringValue $projectTaskID = null, \StructType\StringValue $relatedDocument = null, \StructType\DecimalValue $revisedCommittedAmount = null, \StructType\DecimalValue $revisedCommittedQty = null, \StructType\StringValue $type = null, \StructType\StringValue $uOM = null)
    {
        $this
            ->setAccountGroup($accountGroup)
            ->setCommittedCOAmount($committedCOAmount)
            ->setCommittedCOQty($committedCOQty)
            ->setCommittedInvoicedAmount($committedInvoicedAmount)
            ->setCommittedInvoicedQty($committedInvoicedQty)
            ->setCommittedOpenAmount($committedOpenAmount)
            ->setCommittedOpenQty($committedOpenQty)
            ->setCommittedReceivedQty($committedReceivedQty)
            ->setCostCode($costCode)
            ->setExternalRefNbr($externalRefNbr)
            ->setInventoryID($inventoryID)
            ->setLastModifiedDateTime($lastModifiedDateTime)
            ->setOriginalCommittedAmount($originalCommittedAmount)
            ->setOriginalCommittedQty($originalCommittedQty)
            ->setProjectID($projectID)
            ->setProjectTaskID($projectTaskID)
            ->setRelatedDocument($relatedDocument)
            ->setRevisedCommittedAmount($revisedCommittedAmount)
            ->setRevisedCommittedQty($revisedCommittedQty)
            ->setType($type)
            ->setUOM($uOM);
    }
    /**
     * Get AccountGroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getAccountGroup()
    {
        return isset($this->AccountGroup) ? $this->AccountGroup : null;
    }
    /**
     * Set AccountGroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $accountGroup
     * @return \StructType\ExternalCommitment
     */
    public function setAccountGroup(\StructType\StringValue $accountGroup = null)
    {
        if (is_null($accountGroup) || (is_array($accountGroup) && empty($accountGroup))) {
            unset($this->AccountGroup);
        } else {
            $this->AccountGroup = $accountGroup;
        }
        return $this;
    }
    /**
     * Get CommittedCOAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getCommittedCOAmount()
    {
        return isset($this->CommittedCOAmount) ? $this->CommittedCOAmount : null;
    }
    /**
     * Set CommittedCOAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $committedCOAmount
     * @return \StructType\ExternalCommitment
     */
    public function setCommittedCOAmount(\StructType\DecimalValue $committedCOAmount = null)
    {
        if (is_null($committedCOAmount) || (is_array($committedCOAmount) && empty($committedCOAmount))) {
            unset($this->CommittedCOAmount);
        } else {
            $this->CommittedCOAmount = $committedCOAmount;
        }
        return $this;
    }
    /**
     * Get CommittedCOQty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getCommittedCOQty()
    {
        return isset($this->CommittedCOQty) ? $this->CommittedCOQty : null;
    }
    /**
     * Set CommittedCOQty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $committedCOQty
     * @return \StructType\ExternalCommitment
     */
    public function setCommittedCOQty(\StructType\DecimalValue $committedCOQty = null)
    {
        if (is_null($committedCOQty) || (is_array($committedCOQty) && empty($committedCOQty))) {
            unset($this->CommittedCOQty);
        } else {
            $this->CommittedCOQty = $committedCOQty;
        }
        return $this;
    }
    /**
     * Get CommittedInvoicedAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getCommittedInvoicedAmount()
    {
        return isset($this->CommittedInvoicedAmount) ? $this->CommittedInvoicedAmount : null;
    }
    /**
     * Set CommittedInvoicedAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $committedInvoicedAmount
     * @return \StructType\ExternalCommitment
     */
    public function setCommittedInvoicedAmount(\StructType\DecimalValue $committedInvoicedAmount = null)
    {
        if (is_null($committedInvoicedAmount) || (is_array($committedInvoicedAmount) && empty($committedInvoicedAmount))) {
            unset($this->CommittedInvoicedAmount);
        } else {
            $this->CommittedInvoicedAmount = $committedInvoicedAmount;
        }
        return $this;
    }
    /**
     * Get CommittedInvoicedQty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getCommittedInvoicedQty()
    {
        return isset($this->CommittedInvoicedQty) ? $this->CommittedInvoicedQty : null;
    }
    /**
     * Set CommittedInvoicedQty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $committedInvoicedQty
     * @return \StructType\ExternalCommitment
     */
    public function setCommittedInvoicedQty(\StructType\DecimalValue $committedInvoicedQty = null)
    {
        if (is_null($committedInvoicedQty) || (is_array($committedInvoicedQty) && empty($committedInvoicedQty))) {
            unset($this->CommittedInvoicedQty);
        } else {
            $this->CommittedInvoicedQty = $committedInvoicedQty;
        }
        return $this;
    }
    /**
     * Get CommittedOpenAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getCommittedOpenAmount()
    {
        return isset($this->CommittedOpenAmount) ? $this->CommittedOpenAmount : null;
    }
    /**
     * Set CommittedOpenAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $committedOpenAmount
     * @return \StructType\ExternalCommitment
     */
    public function setCommittedOpenAmount(\StructType\DecimalValue $committedOpenAmount = null)
    {
        if (is_null($committedOpenAmount) || (is_array($committedOpenAmount) && empty($committedOpenAmount))) {
            unset($this->CommittedOpenAmount);
        } else {
            $this->CommittedOpenAmount = $committedOpenAmount;
        }
        return $this;
    }
    /**
     * Get CommittedOpenQty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getCommittedOpenQty()
    {
        return isset($this->CommittedOpenQty) ? $this->CommittedOpenQty : null;
    }
    /**
     * Set CommittedOpenQty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $committedOpenQty
     * @return \StructType\ExternalCommitment
     */
    public function setCommittedOpenQty(\StructType\DecimalValue $committedOpenQty = null)
    {
        if (is_null($committedOpenQty) || (is_array($committedOpenQty) && empty($committedOpenQty))) {
            unset($this->CommittedOpenQty);
        } else {
            $this->CommittedOpenQty = $committedOpenQty;
        }
        return $this;
    }
    /**
     * Get CommittedReceivedQty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getCommittedReceivedQty()
    {
        return isset($this->CommittedReceivedQty) ? $this->CommittedReceivedQty : null;
    }
    /**
     * Set CommittedReceivedQty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $committedReceivedQty
     * @return \StructType\ExternalCommitment
     */
    public function setCommittedReceivedQty(\StructType\DecimalValue $committedReceivedQty = null)
    {
        if (is_null($committedReceivedQty) || (is_array($committedReceivedQty) && empty($committedReceivedQty))) {
            unset($this->CommittedReceivedQty);
        } else {
            $this->CommittedReceivedQty = $committedReceivedQty;
        }
        return $this;
    }
    /**
     * Get CostCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getCostCode()
    {
        return isset($this->CostCode) ? $this->CostCode : null;
    }
    /**
     * Set CostCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $costCode
     * @return \StructType\ExternalCommitment
     */
    public function setCostCode(\StructType\StringValue $costCode = null)
    {
        if (is_null($costCode) || (is_array($costCode) && empty($costCode))) {
            unset($this->CostCode);
        } else {
            $this->CostCode = $costCode;
        }
        return $this;
    }
    /**
     * Get ExternalRefNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getExternalRefNbr()
    {
        return isset($this->ExternalRefNbr) ? $this->ExternalRefNbr : null;
    }
    /**
     * Set ExternalRefNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $externalRefNbr
     * @return \StructType\ExternalCommitment
     */
    public function setExternalRefNbr(\StructType\StringValue $externalRefNbr = null)
    {
        if (is_null($externalRefNbr) || (is_array($externalRefNbr) && empty($externalRefNbr))) {
            unset($this->ExternalRefNbr);
        } else {
            $this->ExternalRefNbr = $externalRefNbr;
        }
        return $this;
    }
    /**
     * Get InventoryID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getInventoryID()
    {
        return isset($this->InventoryID) ? $this->InventoryID : null;
    }
    /**
     * Set InventoryID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $inventoryID
     * @return \StructType\ExternalCommitment
     */
    public function setInventoryID(\StructType\StringValue $inventoryID = null)
    {
        if (is_null($inventoryID) || (is_array($inventoryID) && empty($inventoryID))) {
            unset($this->InventoryID);
        } else {
            $this->InventoryID = $inventoryID;
        }
        return $this;
    }
    /**
     * Get LastModifiedDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DateTimeValue|null
     */
    public function getLastModifiedDateTime()
    {
        return isset($this->LastModifiedDateTime) ? $this->LastModifiedDateTime : null;
    }
    /**
     * Set LastModifiedDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DateTimeValue $lastModifiedDateTime
     * @return \StructType\ExternalCommitment
     */
    public function setLastModifiedDateTime(\StructType\DateTimeValue $lastModifiedDateTime = null)
    {
        if (is_null($lastModifiedDateTime) || (is_array($lastModifiedDateTime) && empty($lastModifiedDateTime))) {
            unset($this->LastModifiedDateTime);
        } else {
            $this->LastModifiedDateTime = $lastModifiedDateTime;
        }
        return $this;
    }
    /**
     * Get OriginalCommittedAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getOriginalCommittedAmount()
    {
        return isset($this->OriginalCommittedAmount) ? $this->OriginalCommittedAmount : null;
    }
    /**
     * Set OriginalCommittedAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $originalCommittedAmount
     * @return \StructType\ExternalCommitment
     */
    public function setOriginalCommittedAmount(\StructType\DecimalValue $originalCommittedAmount = null)
    {
        if (is_null($originalCommittedAmount) || (is_array($originalCommittedAmount) && empty($originalCommittedAmount))) {
            unset($this->OriginalCommittedAmount);
        } else {
            $this->OriginalCommittedAmount = $originalCommittedAmount;
        }
        return $this;
    }
    /**
     * Get OriginalCommittedQty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getOriginalCommittedQty()
    {
        return isset($this->OriginalCommittedQty) ? $this->OriginalCommittedQty : null;
    }
    /**
     * Set OriginalCommittedQty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $originalCommittedQty
     * @return \StructType\ExternalCommitment
     */
    public function setOriginalCommittedQty(\StructType\DecimalValue $originalCommittedQty = null)
    {
        if (is_null($originalCommittedQty) || (is_array($originalCommittedQty) && empty($originalCommittedQty))) {
            unset($this->OriginalCommittedQty);
        } else {
            $this->OriginalCommittedQty = $originalCommittedQty;
        }
        return $this;
    }
    /**
     * Get ProjectID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getProjectID()
    {
        return isset($this->ProjectID) ? $this->ProjectID : null;
    }
    /**
     * Set ProjectID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $projectID
     * @return \StructType\ExternalCommitment
     */
    public function setProjectID(\StructType\StringValue $projectID = null)
    {
        if (is_null($projectID) || (is_array($projectID) && empty($projectID))) {
            unset($this->ProjectID);
        } else {
            $this->ProjectID = $projectID;
        }
        return $this;
    }
    /**
     * Get ProjectTaskID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getProjectTaskID()
    {
        return isset($this->ProjectTaskID) ? $this->ProjectTaskID : null;
    }
    /**
     * Set ProjectTaskID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $projectTaskID
     * @return \StructType\ExternalCommitment
     */
    public function setProjectTaskID(\StructType\StringValue $projectTaskID = null)
    {
        if (is_null($projectTaskID) || (is_array($projectTaskID) && empty($projectTaskID))) {
            unset($this->ProjectTaskID);
        } else {
            $this->ProjectTaskID = $projectTaskID;
        }
        return $this;
    }
    /**
     * Get RelatedDocument value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getRelatedDocument()
    {
        return isset($this->RelatedDocument) ? $this->RelatedDocument : null;
    }
    /**
     * Set RelatedDocument value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $relatedDocument
     * @return \StructType\ExternalCommitment
     */
    public function setRelatedDocument(\StructType\StringValue $relatedDocument = null)
    {
        if (is_null($relatedDocument) || (is_array($relatedDocument) && empty($relatedDocument))) {
            unset($this->RelatedDocument);
        } else {
            $this->RelatedDocument = $relatedDocument;
        }
        return $this;
    }
    /**
     * Get RevisedCommittedAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getRevisedCommittedAmount()
    {
        return isset($this->RevisedCommittedAmount) ? $this->RevisedCommittedAmount : null;
    }
    /**
     * Set RevisedCommittedAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $revisedCommittedAmount
     * @return \StructType\ExternalCommitment
     */
    public function setRevisedCommittedAmount(\StructType\DecimalValue $revisedCommittedAmount = null)
    {
        if (is_null($revisedCommittedAmount) || (is_array($revisedCommittedAmount) && empty($revisedCommittedAmount))) {
            unset($this->RevisedCommittedAmount);
        } else {
            $this->RevisedCommittedAmount = $revisedCommittedAmount;
        }
        return $this;
    }
    /**
     * Get RevisedCommittedQty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getRevisedCommittedQty()
    {
        return isset($this->RevisedCommittedQty) ? $this->RevisedCommittedQty : null;
    }
    /**
     * Set RevisedCommittedQty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $revisedCommittedQty
     * @return \StructType\ExternalCommitment
     */
    public function setRevisedCommittedQty(\StructType\DecimalValue $revisedCommittedQty = null)
    {
        if (is_null($revisedCommittedQty) || (is_array($revisedCommittedQty) && empty($revisedCommittedQty))) {
            unset($this->RevisedCommittedQty);
        } else {
            $this->RevisedCommittedQty = $revisedCommittedQty;
        }
        return $this;
    }
    /**
     * Get Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getType()
    {
        return isset($this->Type) ? $this->Type : null;
    }
    /**
     * Set Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $type
     * @return \StructType\ExternalCommitment
     */
    public function setType(\StructType\StringValue $type = null)
    {
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->Type);
        } else {
            $this->Type = $type;
        }
        return $this;
    }
    /**
     * Get UOM value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getUOM()
    {
        return isset($this->UOM) ? $this->UOM : null;
    }
    /**
     * Set UOM value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $uOM
     * @return \StructType\ExternalCommitment
     */
    public function setUOM(\StructType\StringValue $uOM = null)
    {
        if (is_null($uOM) || (is_array($uOM) && empty($uOM))) {
            unset($this->UOM);
        } else {
            $this->UOM = $uOM;
        }
        return $this;
    }
}
