<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExpenseClaimTaxDetail StructType
 * @subpackage Structs
 */
class ExpenseClaimTaxDetail extends Entity
{
    /**
     * The DeductibleTaxRate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $DeductibleTaxRate;
    /**
     * The ExpenseAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $ExpenseAmount;
    /**
     * The IncludeinVATExemptTotal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $IncludeinVATExemptTotal;
    /**
     * The PendingVAT
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $PendingVAT;
    /**
     * The ReverseVAT
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $ReverseVAT;
    /**
     * The StatisticalVAT
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BooleanValue
     */
    public $StatisticalVAT;
    /**
     * The TaxableAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $TaxableAmount;
    /**
     * The TaxAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $TaxAmount;
    /**
     * The TaxID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $TaxID;
    /**
     * The TaxRate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $TaxRate;
    /**
     * The TaxType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $TaxType;
    /**
     * Constructor method for ExpenseClaimTaxDetail
     * @uses ExpenseClaimTaxDetail::setDeductibleTaxRate()
     * @uses ExpenseClaimTaxDetail::setExpenseAmount()
     * @uses ExpenseClaimTaxDetail::setIncludeinVATExemptTotal()
     * @uses ExpenseClaimTaxDetail::setPendingVAT()
     * @uses ExpenseClaimTaxDetail::setReverseVAT()
     * @uses ExpenseClaimTaxDetail::setStatisticalVAT()
     * @uses ExpenseClaimTaxDetail::setTaxableAmount()
     * @uses ExpenseClaimTaxDetail::setTaxAmount()
     * @uses ExpenseClaimTaxDetail::setTaxID()
     * @uses ExpenseClaimTaxDetail::setTaxRate()
     * @uses ExpenseClaimTaxDetail::setTaxType()
     * @param \StructType\DecimalValue $deductibleTaxRate
     * @param \StructType\DecimalValue $expenseAmount
     * @param \StructType\BooleanValue $includeinVATExemptTotal
     * @param \StructType\BooleanValue $pendingVAT
     * @param \StructType\BooleanValue $reverseVAT
     * @param \StructType\BooleanValue $statisticalVAT
     * @param \StructType\DecimalValue $taxableAmount
     * @param \StructType\DecimalValue $taxAmount
     * @param \StructType\StringValue $taxID
     * @param \StructType\DecimalValue $taxRate
     * @param \StructType\StringValue $taxType
     */
    public function __construct(\StructType\DecimalValue $deductibleTaxRate = null, \StructType\DecimalValue $expenseAmount = null, \StructType\BooleanValue $includeinVATExemptTotal = null, \StructType\BooleanValue $pendingVAT = null, \StructType\BooleanValue $reverseVAT = null, \StructType\BooleanValue $statisticalVAT = null, \StructType\DecimalValue $taxableAmount = null, \StructType\DecimalValue $taxAmount = null, \StructType\StringValue $taxID = null, \StructType\DecimalValue $taxRate = null, \StructType\StringValue $taxType = null)
    {
        $this
            ->setDeductibleTaxRate($deductibleTaxRate)
            ->setExpenseAmount($expenseAmount)
            ->setIncludeinVATExemptTotal($includeinVATExemptTotal)
            ->setPendingVAT($pendingVAT)
            ->setReverseVAT($reverseVAT)
            ->setStatisticalVAT($statisticalVAT)
            ->setTaxableAmount($taxableAmount)
            ->setTaxAmount($taxAmount)
            ->setTaxID($taxID)
            ->setTaxRate($taxRate)
            ->setTaxType($taxType);
    }
    /**
     * Get DeductibleTaxRate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getDeductibleTaxRate()
    {
        return isset($this->DeductibleTaxRate) ? $this->DeductibleTaxRate : null;
    }
    /**
     * Set DeductibleTaxRate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $deductibleTaxRate
     * @return \StructType\ExpenseClaimTaxDetail
     */
    public function setDeductibleTaxRate(\StructType\DecimalValue $deductibleTaxRate = null)
    {
        if (is_null($deductibleTaxRate) || (is_array($deductibleTaxRate) && empty($deductibleTaxRate))) {
            unset($this->DeductibleTaxRate);
        } else {
            $this->DeductibleTaxRate = $deductibleTaxRate;
        }
        return $this;
    }
    /**
     * Get ExpenseAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getExpenseAmount()
    {
        return isset($this->ExpenseAmount) ? $this->ExpenseAmount : null;
    }
    /**
     * Set ExpenseAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $expenseAmount
     * @return \StructType\ExpenseClaimTaxDetail
     */
    public function setExpenseAmount(\StructType\DecimalValue $expenseAmount = null)
    {
        if (is_null($expenseAmount) || (is_array($expenseAmount) && empty($expenseAmount))) {
            unset($this->ExpenseAmount);
        } else {
            $this->ExpenseAmount = $expenseAmount;
        }
        return $this;
    }
    /**
     * Get IncludeinVATExemptTotal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getIncludeinVATExemptTotal()
    {
        return isset($this->IncludeinVATExemptTotal) ? $this->IncludeinVATExemptTotal : null;
    }
    /**
     * Set IncludeinVATExemptTotal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $includeinVATExemptTotal
     * @return \StructType\ExpenseClaimTaxDetail
     */
    public function setIncludeinVATExemptTotal(\StructType\BooleanValue $includeinVATExemptTotal = null)
    {
        if (is_null($includeinVATExemptTotal) || (is_array($includeinVATExemptTotal) && empty($includeinVATExemptTotal))) {
            unset($this->IncludeinVATExemptTotal);
        } else {
            $this->IncludeinVATExemptTotal = $includeinVATExemptTotal;
        }
        return $this;
    }
    /**
     * Get PendingVAT value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getPendingVAT()
    {
        return isset($this->PendingVAT) ? $this->PendingVAT : null;
    }
    /**
     * Set PendingVAT value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $pendingVAT
     * @return \StructType\ExpenseClaimTaxDetail
     */
    public function setPendingVAT(\StructType\BooleanValue $pendingVAT = null)
    {
        if (is_null($pendingVAT) || (is_array($pendingVAT) && empty($pendingVAT))) {
            unset($this->PendingVAT);
        } else {
            $this->PendingVAT = $pendingVAT;
        }
        return $this;
    }
    /**
     * Get ReverseVAT value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getReverseVAT()
    {
        return isset($this->ReverseVAT) ? $this->ReverseVAT : null;
    }
    /**
     * Set ReverseVAT value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $reverseVAT
     * @return \StructType\ExpenseClaimTaxDetail
     */
    public function setReverseVAT(\StructType\BooleanValue $reverseVAT = null)
    {
        if (is_null($reverseVAT) || (is_array($reverseVAT) && empty($reverseVAT))) {
            unset($this->ReverseVAT);
        } else {
            $this->ReverseVAT = $reverseVAT;
        }
        return $this;
    }
    /**
     * Get StatisticalVAT value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BooleanValue|null
     */
    public function getStatisticalVAT()
    {
        return isset($this->StatisticalVAT) ? $this->StatisticalVAT : null;
    }
    /**
     * Set StatisticalVAT value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BooleanValue $statisticalVAT
     * @return \StructType\ExpenseClaimTaxDetail
     */
    public function setStatisticalVAT(\StructType\BooleanValue $statisticalVAT = null)
    {
        if (is_null($statisticalVAT) || (is_array($statisticalVAT) && empty($statisticalVAT))) {
            unset($this->StatisticalVAT);
        } else {
            $this->StatisticalVAT = $statisticalVAT;
        }
        return $this;
    }
    /**
     * Get TaxableAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getTaxableAmount()
    {
        return isset($this->TaxableAmount) ? $this->TaxableAmount : null;
    }
    /**
     * Set TaxableAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $taxableAmount
     * @return \StructType\ExpenseClaimTaxDetail
     */
    public function setTaxableAmount(\StructType\DecimalValue $taxableAmount = null)
    {
        if (is_null($taxableAmount) || (is_array($taxableAmount) && empty($taxableAmount))) {
            unset($this->TaxableAmount);
        } else {
            $this->TaxableAmount = $taxableAmount;
        }
        return $this;
    }
    /**
     * Get TaxAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getTaxAmount()
    {
        return isset($this->TaxAmount) ? $this->TaxAmount : null;
    }
    /**
     * Set TaxAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $taxAmount
     * @return \StructType\ExpenseClaimTaxDetail
     */
    public function setTaxAmount(\StructType\DecimalValue $taxAmount = null)
    {
        if (is_null($taxAmount) || (is_array($taxAmount) && empty($taxAmount))) {
            unset($this->TaxAmount);
        } else {
            $this->TaxAmount = $taxAmount;
        }
        return $this;
    }
    /**
     * Get TaxID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getTaxID()
    {
        return isset($this->TaxID) ? $this->TaxID : null;
    }
    /**
     * Set TaxID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $taxID
     * @return \StructType\ExpenseClaimTaxDetail
     */
    public function setTaxID(\StructType\StringValue $taxID = null)
    {
        if (is_null($taxID) || (is_array($taxID) && empty($taxID))) {
            unset($this->TaxID);
        } else {
            $this->TaxID = $taxID;
        }
        return $this;
    }
    /**
     * Get TaxRate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getTaxRate()
    {
        return isset($this->TaxRate) ? $this->TaxRate : null;
    }
    /**
     * Set TaxRate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $taxRate
     * @return \StructType\ExpenseClaimTaxDetail
     */
    public function setTaxRate(\StructType\DecimalValue $taxRate = null)
    {
        if (is_null($taxRate) || (is_array($taxRate) && empty($taxRate))) {
            unset($this->TaxRate);
        } else {
            $this->TaxRate = $taxRate;
        }
        return $this;
    }
    /**
     * Get TaxType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getTaxType()
    {
        return isset($this->TaxType) ? $this->TaxType : null;
    }
    /**
     * Set TaxType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $taxType
     * @return \StructType\ExpenseClaimTaxDetail
     */
    public function setTaxType(\StructType\StringValue $taxType = null)
    {
        if (is_null($taxType) || (is_array($taxType) && empty($taxType))) {
            unset($this->TaxType);
        } else {
            $this->TaxType = $taxType;
        }
        return $this;
    }
}
