<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocumentsToApply StructType
 * @subpackage Structs
 */
class DocumentsToApply extends AbstractStructBase
{
    /**
     * The PaymentDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PaymentDetail[]
     */
    public $PaymentDetail;
    /**
     * Constructor method for DocumentsToApply
     * @uses DocumentsToApply::setPaymentDetail()
     * @param \StructType\PaymentDetail[] $paymentDetail
     */
    public function __construct(array $paymentDetail = array())
    {
        $this
            ->setPaymentDetail($paymentDetail);
    }
    /**
     * Get PaymentDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PaymentDetail[]|null
     */
    public function getPaymentDetail()
    {
        return isset($this->PaymentDetail) ? $this->PaymentDetail : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPaymentDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentDetailForArrayConstraintsFromSetPaymentDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $documentsToApplyPaymentDetailItem) {
            // validation for constraint: itemType
            if (!$documentsToApplyPaymentDetailItem instanceof \StructType\PaymentDetail) {
                $invalidValues[] = is_object($documentsToApplyPaymentDetailItem) ? get_class($documentsToApplyPaymentDetailItem) : sprintf('%s(%s)', gettype($documentsToApplyPaymentDetailItem), var_export($documentsToApplyPaymentDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaymentDetail property can only contain items of type \StructType\PaymentDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaymentDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentDetail[] $paymentDetail
     * @return \StructType\DocumentsToApply
     */
    public function setPaymentDetail(array $paymentDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentDetailArrayErrorMessage = self::validatePaymentDetailForArrayConstraintsFromSetPaymentDetail($paymentDetail))) {
            throw new \InvalidArgumentException($paymentDetailArrayErrorMessage, __LINE__);
        }
        if (is_null($paymentDetail) || (is_array($paymentDetail) && empty($paymentDetail))) {
            unset($this->PaymentDetail);
        } else {
            $this->PaymentDetail = $paymentDetail;
        }
        return $this;
    }
    /**
     * Add item to PaymentDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentDetail $item
     * @return \StructType\DocumentsToApply
     */
    public function addToPaymentDetail(\StructType\PaymentDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PaymentDetail) {
            throw new \InvalidArgumentException(sprintf('The PaymentDetail property can only contain items of type \StructType\PaymentDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PaymentDetail[] = $item;
        return $this;
    }
}
