<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DiscountCode StructType
 * @subpackage Structs
 */
class DiscountCode extends Entity
{
    /**
     * The ApplicableTo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ApplicableTo;
    /**
     * The CreatedDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DateTimeValue
     */
    public $CreatedDateTime;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Description;
    /**
     * The DiscountCodeID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $DiscountCodeID;
    /**
     * The DiscountType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $DiscountType;
    /**
     * The LastModifiedDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DateTimeValue
     */
    public $LastModifiedDateTime;
    /**
     * Constructor method for DiscountCode
     * @uses DiscountCode::setApplicableTo()
     * @uses DiscountCode::setCreatedDateTime()
     * @uses DiscountCode::setDescription()
     * @uses DiscountCode::setDiscountCodeID()
     * @uses DiscountCode::setDiscountType()
     * @uses DiscountCode::setLastModifiedDateTime()
     * @param \StructType\StringValue $applicableTo
     * @param \StructType\DateTimeValue $createdDateTime
     * @param \StructType\StringValue $description
     * @param \StructType\StringValue $discountCodeID
     * @param \StructType\StringValue $discountType
     * @param \StructType\DateTimeValue $lastModifiedDateTime
     */
    public function __construct(\StructType\StringValue $applicableTo = null, \StructType\DateTimeValue $createdDateTime = null, \StructType\StringValue $description = null, \StructType\StringValue $discountCodeID = null, \StructType\StringValue $discountType = null, \StructType\DateTimeValue $lastModifiedDateTime = null)
    {
        $this
            ->setApplicableTo($applicableTo)
            ->setCreatedDateTime($createdDateTime)
            ->setDescription($description)
            ->setDiscountCodeID($discountCodeID)
            ->setDiscountType($discountType)
            ->setLastModifiedDateTime($lastModifiedDateTime);
    }
    /**
     * Get ApplicableTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getApplicableTo()
    {
        return isset($this->ApplicableTo) ? $this->ApplicableTo : null;
    }
    /**
     * Set ApplicableTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $applicableTo
     * @return \StructType\DiscountCode
     */
    public function setApplicableTo(\StructType\StringValue $applicableTo = null)
    {
        if (is_null($applicableTo) || (is_array($applicableTo) && empty($applicableTo))) {
            unset($this->ApplicableTo);
        } else {
            $this->ApplicableTo = $applicableTo;
        }
        return $this;
    }
    /**
     * Get CreatedDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DateTimeValue|null
     */
    public function getCreatedDateTime()
    {
        return isset($this->CreatedDateTime) ? $this->CreatedDateTime : null;
    }
    /**
     * Set CreatedDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DateTimeValue $createdDateTime
     * @return \StructType\DiscountCode
     */
    public function setCreatedDateTime(\StructType\DateTimeValue $createdDateTime = null)
    {
        if (is_null($createdDateTime) || (is_array($createdDateTime) && empty($createdDateTime))) {
            unset($this->CreatedDateTime);
        } else {
            $this->CreatedDateTime = $createdDateTime;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $description
     * @return \StructType\DiscountCode
     */
    public function setDescription(\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get DiscountCodeID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getDiscountCodeID()
    {
        return isset($this->DiscountCodeID) ? $this->DiscountCodeID : null;
    }
    /**
     * Set DiscountCodeID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $discountCodeID
     * @return \StructType\DiscountCode
     */
    public function setDiscountCodeID(\StructType\StringValue $discountCodeID = null)
    {
        if (is_null($discountCodeID) || (is_array($discountCodeID) && empty($discountCodeID))) {
            unset($this->DiscountCodeID);
        } else {
            $this->DiscountCodeID = $discountCodeID;
        }
        return $this;
    }
    /**
     * Get DiscountType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getDiscountType()
    {
        return isset($this->DiscountType) ? $this->DiscountType : null;
    }
    /**
     * Set DiscountType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $discountType
     * @return \StructType\DiscountCode
     */
    public function setDiscountType(\StructType\StringValue $discountType = null)
    {
        if (is_null($discountType) || (is_array($discountType) && empty($discountType))) {
            unset($this->DiscountType);
        } else {
            $this->DiscountType = $discountType;
        }
        return $this;
    }
    /**
     * Get LastModifiedDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DateTimeValue|null
     */
    public function getLastModifiedDateTime()
    {
        return isset($this->LastModifiedDateTime) ? $this->LastModifiedDateTime : null;
    }
    /**
     * Set LastModifiedDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DateTimeValue $lastModifiedDateTime
     * @return \StructType\DiscountCode
     */
    public function setLastModifiedDateTime(\StructType\DateTimeValue $lastModifiedDateTime = null)
    {
        if (is_null($lastModifiedDateTime) || (is_array($lastModifiedDateTime) && empty($lastModifiedDateTime))) {
            unset($this->LastModifiedDateTime);
        } else {
            $this->LastModifiedDateTime = $lastModifiedDateTime;
        }
        return $this;
    }
}
