<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Cases StructType
 * @subpackage Structs
 */
class Cases extends AbstractStructBase
{
    /**
     * The CaseDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CaseDetail[]
     */
    public $CaseDetail;
    /**
     * The BusinessAccountCaseDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BusinessAccountCaseDetail[]
     */
    public $BusinessAccountCaseDetail;
    /**
     * Constructor method for Cases
     * @uses Cases::setCaseDetail()
     * @uses Cases::setBusinessAccountCaseDetail()
     * @param \StructType\CaseDetail[] $caseDetail
     * @param \StructType\BusinessAccountCaseDetail[] $businessAccountCaseDetail
     */
    public function __construct(array $caseDetail = array(), array $businessAccountCaseDetail = array())
    {
        $this
            ->setCaseDetail($caseDetail)
            ->setBusinessAccountCaseDetail($businessAccountCaseDetail);
    }
    /**
     * Get CaseDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CaseDetail[]|null
     */
    public function getCaseDetail()
    {
        return isset($this->CaseDetail) ? $this->CaseDetail : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCaseDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCaseDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCaseDetailForArrayConstraintsFromSetCaseDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $casesCaseDetailItem) {
            // validation for constraint: itemType
            if (!$casesCaseDetailItem instanceof \StructType\CaseDetail) {
                $invalidValues[] = is_object($casesCaseDetailItem) ? get_class($casesCaseDetailItem) : sprintf('%s(%s)', gettype($casesCaseDetailItem), var_export($casesCaseDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CaseDetail property can only contain items of type \StructType\CaseDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CaseDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CaseDetail[] $caseDetail
     * @return \StructType\Cases
     */
    public function setCaseDetail(array $caseDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($caseDetailArrayErrorMessage = self::validateCaseDetailForArrayConstraintsFromSetCaseDetail($caseDetail))) {
            throw new \InvalidArgumentException($caseDetailArrayErrorMessage, __LINE__);
        }
        if (is_null($caseDetail) || (is_array($caseDetail) && empty($caseDetail))) {
            unset($this->CaseDetail);
        } else {
            $this->CaseDetail = $caseDetail;
        }
        return $this;
    }
    /**
     * Add item to CaseDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\CaseDetail $item
     * @return \StructType\Cases
     */
    public function addToCaseDetail(\StructType\CaseDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CaseDetail) {
            throw new \InvalidArgumentException(sprintf('The CaseDetail property can only contain items of type \StructType\CaseDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CaseDetail[] = $item;
        return $this;
    }
    /**
     * Get BusinessAccountCaseDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BusinessAccountCaseDetail[]|null
     */
    public function getBusinessAccountCaseDetail()
    {
        return isset($this->BusinessAccountCaseDetail) ? $this->BusinessAccountCaseDetail : null;
    }
    /**
     * This method is responsible for validating the values passed to the setBusinessAccountCaseDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBusinessAccountCaseDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBusinessAccountCaseDetailForArrayConstraintsFromSetBusinessAccountCaseDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $casesBusinessAccountCaseDetailItem) {
            // validation for constraint: itemType
            if (!$casesBusinessAccountCaseDetailItem instanceof \StructType\BusinessAccountCaseDetail) {
                $invalidValues[] = is_object($casesBusinessAccountCaseDetailItem) ? get_class($casesBusinessAccountCaseDetailItem) : sprintf('%s(%s)', gettype($casesBusinessAccountCaseDetailItem), var_export($casesBusinessAccountCaseDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BusinessAccountCaseDetail property can only contain items of type \StructType\BusinessAccountCaseDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BusinessAccountCaseDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\BusinessAccountCaseDetail[] $businessAccountCaseDetail
     * @return \StructType\Cases
     */
    public function setBusinessAccountCaseDetail(array $businessAccountCaseDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($businessAccountCaseDetailArrayErrorMessage = self::validateBusinessAccountCaseDetailForArrayConstraintsFromSetBusinessAccountCaseDetail($businessAccountCaseDetail))) {
            throw new \InvalidArgumentException($businessAccountCaseDetailArrayErrorMessage, __LINE__);
        }
        if (is_null($businessAccountCaseDetail) || (is_array($businessAccountCaseDetail) && empty($businessAccountCaseDetail))) {
            unset($this->BusinessAccountCaseDetail);
        } else {
            $this->BusinessAccountCaseDetail = $businessAccountCaseDetail;
        }
        return $this;
    }
    /**
     * Add item to BusinessAccountCaseDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\BusinessAccountCaseDetail $item
     * @return \StructType\Cases
     */
    public function addToBusinessAccountCaseDetail(\StructType\BusinessAccountCaseDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BusinessAccountCaseDetail) {
            throw new \InvalidArgumentException(sprintf('The BusinessAccountCaseDetail property can only contain items of type \StructType\BusinessAccountCaseDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->BusinessAccountCaseDetail[] = $item;
        return $this;
    }
}
