<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BillTaxDetail StructType
 * @subpackage Structs
 */
class BillTaxDetail extends Entity
{
    /**
     * The TaxableAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $TaxableAmount;
    /**
     * The TaxAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $TaxAmount;
    /**
     * The TaxID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $TaxID;
    /**
     * The TaxRate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $TaxRate;
    /**
     * Constructor method for BillTaxDetail
     * @uses BillTaxDetail::setTaxableAmount()
     * @uses BillTaxDetail::setTaxAmount()
     * @uses BillTaxDetail::setTaxID()
     * @uses BillTaxDetail::setTaxRate()
     * @param \StructType\DecimalValue $taxableAmount
     * @param \StructType\DecimalValue $taxAmount
     * @param \StructType\StringValue $taxID
     * @param \StructType\DecimalValue $taxRate
     */
    public function __construct(\StructType\DecimalValue $taxableAmount = null, \StructType\DecimalValue $taxAmount = null, \StructType\StringValue $taxID = null, \StructType\DecimalValue $taxRate = null)
    {
        $this
            ->setTaxableAmount($taxableAmount)
            ->setTaxAmount($taxAmount)
            ->setTaxID($taxID)
            ->setTaxRate($taxRate);
    }
    /**
     * Get TaxableAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getTaxableAmount()
    {
        return isset($this->TaxableAmount) ? $this->TaxableAmount : null;
    }
    /**
     * Set TaxableAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $taxableAmount
     * @return \StructType\BillTaxDetail
     */
    public function setTaxableAmount(\StructType\DecimalValue $taxableAmount = null)
    {
        if (is_null($taxableAmount) || (is_array($taxableAmount) && empty($taxableAmount))) {
            unset($this->TaxableAmount);
        } else {
            $this->TaxableAmount = $taxableAmount;
        }
        return $this;
    }
    /**
     * Get TaxAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getTaxAmount()
    {
        return isset($this->TaxAmount) ? $this->TaxAmount : null;
    }
    /**
     * Set TaxAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $taxAmount
     * @return \StructType\BillTaxDetail
     */
    public function setTaxAmount(\StructType\DecimalValue $taxAmount = null)
    {
        if (is_null($taxAmount) || (is_array($taxAmount) && empty($taxAmount))) {
            unset($this->TaxAmount);
        } else {
            $this->TaxAmount = $taxAmount;
        }
        return $this;
    }
    /**
     * Get TaxID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getTaxID()
    {
        return isset($this->TaxID) ? $this->TaxID : null;
    }
    /**
     * Set TaxID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $taxID
     * @return \StructType\BillTaxDetail
     */
    public function setTaxID(\StructType\StringValue $taxID = null)
    {
        if (is_null($taxID) || (is_array($taxID) && empty($taxID))) {
            unset($this->TaxID);
        } else {
            $this->TaxID = $taxID;
        }
        return $this;
    }
    /**
     * Get TaxRate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getTaxRate()
    {
        return isset($this->TaxRate) ? $this->TaxRate : null;
    }
    /**
     * Set TaxRate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $taxRate
     * @return \StructType\BillTaxDetail
     */
    public function setTaxRate(\StructType\DecimalValue $taxRate = null)
    {
        if (is_null($taxRate) || (is_array($taxRate) && empty($taxRate))) {
            unset($this->TaxRate);
        } else {
            $this->TaxRate = $taxRate;
        }
        return $this;
    }
}
