<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BillApplicationDetail StructType
 * @subpackage Structs
 */
class BillApplicationDetail extends Entity
{
    /**
     * The AmountPaid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $AmountPaid;
    /**
     * The Balance
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DecimalValue
     */
    public $Balance;
    /**
     * The DocType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $DocType;
    /**
     * The ReferenceNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $ReferenceNbr;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\StringValue
     */
    public $Status;
    /**
     * Constructor method for BillApplicationDetail
     * @uses BillApplicationDetail::setAmountPaid()
     * @uses BillApplicationDetail::setBalance()
     * @uses BillApplicationDetail::setDocType()
     * @uses BillApplicationDetail::setReferenceNbr()
     * @uses BillApplicationDetail::setStatus()
     * @param \StructType\DecimalValue $amountPaid
     * @param \StructType\DecimalValue $balance
     * @param \StructType\StringValue $docType
     * @param \StructType\StringValue $referenceNbr
     * @param \StructType\StringValue $status
     */
    public function __construct(\StructType\DecimalValue $amountPaid = null, \StructType\DecimalValue $balance = null, \StructType\StringValue $docType = null, \StructType\StringValue $referenceNbr = null, \StructType\StringValue $status = null)
    {
        $this
            ->setAmountPaid($amountPaid)
            ->setBalance($balance)
            ->setDocType($docType)
            ->setReferenceNbr($referenceNbr)
            ->setStatus($status);
    }
    /**
     * Get AmountPaid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getAmountPaid()
    {
        return isset($this->AmountPaid) ? $this->AmountPaid : null;
    }
    /**
     * Set AmountPaid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $amountPaid
     * @return \StructType\BillApplicationDetail
     */
    public function setAmountPaid(\StructType\DecimalValue $amountPaid = null)
    {
        if (is_null($amountPaid) || (is_array($amountPaid) && empty($amountPaid))) {
            unset($this->AmountPaid);
        } else {
            $this->AmountPaid = $amountPaid;
        }
        return $this;
    }
    /**
     * Get Balance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DecimalValue|null
     */
    public function getBalance()
    {
        return isset($this->Balance) ? $this->Balance : null;
    }
    /**
     * Set Balance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DecimalValue $balance
     * @return \StructType\BillApplicationDetail
     */
    public function setBalance(\StructType\DecimalValue $balance = null)
    {
        if (is_null($balance) || (is_array($balance) && empty($balance))) {
            unset($this->Balance);
        } else {
            $this->Balance = $balance;
        }
        return $this;
    }
    /**
     * Get DocType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getDocType()
    {
        return isset($this->DocType) ? $this->DocType : null;
    }
    /**
     * Set DocType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $docType
     * @return \StructType\BillApplicationDetail
     */
    public function setDocType(\StructType\StringValue $docType = null)
    {
        if (is_null($docType) || (is_array($docType) && empty($docType))) {
            unset($this->DocType);
        } else {
            $this->DocType = $docType;
        }
        return $this;
    }
    /**
     * Get ReferenceNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getReferenceNbr()
    {
        return isset($this->ReferenceNbr) ? $this->ReferenceNbr : null;
    }
    /**
     * Set ReferenceNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $referenceNbr
     * @return \StructType\BillApplicationDetail
     */
    public function setReferenceNbr(\StructType\StringValue $referenceNbr = null)
    {
        if (is_null($referenceNbr) || (is_array($referenceNbr) && empty($referenceNbr))) {
            unset($this->ReferenceNbr);
        } else {
            $this->ReferenceNbr = $referenceNbr;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\StringValue|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\StringValue $status
     * @return \StructType\BillApplicationDetail
     */
    public function setStatus(\StructType\StringValue $status = null)
    {
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
}
