<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ApplicationsInvoice StructType
 * @subpackage Structs
 */
class ApplicationsInvoice extends AbstractStructBase
{
    /**
     * The SalesInvoiceApplicationInvoice
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SalesInvoiceApplicationInvoice[]
     */
    public $SalesInvoiceApplicationInvoice;
    /**
     * Constructor method for ApplicationsInvoice
     * @uses ApplicationsInvoice::setSalesInvoiceApplicationInvoice()
     * @param \StructType\SalesInvoiceApplicationInvoice[] $salesInvoiceApplicationInvoice
     */
    public function __construct(array $salesInvoiceApplicationInvoice = array())
    {
        $this
            ->setSalesInvoiceApplicationInvoice($salesInvoiceApplicationInvoice);
    }
    /**
     * Get SalesInvoiceApplicationInvoice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SalesInvoiceApplicationInvoice[]|null
     */
    public function getSalesInvoiceApplicationInvoice()
    {
        return isset($this->SalesInvoiceApplicationInvoice) ? $this->SalesInvoiceApplicationInvoice : null;
    }
    /**
     * This method is responsible for validating the values passed to the setSalesInvoiceApplicationInvoice method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSalesInvoiceApplicationInvoice method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSalesInvoiceApplicationInvoiceForArrayConstraintsFromSetSalesInvoiceApplicationInvoice(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $applicationsInvoiceSalesInvoiceApplicationInvoiceItem) {
            // validation for constraint: itemType
            if (!$applicationsInvoiceSalesInvoiceApplicationInvoiceItem instanceof \StructType\SalesInvoiceApplicationInvoice) {
                $invalidValues[] = is_object($applicationsInvoiceSalesInvoiceApplicationInvoiceItem) ? get_class($applicationsInvoiceSalesInvoiceApplicationInvoiceItem) : sprintf('%s(%s)', gettype($applicationsInvoiceSalesInvoiceApplicationInvoiceItem), var_export($applicationsInvoiceSalesInvoiceApplicationInvoiceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SalesInvoiceApplicationInvoice property can only contain items of type \StructType\SalesInvoiceApplicationInvoice, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SalesInvoiceApplicationInvoice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\SalesInvoiceApplicationInvoice[] $salesInvoiceApplicationInvoice
     * @return \StructType\ApplicationsInvoice
     */
    public function setSalesInvoiceApplicationInvoice(array $salesInvoiceApplicationInvoice = array())
    {
        // validation for constraint: array
        if ('' !== ($salesInvoiceApplicationInvoiceArrayErrorMessage = self::validateSalesInvoiceApplicationInvoiceForArrayConstraintsFromSetSalesInvoiceApplicationInvoice($salesInvoiceApplicationInvoice))) {
            throw new \InvalidArgumentException($salesInvoiceApplicationInvoiceArrayErrorMessage, __LINE__);
        }
        if (is_null($salesInvoiceApplicationInvoice) || (is_array($salesInvoiceApplicationInvoice) && empty($salesInvoiceApplicationInvoice))) {
            unset($this->SalesInvoiceApplicationInvoice);
        } else {
            $this->SalesInvoiceApplicationInvoice = $salesInvoiceApplicationInvoice;
        }
        return $this;
    }
    /**
     * Add item to SalesInvoiceApplicationInvoice value
     * @throws \InvalidArgumentException
     * @param \StructType\SalesInvoiceApplicationInvoice $item
     * @return \StructType\ApplicationsInvoice
     */
    public function addToSalesInvoiceApplicationInvoice(\StructType\SalesInvoiceApplicationInvoice $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SalesInvoiceApplicationInvoice) {
            throw new \InvalidArgumentException(sprintf('The SalesInvoiceApplicationInvoice property can only contain items of type \StructType\SalesInvoiceApplicationInvoice, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SalesInvoiceApplicationInvoice[] = $item;
        return $this;
    }
}
