<?php

namespace Ups_void\UPSvoidStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceAccessToken UPSvoidStruct
 * @package Ups_void
 * @subpackage Structs
 */
class Ups_voidServiceAccessToken extends AbstractStructBase
{
    /**
     * The AccessLicenseNumber
     * @var string
     */
    public $AccessLicenseNumber;
    /**
     * Constructor method for ServiceAccessToken
     * @uses Ups_voidServiceAccessToken::setAccessLicenseNumber()
     * @param string $accessLicenseNumber
     */
    public function __construct($accessLicenseNumber = null)
    {
        $this
            ->setAccessLicenseNumber($accessLicenseNumber);
    }
    /**
     * Get AccessLicenseNumber value
     * @return string|null
     */
    public function getAccessLicenseNumber()
    {
        return $this->AccessLicenseNumber;
    }
    /**
     * Set AccessLicenseNumber value
     * @param string $accessLicenseNumber
     * @return \Ups_void\UPSvoidStruct\Ups_voidServiceAccessToken
     */
    public function setAccessLicenseNumber($accessLicenseNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accessLicenseNumber) && !is_string($accessLicenseNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessLicenseNumber, true), gettype($accessLicenseNumber)), __LINE__);
        }
        $this->AccessLicenseNumber = $accessLicenseNumber;
        return $this;
    }
}
