<?php

namespace Ups_void\UPSvoidStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResponseType UPSvoidStruct
 * @package Ups_void
 * @subpackage Structs
 */
class Ups_voidResponseType extends AbstractStructBase
{
    /**
     * The ResponseStatus
     * @var \Ups_void\UPSvoidStruct\Ups_voidCodeDescriptionType
     */
    public $ResponseStatus;
    /**
     * The Alert
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Ups_void\UPSvoidStruct\Ups_voidCodeDescriptionType[]
     */
    public $Alert;
    /**
     * The AlertDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Ups_void\UPSvoidStruct\Ups_voidDetailType[]
     */
    public $AlertDetail;
    /**
     * The TransactionReference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_void\UPSvoidStruct\Ups_voidTransactionReferenceType
     */
    public $TransactionReference;
    /**
     * Constructor method for ResponseType
     * @uses Ups_voidResponseType::setResponseStatus()
     * @uses Ups_voidResponseType::setAlert()
     * @uses Ups_voidResponseType::setAlertDetail()
     * @uses Ups_voidResponseType::setTransactionReference()
     * @param \Ups_void\UPSvoidStruct\Ups_voidCodeDescriptionType $responseStatus
     * @param \Ups_void\UPSvoidStruct\Ups_voidCodeDescriptionType[] $alert
     * @param \Ups_void\UPSvoidStruct\Ups_voidDetailType[] $alertDetail
     * @param \Ups_void\UPSvoidStruct\Ups_voidTransactionReferenceType $transactionReference
     */
    public function __construct(\Ups_void\UPSvoidStruct\Ups_voidCodeDescriptionType $responseStatus = null, array $alert = array(), array $alertDetail = array(), \Ups_void\UPSvoidStruct\Ups_voidTransactionReferenceType $transactionReference = null)
    {
        $this
            ->setResponseStatus($responseStatus)
            ->setAlert($alert)
            ->setAlertDetail($alertDetail)
            ->setTransactionReference($transactionReference);
    }
    /**
     * Get ResponseStatus value
     * @return \Ups_void\UPSvoidStruct\Ups_voidCodeDescriptionType|null
     */
    public function getResponseStatus()
    {
        return $this->ResponseStatus;
    }
    /**
     * Set ResponseStatus value
     * @param \Ups_void\UPSvoidStruct\Ups_voidCodeDescriptionType $responseStatus
     * @return \Ups_void\UPSvoidStruct\Ups_voidResponseType
     */
    public function setResponseStatus(\Ups_void\UPSvoidStruct\Ups_voidCodeDescriptionType $responseStatus = null)
    {
        $this->ResponseStatus = $responseStatus;
        return $this;
    }
    /**
     * Get Alert value
     * @return \Ups_void\UPSvoidStruct\Ups_voidCodeDescriptionType[]|null
     */
    public function getAlert()
    {
        return $this->Alert;
    }
    /**
     * This method is responsible for validating the values passed to the setAlert method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAlert method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAlertForArrayConstraintsFromSetAlert(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $responseTypeAlertItem) {
            // validation for constraint: itemType
            if (!$responseTypeAlertItem instanceof \Ups_void\UPSvoidStruct\Ups_voidCodeDescriptionType) {
                $invalidValues[] = is_object($responseTypeAlertItem) ? get_class($responseTypeAlertItem) : sprintf('%s(%s)', gettype($responseTypeAlertItem), var_export($responseTypeAlertItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Alert property can only contain items of type \Ups_void\UPSvoidStruct\Ups_voidCodeDescriptionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Alert value
     * @throws \InvalidArgumentException
     * @param \Ups_void\UPSvoidStruct\Ups_voidCodeDescriptionType[] $alert
     * @return \Ups_void\UPSvoidStruct\Ups_voidResponseType
     */
    public function setAlert(array $alert = array())
    {
        // validation for constraint: array
        if ('' !== ($alertArrayErrorMessage = self::validateAlertForArrayConstraintsFromSetAlert($alert))) {
            throw new \InvalidArgumentException($alertArrayErrorMessage, __LINE__);
        }
        $this->Alert = $alert;
        return $this;
    }
    /**
     * Add item to Alert value
     * @throws \InvalidArgumentException
     * @param \Ups_void\UPSvoidStruct\Ups_voidCodeDescriptionType $item
     * @return \Ups_void\UPSvoidStruct\Ups_voidResponseType
     */
    public function addToAlert(\Ups_void\UPSvoidStruct\Ups_voidCodeDescriptionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups_void\UPSvoidStruct\Ups_voidCodeDescriptionType) {
            throw new \InvalidArgumentException(sprintf('The Alert property can only contain items of type \Ups_void\UPSvoidStruct\Ups_voidCodeDescriptionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Alert[] = $item;
        return $this;
    }
    /**
     * Get AlertDetail value
     * @return \Ups_void\UPSvoidStruct\Ups_voidDetailType[]|null
     */
    public function getAlertDetail()
    {
        return $this->AlertDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setAlertDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAlertDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAlertDetailForArrayConstraintsFromSetAlertDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $responseTypeAlertDetailItem) {
            // validation for constraint: itemType
            if (!$responseTypeAlertDetailItem instanceof \Ups_void\UPSvoidStruct\Ups_voidDetailType) {
                $invalidValues[] = is_object($responseTypeAlertDetailItem) ? get_class($responseTypeAlertDetailItem) : sprintf('%s(%s)', gettype($responseTypeAlertDetailItem), var_export($responseTypeAlertDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AlertDetail property can only contain items of type \Ups_void\UPSvoidStruct\Ups_voidDetailType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AlertDetail value
     * @throws \InvalidArgumentException
     * @param \Ups_void\UPSvoidStruct\Ups_voidDetailType[] $alertDetail
     * @return \Ups_void\UPSvoidStruct\Ups_voidResponseType
     */
    public function setAlertDetail(array $alertDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($alertDetailArrayErrorMessage = self::validateAlertDetailForArrayConstraintsFromSetAlertDetail($alertDetail))) {
            throw new \InvalidArgumentException($alertDetailArrayErrorMessage, __LINE__);
        }
        $this->AlertDetail = $alertDetail;
        return $this;
    }
    /**
     * Add item to AlertDetail value
     * @throws \InvalidArgumentException
     * @param \Ups_void\UPSvoidStruct\Ups_voidDetailType $item
     * @return \Ups_void\UPSvoidStruct\Ups_voidResponseType
     */
    public function addToAlertDetail(\Ups_void\UPSvoidStruct\Ups_voidDetailType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups_void\UPSvoidStruct\Ups_voidDetailType) {
            throw new \InvalidArgumentException(sprintf('The AlertDetail property can only contain items of type \Ups_void\UPSvoidStruct\Ups_voidDetailType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AlertDetail[] = $item;
        return $this;
    }
    /**
     * Get TransactionReference value
     * @return \Ups_void\UPSvoidStruct\Ups_voidTransactionReferenceType|null
     */
    public function getTransactionReference()
    {
        return $this->TransactionReference;
    }
    /**
     * Set TransactionReference value
     * @param \Ups_void\UPSvoidStruct\Ups_voidTransactionReferenceType $transactionReference
     * @return \Ups_void\UPSvoidStruct\Ups_voidResponseType
     */
    public function setTransactionReference(\Ups_void\UPSvoidStruct\Ups_voidTransactionReferenceType $transactionReference = null)
    {
        $this->TransactionReference = $transactionReference;
        return $this;
    }
}
