<?php

namespace Ups_void\UPSvoidStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VoidShipment UPSvoidStruct
 * @package Ups_void
 * @subpackage Structs
 */
class Ups_voidVoidShipment extends AbstractStructBase
{
    /**
     * The ShipmentIdentificationNumber
     * @var string
     */
    public $ShipmentIdentificationNumber;
    /**
     * The TrackingNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $TrackingNumber;
    /**
     * Constructor method for VoidShipment
     * @uses Ups_voidVoidShipment::setShipmentIdentificationNumber()
     * @uses Ups_voidVoidShipment::setTrackingNumber()
     * @param string $shipmentIdentificationNumber
     * @param string[] $trackingNumber
     */
    public function __construct($shipmentIdentificationNumber = null, array $trackingNumber = array())
    {
        $this
            ->setShipmentIdentificationNumber($shipmentIdentificationNumber)
            ->setTrackingNumber($trackingNumber);
    }
    /**
     * Get ShipmentIdentificationNumber value
     * @return string|null
     */
    public function getShipmentIdentificationNumber()
    {
        return $this->ShipmentIdentificationNumber;
    }
    /**
     * Set ShipmentIdentificationNumber value
     * @param string $shipmentIdentificationNumber
     * @return \Ups_void\UPSvoidStruct\Ups_voidVoidShipment
     */
    public function setShipmentIdentificationNumber($shipmentIdentificationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($shipmentIdentificationNumber) && !is_string($shipmentIdentificationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipmentIdentificationNumber, true), gettype($shipmentIdentificationNumber)), __LINE__);
        }
        $this->ShipmentIdentificationNumber = $shipmentIdentificationNumber;
        return $this;
    }
    /**
     * Get TrackingNumber value
     * @return string[]|null
     */
    public function getTrackingNumber()
    {
        return $this->TrackingNumber;
    }
    /**
     * This method is responsible for validating the values passed to the setTrackingNumber method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTrackingNumber method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTrackingNumberForArrayConstraintsFromSetTrackingNumber(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $voidShipmentTrackingNumberItem) {
            // validation for constraint: itemType
            if (!is_string($voidShipmentTrackingNumberItem)) {
                $invalidValues[] = is_object($voidShipmentTrackingNumberItem) ? get_class($voidShipmentTrackingNumberItem) : sprintf('%s(%s)', gettype($voidShipmentTrackingNumberItem), var_export($voidShipmentTrackingNumberItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TrackingNumber property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TrackingNumber value
     * @throws \InvalidArgumentException
     * @param string[] $trackingNumber
     * @return \Ups_void\UPSvoidStruct\Ups_voidVoidShipment
     */
    public function setTrackingNumber(array $trackingNumber = array())
    {
        // validation for constraint: array
        if ('' !== ($trackingNumberArrayErrorMessage = self::validateTrackingNumberForArrayConstraintsFromSetTrackingNumber($trackingNumber))) {
            throw new \InvalidArgumentException($trackingNumberArrayErrorMessage, __LINE__);
        }
        $this->TrackingNumber = $trackingNumber;
        return $this;
    }
    /**
     * Add item to TrackingNumber value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Ups_void\UPSvoidStruct\Ups_voidVoidShipment
     */
    public function addToTrackingNumber($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The TrackingNumber property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TrackingNumber[] = $item;
        return $this;
    }
}
