<?php

namespace Ups_void\UPSvoidStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ErrorDetailType UPSvoidStruct
 * @package Ups_void
 * @subpackage Structs
 */
class Ups_voidErrorDetailType extends AbstractStructBase
{
    /**
     * The Severity
     * @var string
     */
    public $Severity;
    /**
     * The PrimaryErrorCode
     * @var \Ups_void\UPSvoidStruct\Ups_voidCodeType
     */
    public $PrimaryErrorCode;
    /**
     * The MinimumRetrySeconds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $MinimumRetrySeconds;
    /**
     * The Location
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_void\UPSvoidStruct\Ups_voidLocationType
     */
    public $Location;
    /**
     * The SubErrorCode
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Ups_void\UPSvoidStruct\Ups_voidCodeType[]
     */
    public $SubErrorCode;
    /**
     * The AdditionalInformation
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Ups_void\UPSvoidStruct\Ups_voidAdditionalInfoType[]
     */
    public $AdditionalInformation;
    /**
     * The ElementLevelInformation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_void\UPSvoidStruct\Ups_voidElementLevelInformationType
     */
    public $ElementLevelInformation;
    /**
     * Constructor method for ErrorDetailType
     * @uses Ups_voidErrorDetailType::setSeverity()
     * @uses Ups_voidErrorDetailType::setPrimaryErrorCode()
     * @uses Ups_voidErrorDetailType::setMinimumRetrySeconds()
     * @uses Ups_voidErrorDetailType::setLocation()
     * @uses Ups_voidErrorDetailType::setSubErrorCode()
     * @uses Ups_voidErrorDetailType::setAdditionalInformation()
     * @uses Ups_voidErrorDetailType::setElementLevelInformation()
     * @param string $severity
     * @param \Ups_void\UPSvoidStruct\Ups_voidCodeType $primaryErrorCode
     * @param string $minimumRetrySeconds
     * @param \Ups_void\UPSvoidStruct\Ups_voidLocationType $location
     * @param \Ups_void\UPSvoidStruct\Ups_voidCodeType[] $subErrorCode
     * @param \Ups_void\UPSvoidStruct\Ups_voidAdditionalInfoType[] $additionalInformation
     * @param \Ups_void\UPSvoidStruct\Ups_voidElementLevelInformationType $elementLevelInformation
     */
    public function __construct($severity = null, \Ups_void\UPSvoidStruct\Ups_voidCodeType $primaryErrorCode = null, $minimumRetrySeconds = null, \Ups_void\UPSvoidStruct\Ups_voidLocationType $location = null, array $subErrorCode = array(), array $additionalInformation = array(), \Ups_void\UPSvoidStruct\Ups_voidElementLevelInformationType $elementLevelInformation = null)
    {
        $this
            ->setSeverity($severity)
            ->setPrimaryErrorCode($primaryErrorCode)
            ->setMinimumRetrySeconds($minimumRetrySeconds)
            ->setLocation($location)
            ->setSubErrorCode($subErrorCode)
            ->setAdditionalInformation($additionalInformation)
            ->setElementLevelInformation($elementLevelInformation);
    }
    /**
     * Get Severity value
     * @return string|null
     */
    public function getSeverity()
    {
        return $this->Severity;
    }
    /**
     * Set Severity value
     * @param string $severity
     * @return \Ups_void\UPSvoidStruct\Ups_voidErrorDetailType
     */
    public function setSeverity($severity = null)
    {
        // validation for constraint: string
        if (!is_null($severity) && !is_string($severity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($severity, true), gettype($severity)), __LINE__);
        }
        $this->Severity = $severity;
        return $this;
    }
    /**
     * Get PrimaryErrorCode value
     * @return \Ups_void\UPSvoidStruct\Ups_voidCodeType|null
     */
    public function getPrimaryErrorCode()
    {
        return $this->PrimaryErrorCode;
    }
    /**
     * Set PrimaryErrorCode value
     * @param \Ups_void\UPSvoidStruct\Ups_voidCodeType $primaryErrorCode
     * @return \Ups_void\UPSvoidStruct\Ups_voidErrorDetailType
     */
    public function setPrimaryErrorCode(\Ups_void\UPSvoidStruct\Ups_voidCodeType $primaryErrorCode = null)
    {
        $this->PrimaryErrorCode = $primaryErrorCode;
        return $this;
    }
    /**
     * Get MinimumRetrySeconds value
     * @return string|null
     */
    public function getMinimumRetrySeconds()
    {
        return $this->MinimumRetrySeconds;
    }
    /**
     * Set MinimumRetrySeconds value
     * @param string $minimumRetrySeconds
     * @return \Ups_void\UPSvoidStruct\Ups_voidErrorDetailType
     */
    public function setMinimumRetrySeconds($minimumRetrySeconds = null)
    {
        // validation for constraint: string
        if (!is_null($minimumRetrySeconds) && !is_string($minimumRetrySeconds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($minimumRetrySeconds, true), gettype($minimumRetrySeconds)), __LINE__);
        }
        $this->MinimumRetrySeconds = $minimumRetrySeconds;
        return $this;
    }
    /**
     * Get Location value
     * @return \Ups_void\UPSvoidStruct\Ups_voidLocationType|null
     */
    public function getLocation()
    {
        return $this->Location;
    }
    /**
     * Set Location value
     * @param \Ups_void\UPSvoidStruct\Ups_voidLocationType $location
     * @return \Ups_void\UPSvoidStruct\Ups_voidErrorDetailType
     */
    public function setLocation(\Ups_void\UPSvoidStruct\Ups_voidLocationType $location = null)
    {
        $this->Location = $location;
        return $this;
    }
    /**
     * Get SubErrorCode value
     * @return \Ups_void\UPSvoidStruct\Ups_voidCodeType[]|null
     */
    public function getSubErrorCode()
    {
        return $this->SubErrorCode;
    }
    /**
     * This method is responsible for validating the values passed to the setSubErrorCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSubErrorCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSubErrorCodeForArrayConstraintsFromSetSubErrorCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $errorDetailTypeSubErrorCodeItem) {
            // validation for constraint: itemType
            if (!$errorDetailTypeSubErrorCodeItem instanceof \Ups_void\UPSvoidStruct\Ups_voidCodeType) {
                $invalidValues[] = is_object($errorDetailTypeSubErrorCodeItem) ? get_class($errorDetailTypeSubErrorCodeItem) : sprintf('%s(%s)', gettype($errorDetailTypeSubErrorCodeItem), var_export($errorDetailTypeSubErrorCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SubErrorCode property can only contain items of type \Ups_void\UPSvoidStruct\Ups_voidCodeType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SubErrorCode value
     * @throws \InvalidArgumentException
     * @param \Ups_void\UPSvoidStruct\Ups_voidCodeType[] $subErrorCode
     * @return \Ups_void\UPSvoidStruct\Ups_voidErrorDetailType
     */
    public function setSubErrorCode(array $subErrorCode = array())
    {
        // validation for constraint: array
        if ('' !== ($subErrorCodeArrayErrorMessage = self::validateSubErrorCodeForArrayConstraintsFromSetSubErrorCode($subErrorCode))) {
            throw new \InvalidArgumentException($subErrorCodeArrayErrorMessage, __LINE__);
        }
        $this->SubErrorCode = $subErrorCode;
        return $this;
    }
    /**
     * Add item to SubErrorCode value
     * @throws \InvalidArgumentException
     * @param \Ups_void\UPSvoidStruct\Ups_voidCodeType $item
     * @return \Ups_void\UPSvoidStruct\Ups_voidErrorDetailType
     */
    public function addToSubErrorCode(\Ups_void\UPSvoidStruct\Ups_voidCodeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups_void\UPSvoidStruct\Ups_voidCodeType) {
            throw new \InvalidArgumentException(sprintf('The SubErrorCode property can only contain items of type \Ups_void\UPSvoidStruct\Ups_voidCodeType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SubErrorCode[] = $item;
        return $this;
    }
    /**
     * Get AdditionalInformation value
     * @return \Ups_void\UPSvoidStruct\Ups_voidAdditionalInfoType[]|null
     */
    public function getAdditionalInformation()
    {
        return $this->AdditionalInformation;
    }
    /**
     * This method is responsible for validating the values passed to the setAdditionalInformation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdditionalInformation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdditionalInformationForArrayConstraintsFromSetAdditionalInformation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $errorDetailTypeAdditionalInformationItem) {
            // validation for constraint: itemType
            if (!$errorDetailTypeAdditionalInformationItem instanceof \Ups_void\UPSvoidStruct\Ups_voidAdditionalInfoType) {
                $invalidValues[] = is_object($errorDetailTypeAdditionalInformationItem) ? get_class($errorDetailTypeAdditionalInformationItem) : sprintf('%s(%s)', gettype($errorDetailTypeAdditionalInformationItem), var_export($errorDetailTypeAdditionalInformationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AdditionalInformation property can only contain items of type \Ups_void\UPSvoidStruct\Ups_voidAdditionalInfoType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AdditionalInformation value
     * @throws \InvalidArgumentException
     * @param \Ups_void\UPSvoidStruct\Ups_voidAdditionalInfoType[] $additionalInformation
     * @return \Ups_void\UPSvoidStruct\Ups_voidErrorDetailType
     */
    public function setAdditionalInformation(array $additionalInformation = array())
    {
        // validation for constraint: array
        if ('' !== ($additionalInformationArrayErrorMessage = self::validateAdditionalInformationForArrayConstraintsFromSetAdditionalInformation($additionalInformation))) {
            throw new \InvalidArgumentException($additionalInformationArrayErrorMessage, __LINE__);
        }
        $this->AdditionalInformation = $additionalInformation;
        return $this;
    }
    /**
     * Add item to AdditionalInformation value
     * @throws \InvalidArgumentException
     * @param \Ups_void\UPSvoidStruct\Ups_voidAdditionalInfoType $item
     * @return \Ups_void\UPSvoidStruct\Ups_voidErrorDetailType
     */
    public function addToAdditionalInformation(\Ups_void\UPSvoidStruct\Ups_voidAdditionalInfoType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups_void\UPSvoidStruct\Ups_voidAdditionalInfoType) {
            throw new \InvalidArgumentException(sprintf('The AdditionalInformation property can only contain items of type \Ups_void\UPSvoidStruct\Ups_voidAdditionalInfoType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AdditionalInformation[] = $item;
        return $this;
    }
    /**
     * Get ElementLevelInformation value
     * @return \Ups_void\UPSvoidStruct\Ups_voidElementLevelInformationType|null
     */
    public function getElementLevelInformation()
    {
        return $this->ElementLevelInformation;
    }
    /**
     * Set ElementLevelInformation value
     * @param \Ups_void\UPSvoidStruct\Ups_voidElementLevelInformationType $elementLevelInformation
     * @return \Ups_void\UPSvoidStruct\Ups_voidErrorDetailType
     */
    public function setElementLevelInformation(\Ups_void\UPSvoidStruct\Ups_voidElementLevelInformationType $elementLevelInformation = null)
    {
        $this->ElementLevelInformation = $elementLevelInformation;
        return $this;
    }
}
