<?php

namespace Ups_void\UPSvoidStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PackageLevelResult UPSvoidStruct
 * @package Ups_void
 * @subpackage Structs
 */
class Ups_voidPackageLevelResult extends AbstractStructBase
{
    /**
     * The TrackingNumber
     * @var string
     */
    public $TrackingNumber;
    /**
     * The Status
     * @var \Ups_void\UPSvoidStruct\Ups_voidCodeDescriptionType
     */
    public $Status;
    /**
     * Constructor method for PackageLevelResult
     * @uses Ups_voidPackageLevelResult::setTrackingNumber()
     * @uses Ups_voidPackageLevelResult::setStatus()
     * @param string $trackingNumber
     * @param \Ups_void\UPSvoidStruct\Ups_voidCodeDescriptionType $status
     */
    public function __construct($trackingNumber = null, \Ups_void\UPSvoidStruct\Ups_voidCodeDescriptionType $status = null)
    {
        $this
            ->setTrackingNumber($trackingNumber)
            ->setStatus($status);
    }
    /**
     * Get TrackingNumber value
     * @return string|null
     */
    public function getTrackingNumber()
    {
        return $this->TrackingNumber;
    }
    /**
     * Set TrackingNumber value
     * @param string $trackingNumber
     * @return \Ups_void\UPSvoidStruct\Ups_voidPackageLevelResult
     */
    public function setTrackingNumber($trackingNumber = null)
    {
        // validation for constraint: string
        if (!is_null($trackingNumber) && !is_string($trackingNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trackingNumber, true), gettype($trackingNumber)), __LINE__);
        }
        $this->TrackingNumber = $trackingNumber;
        return $this;
    }
    /**
     * Get Status value
     * @return \Ups_void\UPSvoidStruct\Ups_voidCodeDescriptionType|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param \Ups_void\UPSvoidStruct\Ups_voidCodeDescriptionType $status
     * @return \Ups_void\UPSvoidStruct\Ups_voidPackageLevelResult
     */
    public function setStatus(\Ups_void\UPSvoidStruct\Ups_voidCodeDescriptionType $status = null)
    {
        $this->Status = $status;
        return $this;
    }
}
