<?php

namespace Ups_void\UPSvoidService;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Process UPSvoidService
 * @package Ups_void
 * @subpackage Services
 */
class Ups_voidProcess extends AbstractSoapClientBase
{
    /**
     * Sets the UPSSecurity SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \Ups_void\UPSvoidStruct\Ups_voidUPSSecurity $uPSSecurity
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderUPSSecurity(\Ups_void\UPSvoidStruct\Ups_voidUPSSecurity $uPSSecurity, $nameSpace = 'http://www.ups.com/XMLSchema/XOLTWS/UPSS/v1.0', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'UPSSecurity', $uPSSecurity, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named ProcessVoid
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: UPSSecurity
     * - SOAPHeaderNamespaces: http://www.ups.com/XMLSchema/XOLTWS/UPSS/v1.0
     * - SOAPHeaderTypes: \Ups_void\UPSvoidStruct\Ups_voidUPSSecurity
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Ups_void\UPSvoidStruct\Ups_voidVoidShipmentRequest $body
     * @return \Ups_void\UPSvoidStruct\Ups_voidVoidShipmentResponse|bool
     */
    public function ProcessVoid(\Ups_void\UPSvoidStruct\Ups_voidVoidShipmentRequest $body)
    {
        try {
            $this->setResult($this->getSoapClient()->ProcessVoid($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Ups_void\UPSvoidStruct\Ups_voidVoidShipmentResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
