<?php

namespace Ups_label\UPSlabelStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReferenceValuesType UPSlabelStruct
 * @package Ups_label
 * @subpackage Structs
 */
class Ups_labelReferenceValuesType extends AbstractStructBase
{
    /**
     * The ReferenceNumber
     * @var \Ups_label\UPSlabelStruct\Ups_labelReferenceNumberType
     */
    public $ReferenceNumber;
    /**
     * The ShipperNumber
     * @var string
     */
    public $ShipperNumber;
    /**
     * Constructor method for ReferenceValuesType
     * @uses Ups_labelReferenceValuesType::setReferenceNumber()
     * @uses Ups_labelReferenceValuesType::setShipperNumber()
     * @param \Ups_label\UPSlabelStruct\Ups_labelReferenceNumberType $referenceNumber
     * @param string $shipperNumber
     */
    public function __construct(\Ups_label\UPSlabelStruct\Ups_labelReferenceNumberType $referenceNumber = null, $shipperNumber = null)
    {
        $this
            ->setReferenceNumber($referenceNumber)
            ->setShipperNumber($shipperNumber);
    }
    /**
     * Get ReferenceNumber value
     * @return \Ups_label\UPSlabelStruct\Ups_labelReferenceNumberType|null
     */
    public function getReferenceNumber()
    {
        return $this->ReferenceNumber;
    }
    /**
     * Set ReferenceNumber value
     * @param \Ups_label\UPSlabelStruct\Ups_labelReferenceNumberType $referenceNumber
     * @return \Ups_label\UPSlabelStruct\Ups_labelReferenceValuesType
     */
    public function setReferenceNumber(\Ups_label\UPSlabelStruct\Ups_labelReferenceNumberType $referenceNumber = null)
    {
        $this->ReferenceNumber = $referenceNumber;
        return $this;
    }
    /**
     * Get ShipperNumber value
     * @return string|null
     */
    public function getShipperNumber()
    {
        return $this->ShipperNumber;
    }
    /**
     * Set ShipperNumber value
     * @param string $shipperNumber
     * @return \Ups_label\UPSlabelStruct\Ups_labelReferenceValuesType
     */
    public function setShipperNumber($shipperNumber = null)
    {
        // validation for constraint: string
        if (!is_null($shipperNumber) && !is_string($shipperNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipperNumber, true), gettype($shipperNumber)), __LINE__);
        }
        $this->ShipperNumber = $shipperNumber;
        return $this;
    }
}
