<?php

namespace Ups_label\UPSlabelStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LabelRecoveryResponse UPSlabelStruct
 * @package Ups_label
 * @subpackage Structs
 */
class Ups_labelLabelRecoveryResponse extends AbstractStructBase
{
    /**
     * The Response
     * Meta information extracted from the WSDL
     * - ref: common:Response
     * @var \Ups_label\UPSlabelStruct\Ups_labelResponseType
     */
    public $Response;
    /**
     * The ShipmentIdentificationNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ShipmentIdentificationNumber;
    /**
     * The CODTurnInPage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_label\UPSlabelStruct\Ups_labelResponseImageType
     */
    public $CODTurnInPage;
    /**
     * The Form
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_label\UPSlabelStruct\Ups_labelFormType
     */
    public $Form;
    /**
     * The HighValueReport
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_label\UPSlabelStruct\Ups_labelHighValueReportType
     */
    public $HighValueReport;
    /**
     * The LabelResults
     * Meta information extracted from the WSDL
     * - choice: LabelResults | TrackingCandidate
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * @var \Ups_label\UPSlabelStruct\Ups_labelLabelResultsType
     */
    public $LabelResults;
    /**
     * The TrackingCandidate
     * Meta information extracted from the WSDL
     * - choice: LabelResults | TrackingCandidate
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * @var \Ups_label\UPSlabelStruct\Ups_labelTrackingCandidateType
     */
    public $TrackingCandidate;
    /**
     * Constructor method for LabelRecoveryResponse
     * @uses Ups_labelLabelRecoveryResponse::setResponse()
     * @uses Ups_labelLabelRecoveryResponse::setShipmentIdentificationNumber()
     * @uses Ups_labelLabelRecoveryResponse::setCODTurnInPage()
     * @uses Ups_labelLabelRecoveryResponse::setForm()
     * @uses Ups_labelLabelRecoveryResponse::setHighValueReport()
     * @uses Ups_labelLabelRecoveryResponse::setLabelResults()
     * @uses Ups_labelLabelRecoveryResponse::setTrackingCandidate()
     * @param \Ups_label\UPSlabelStruct\Ups_labelResponseType $response
     * @param string $shipmentIdentificationNumber
     * @param \Ups_label\UPSlabelStruct\Ups_labelResponseImageType $cODTurnInPage
     * @param \Ups_label\UPSlabelStruct\Ups_labelFormType $form
     * @param \Ups_label\UPSlabelStruct\Ups_labelHighValueReportType $highValueReport
     * @param \Ups_label\UPSlabelStruct\Ups_labelLabelResultsType $labelResults
     * @param \Ups_label\UPSlabelStruct\Ups_labelTrackingCandidateType $trackingCandidate
     */
    public function __construct(\Ups_label\UPSlabelStruct\Ups_labelResponseType $response = null, $shipmentIdentificationNumber = null, \Ups_label\UPSlabelStruct\Ups_labelResponseImageType $cODTurnInPage = null, \Ups_label\UPSlabelStruct\Ups_labelFormType $form = null, \Ups_label\UPSlabelStruct\Ups_labelHighValueReportType $highValueReport = null, \Ups_label\UPSlabelStruct\Ups_labelLabelResultsType $labelResults = null, \Ups_label\UPSlabelStruct\Ups_labelTrackingCandidateType $trackingCandidate = null)
    {
        $this
            ->setResponse($response)
            ->setShipmentIdentificationNumber($shipmentIdentificationNumber)
            ->setCODTurnInPage($cODTurnInPage)
            ->setForm($form)
            ->setHighValueReport($highValueReport)
            ->setLabelResults($labelResults)
            ->setTrackingCandidate($trackingCandidate);
    }
    /**
     * Get Response value
     * @return \Ups_label\UPSlabelStruct\Ups_labelResponseType|null
     */
    public function getResponse()
    {
        return $this->Response;
    }
    /**
     * Set Response value
     * @param \Ups_label\UPSlabelStruct\Ups_labelResponseType $response
     * @return \Ups_label\UPSlabelStruct\Ups_labelLabelRecoveryResponse
     */
    public function setResponse(\Ups_label\UPSlabelStruct\Ups_labelResponseType $response = null)
    {
        $this->Response = $response;
        return $this;
    }
    /**
     * Get ShipmentIdentificationNumber value
     * @return string|null
     */
    public function getShipmentIdentificationNumber()
    {
        return $this->ShipmentIdentificationNumber;
    }
    /**
     * Set ShipmentIdentificationNumber value
     * @param string $shipmentIdentificationNumber
     * @return \Ups_label\UPSlabelStruct\Ups_labelLabelRecoveryResponse
     */
    public function setShipmentIdentificationNumber($shipmentIdentificationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($shipmentIdentificationNumber) && !is_string($shipmentIdentificationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipmentIdentificationNumber, true), gettype($shipmentIdentificationNumber)), __LINE__);
        }
        $this->ShipmentIdentificationNumber = $shipmentIdentificationNumber;
        return $this;
    }
    /**
     * Get CODTurnInPage value
     * @return \Ups_label\UPSlabelStruct\Ups_labelResponseImageType|null
     */
    public function getCODTurnInPage()
    {
        return $this->CODTurnInPage;
    }
    /**
     * Set CODTurnInPage value
     * @param \Ups_label\UPSlabelStruct\Ups_labelResponseImageType $cODTurnInPage
     * @return \Ups_label\UPSlabelStruct\Ups_labelLabelRecoveryResponse
     */
    public function setCODTurnInPage(\Ups_label\UPSlabelStruct\Ups_labelResponseImageType $cODTurnInPage = null)
    {
        $this->CODTurnInPage = $cODTurnInPage;
        return $this;
    }
    /**
     * Get Form value
     * @return \Ups_label\UPSlabelStruct\Ups_labelFormType|null
     */
    public function getForm()
    {
        return $this->Form;
    }
    /**
     * Set Form value
     * @param \Ups_label\UPSlabelStruct\Ups_labelFormType $form
     * @return \Ups_label\UPSlabelStruct\Ups_labelLabelRecoveryResponse
     */
    public function setForm(\Ups_label\UPSlabelStruct\Ups_labelFormType $form = null)
    {
        $this->Form = $form;
        return $this;
    }
    /**
     * Get HighValueReport value
     * @return \Ups_label\UPSlabelStruct\Ups_labelHighValueReportType|null
     */
    public function getHighValueReport()
    {
        return $this->HighValueReport;
    }
    /**
     * Set HighValueReport value
     * @param \Ups_label\UPSlabelStruct\Ups_labelHighValueReportType $highValueReport
     * @return \Ups_label\UPSlabelStruct\Ups_labelLabelRecoveryResponse
     */
    public function setHighValueReport(\Ups_label\UPSlabelStruct\Ups_labelHighValueReportType $highValueReport = null)
    {
        $this->HighValueReport = $highValueReport;
        return $this;
    }
    /**
     * Get LabelResults value
     * @return \Ups_label\UPSlabelStruct\Ups_labelLabelResultsType|null
     */
    public function getLabelResults()
    {
        return isset($this->LabelResults) ? $this->LabelResults : null;
    }
    /**
     * This method is responsible for validating the value passed to the setLabelResults method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLabelResults method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateLabelResultsForChoiceConstraintsFromSetLabelResults($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'TrackingCandidate',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property LabelResults can\'t be set as the property %s is already set. Only one property must be set among these properties: LabelResults, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set LabelResults value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \Ups_label\UPSlabelStruct\Ups_labelLabelResultsType $labelResults
     * @return \Ups_label\UPSlabelStruct\Ups_labelLabelRecoveryResponse
     */
    public function setLabelResults(\Ups_label\UPSlabelStruct\Ups_labelLabelResultsType $labelResults = null)
    {
        // validation for constraint: choice(LabelResults, TrackingCandidate)
        if ('' !== ($labelResultsChoiceErrorMessage = self::validateLabelResultsForChoiceConstraintsFromSetLabelResults($labelResults))) {
            throw new \InvalidArgumentException($labelResultsChoiceErrorMessage, __LINE__);
        }
        if (is_null($labelResults) || (is_array($labelResults) && empty($labelResults))) {
            unset($this->LabelResults);
        } else {
            $this->LabelResults = $labelResults;
        }
        return $this;
    }
    /**
     * Get TrackingCandidate value
     * @return \Ups_label\UPSlabelStruct\Ups_labelTrackingCandidateType|null
     */
    public function getTrackingCandidate()
    {
        return isset($this->TrackingCandidate) ? $this->TrackingCandidate : null;
    }
    /**
     * This method is responsible for validating the value passed to the setTrackingCandidate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTrackingCandidate method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateTrackingCandidateForChoiceConstraintsFromSetTrackingCandidate($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'LabelResults',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property TrackingCandidate can\'t be set as the property %s is already set. Only one property must be set among these properties: TrackingCandidate, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set TrackingCandidate value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \Ups_label\UPSlabelStruct\Ups_labelTrackingCandidateType $trackingCandidate
     * @return \Ups_label\UPSlabelStruct\Ups_labelLabelRecoveryResponse
     */
    public function setTrackingCandidate(\Ups_label\UPSlabelStruct\Ups_labelTrackingCandidateType $trackingCandidate = null)
    {
        // validation for constraint: choice(LabelResults, TrackingCandidate)
        if ('' !== ($trackingCandidateChoiceErrorMessage = self::validateTrackingCandidateForChoiceConstraintsFromSetTrackingCandidate($trackingCandidate))) {
            throw new \InvalidArgumentException($trackingCandidateChoiceErrorMessage, __LINE__);
        }
        if (is_null($trackingCandidate) || (is_array($trackingCandidate) && empty($trackingCandidate))) {
            unset($this->TrackingCandidate);
        } else {
            $this->TrackingCandidate = $trackingCandidate;
        }
        return $this;
    }
}
