<?php

namespace Ups_label\UPSlabelStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LabelImageType UPSlabelStruct
 * @package Ups_label
 * @subpackage Structs
 */
class Ups_labelLabelImageType extends AbstractStructBase
{
    /**
     * The LabelImageFormat
     * @var \Ups_label\UPSlabelStruct\Ups_labelLabelImageFormatType
     */
    public $LabelImageFormat;
    /**
     * The GraphicImage
     * @var string
     */
    public $GraphicImage;
    /**
     * The HTMLImage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $HTMLImage;
    /**
     * The PDF417
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PDF417;
    /**
     * The InternationalSignatureGraphicImage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $InternationalSignatureGraphicImage;
    /**
     * The URL
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $URL;
    /**
     * Constructor method for LabelImageType
     * @uses Ups_labelLabelImageType::setLabelImageFormat()
     * @uses Ups_labelLabelImageType::setGraphicImage()
     * @uses Ups_labelLabelImageType::setHTMLImage()
     * @uses Ups_labelLabelImageType::setPDF417()
     * @uses Ups_labelLabelImageType::setInternationalSignatureGraphicImage()
     * @uses Ups_labelLabelImageType::setURL()
     * @param \Ups_label\UPSlabelStruct\Ups_labelLabelImageFormatType $labelImageFormat
     * @param string $graphicImage
     * @param string $hTMLImage
     * @param string $pDF417
     * @param string $internationalSignatureGraphicImage
     * @param string $uRL
     */
    public function __construct(\Ups_label\UPSlabelStruct\Ups_labelLabelImageFormatType $labelImageFormat = null, $graphicImage = null, $hTMLImage = null, $pDF417 = null, $internationalSignatureGraphicImage = null, $uRL = null)
    {
        $this
            ->setLabelImageFormat($labelImageFormat)
            ->setGraphicImage($graphicImage)
            ->setHTMLImage($hTMLImage)
            ->setPDF417($pDF417)
            ->setInternationalSignatureGraphicImage($internationalSignatureGraphicImage)
            ->setURL($uRL);
    }
    /**
     * Get LabelImageFormat value
     * @return \Ups_label\UPSlabelStruct\Ups_labelLabelImageFormatType|null
     */
    public function getLabelImageFormat()
    {
        return $this->LabelImageFormat;
    }
    /**
     * Set LabelImageFormat value
     * @param \Ups_label\UPSlabelStruct\Ups_labelLabelImageFormatType $labelImageFormat
     * @return \Ups_label\UPSlabelStruct\Ups_labelLabelImageType
     */
    public function setLabelImageFormat(\Ups_label\UPSlabelStruct\Ups_labelLabelImageFormatType $labelImageFormat = null)
    {
        $this->LabelImageFormat = $labelImageFormat;
        return $this;
    }
    /**
     * Get GraphicImage value
     * @return string|null
     */
    public function getGraphicImage()
    {
        return $this->GraphicImage;
    }
    /**
     * Set GraphicImage value
     * @param string $graphicImage
     * @return \Ups_label\UPSlabelStruct\Ups_labelLabelImageType
     */
    public function setGraphicImage($graphicImage = null)
    {
        // validation for constraint: string
        if (!is_null($graphicImage) && !is_string($graphicImage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($graphicImage, true), gettype($graphicImage)), __LINE__);
        }
        $this->GraphicImage = $graphicImage;
        return $this;
    }
    /**
     * Get HTMLImage value
     * @return string|null
     */
    public function getHTMLImage()
    {
        return $this->HTMLImage;
    }
    /**
     * Set HTMLImage value
     * @param string $hTMLImage
     * @return \Ups_label\UPSlabelStruct\Ups_labelLabelImageType
     */
    public function setHTMLImage($hTMLImage = null)
    {
        // validation for constraint: string
        if (!is_null($hTMLImage) && !is_string($hTMLImage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hTMLImage, true), gettype($hTMLImage)), __LINE__);
        }
        $this->HTMLImage = $hTMLImage;
        return $this;
    }
    /**
     * Get PDF417 value
     * @return string|null
     */
    public function getPDF417()
    {
        return $this->PDF417;
    }
    /**
     * Set PDF417 value
     * @param string $pDF417
     * @return \Ups_label\UPSlabelStruct\Ups_labelLabelImageType
     */
    public function setPDF417($pDF417 = null)
    {
        // validation for constraint: string
        if (!is_null($pDF417) && !is_string($pDF417)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pDF417, true), gettype($pDF417)), __LINE__);
        }
        $this->PDF417 = $pDF417;
        return $this;
    }
    /**
     * Get InternationalSignatureGraphicImage value
     * @return string|null
     */
    public function getInternationalSignatureGraphicImage()
    {
        return $this->InternationalSignatureGraphicImage;
    }
    /**
     * Set InternationalSignatureGraphicImage value
     * @param string $internationalSignatureGraphicImage
     * @return \Ups_label\UPSlabelStruct\Ups_labelLabelImageType
     */
    public function setInternationalSignatureGraphicImage($internationalSignatureGraphicImage = null)
    {
        // validation for constraint: string
        if (!is_null($internationalSignatureGraphicImage) && !is_string($internationalSignatureGraphicImage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internationalSignatureGraphicImage, true), gettype($internationalSignatureGraphicImage)), __LINE__);
        }
        $this->InternationalSignatureGraphicImage = $internationalSignatureGraphicImage;
        return $this;
    }
    /**
     * Get URL value
     * @return string|null
     */
    public function getURL()
    {
        return $this->URL;
    }
    /**
     * Set URL value
     * @param string $uRL
     * @return \Ups_label\UPSlabelStruct\Ups_labelLabelImageType
     */
    public function setURL($uRL = null)
    {
        // validation for constraint: string
        if (!is_null($uRL) && !is_string($uRL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uRL, true), gettype($uRL)), __LINE__);
        }
        $this->URL = $uRL;
        return $this;
    }
}
