<?php

namespace Ups_label\UPSlabelStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FormImageType UPSlabelStruct
 * @package Ups_label
 * @subpackage Structs
 */
class Ups_labelFormImageType extends AbstractStructBase
{
    /**
     * The ImageFormat
     * @var \Ups_label\UPSlabelStruct\Ups_labelImageFormatCodeType
     */
    public $ImageFormat;
    /**
     * The GraphicImage
     * @var string
     */
    public $GraphicImage;
    /**
     * Constructor method for FormImageType
     * @uses Ups_labelFormImageType::setImageFormat()
     * @uses Ups_labelFormImageType::setGraphicImage()
     * @param \Ups_label\UPSlabelStruct\Ups_labelImageFormatCodeType $imageFormat
     * @param string $graphicImage
     */
    public function __construct(\Ups_label\UPSlabelStruct\Ups_labelImageFormatCodeType $imageFormat = null, $graphicImage = null)
    {
        $this
            ->setImageFormat($imageFormat)
            ->setGraphicImage($graphicImage);
    }
    /**
     * Get ImageFormat value
     * @return \Ups_label\UPSlabelStruct\Ups_labelImageFormatCodeType|null
     */
    public function getImageFormat()
    {
        return $this->ImageFormat;
    }
    /**
     * Set ImageFormat value
     * @param \Ups_label\UPSlabelStruct\Ups_labelImageFormatCodeType $imageFormat
     * @return \Ups_label\UPSlabelStruct\Ups_labelFormImageType
     */
    public function setImageFormat(\Ups_label\UPSlabelStruct\Ups_labelImageFormatCodeType $imageFormat = null)
    {
        $this->ImageFormat = $imageFormat;
        return $this;
    }
    /**
     * Get GraphicImage value
     * @return string|null
     */
    public function getGraphicImage()
    {
        return $this->GraphicImage;
    }
    /**
     * Set GraphicImage value
     * @param string $graphicImage
     * @return \Ups_label\UPSlabelStruct\Ups_labelFormImageType
     */
    public function setGraphicImage($graphicImage = null)
    {
        // validation for constraint: string
        if (!is_null($graphicImage) && !is_string($graphicImage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($graphicImage, true), gettype($graphicImage)), __LINE__);
        }
        $this->GraphicImage = $graphicImage;
        return $this;
    }
}
