<?php

namespace Ups_label\UPSlabelService;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Process UPSlabelService
 * @package Ups_label
 * @subpackage Services
 */
class Ups_labelProcess extends AbstractSoapClientBase
{
    /**
     * Sets the UPSSecurity SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \Ups_label\UPSlabelStruct\Ups_labelUPSSecurity $uPSSecurity
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderUPSSecurity(\Ups_label\UPSlabelStruct\Ups_labelUPSSecurity $uPSSecurity, $nameSpace = 'http://www.ups.com/XMLSchema/XOLTWS/UPSS/v1.0', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'UPSSecurity', $uPSSecurity, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named ProcessLabelRecovery
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: UPSSecurity
     * - SOAPHeaderNamespaces: http://www.ups.com/XMLSchema/XOLTWS/UPSS/v1.0
     * - SOAPHeaderTypes: \Ups_label\UPSlabelStruct\Ups_labelUPSSecurity
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Ups_label\UPSlabelStruct\Ups_labelLabelRecoveryRequest $body
     * @return \Ups_label\UPSlabelStruct\Ups_labelLabelRecoveryResponse|bool
     */
    public function ProcessLabelRecovery(\Ups_label\UPSlabelStruct\Ups_labelLabelRecoveryRequest $body)
    {
        try {
            $this->setResult($this->getSoapClient()->ProcessLabelRecovery($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Ups_label\UPSlabelStruct\Ups_labelLabelRecoveryResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
