<?php

namespace Ups_label\UPSlabelStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LabelSpecificationType UPSlabelStruct
 * @package Ups_label
 * @subpackage Structs
 */
class Ups_labelLabelSpecificationType extends AbstractStructBase
{
    /**
     * The HTTPUserAgent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $HTTPUserAgent;
    /**
     * The LabelImageFormat
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_label\UPSlabelStruct\Ups_labelLabelImageFormatType
     */
    public $LabelImageFormat;
    /**
     * The LabelStockSize
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_label\UPSlabelStruct\Ups_labelLabelStockSizeType
     */
    public $LabelStockSize;
    /**
     * Constructor method for LabelSpecificationType
     * @uses Ups_labelLabelSpecificationType::setHTTPUserAgent()
     * @uses Ups_labelLabelSpecificationType::setLabelImageFormat()
     * @uses Ups_labelLabelSpecificationType::setLabelStockSize()
     * @param string $hTTPUserAgent
     * @param \Ups_label\UPSlabelStruct\Ups_labelLabelImageFormatType $labelImageFormat
     * @param \Ups_label\UPSlabelStruct\Ups_labelLabelStockSizeType $labelStockSize
     */
    public function __construct($hTTPUserAgent = null, \Ups_label\UPSlabelStruct\Ups_labelLabelImageFormatType $labelImageFormat = null, \Ups_label\UPSlabelStruct\Ups_labelLabelStockSizeType $labelStockSize = null)
    {
        $this
            ->setHTTPUserAgent($hTTPUserAgent)
            ->setLabelImageFormat($labelImageFormat)
            ->setLabelStockSize($labelStockSize);
    }
    /**
     * Get HTTPUserAgent value
     * @return string|null
     */
    public function getHTTPUserAgent()
    {
        return $this->HTTPUserAgent;
    }
    /**
     * Set HTTPUserAgent value
     * @param string $hTTPUserAgent
     * @return \Ups_label\UPSlabelStruct\Ups_labelLabelSpecificationType
     */
    public function setHTTPUserAgent($hTTPUserAgent = null)
    {
        // validation for constraint: string
        if (!is_null($hTTPUserAgent) && !is_string($hTTPUserAgent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hTTPUserAgent, true), gettype($hTTPUserAgent)), __LINE__);
        }
        $this->HTTPUserAgent = $hTTPUserAgent;
        return $this;
    }
    /**
     * Get LabelImageFormat value
     * @return \Ups_label\UPSlabelStruct\Ups_labelLabelImageFormatType|null
     */
    public function getLabelImageFormat()
    {
        return $this->LabelImageFormat;
    }
    /**
     * Set LabelImageFormat value
     * @param \Ups_label\UPSlabelStruct\Ups_labelLabelImageFormatType $labelImageFormat
     * @return \Ups_label\UPSlabelStruct\Ups_labelLabelSpecificationType
     */
    public function setLabelImageFormat(\Ups_label\UPSlabelStruct\Ups_labelLabelImageFormatType $labelImageFormat = null)
    {
        $this->LabelImageFormat = $labelImageFormat;
        return $this;
    }
    /**
     * Get LabelStockSize value
     * @return \Ups_label\UPSlabelStruct\Ups_labelLabelStockSizeType|null
     */
    public function getLabelStockSize()
    {
        return $this->LabelStockSize;
    }
    /**
     * Set LabelStockSize value
     * @param \Ups_label\UPSlabelStruct\Ups_labelLabelStockSizeType $labelStockSize
     * @return \Ups_label\UPSlabelStruct\Ups_labelLabelSpecificationType
     */
    public function setLabelStockSize(\Ups_label\UPSlabelStruct\Ups_labelLabelStockSizeType $labelStockSize = null)
    {
        $this->LabelStockSize = $labelStockSize;
        return $this;
    }
}
