<?php

namespace Ups_label\UPSlabelStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ImageType UPSlabelStruct
 * @package Ups_label
 * @subpackage Structs
 */
class Ups_labelImageType extends AbstractStructBase
{
    /**
     * The ImageFormat
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_label\UPSlabelStruct\Ups_labelLabelImageFormatType
     */
    public $ImageFormat;
    /**
     * The GraphicImage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $GraphicImage;
    /**
     * Constructor method for ImageType
     * @uses Ups_labelImageType::setImageFormat()
     * @uses Ups_labelImageType::setGraphicImage()
     * @param \Ups_label\UPSlabelStruct\Ups_labelLabelImageFormatType $imageFormat
     * @param string $graphicImage
     */
    public function __construct(\Ups_label\UPSlabelStruct\Ups_labelLabelImageFormatType $imageFormat = null, $graphicImage = null)
    {
        $this
            ->setImageFormat($imageFormat)
            ->setGraphicImage($graphicImage);
    }
    /**
     * Get ImageFormat value
     * @return \Ups_label\UPSlabelStruct\Ups_labelLabelImageFormatType|null
     */
    public function getImageFormat()
    {
        return $this->ImageFormat;
    }
    /**
     * Set ImageFormat value
     * @param \Ups_label\UPSlabelStruct\Ups_labelLabelImageFormatType $imageFormat
     * @return \Ups_label\UPSlabelStruct\Ups_labelImageType
     */
    public function setImageFormat(\Ups_label\UPSlabelStruct\Ups_labelLabelImageFormatType $imageFormat = null)
    {
        $this->ImageFormat = $imageFormat;
        return $this;
    }
    /**
     * Get GraphicImage value
     * @return string|null
     */
    public function getGraphicImage()
    {
        return $this->GraphicImage;
    }
    /**
     * Set GraphicImage value
     * @param string $graphicImage
     * @return \Ups_label\UPSlabelStruct\Ups_labelImageType
     */
    public function setGraphicImage($graphicImage = null)
    {
        // validation for constraint: string
        if (!is_null($graphicImage) && !is_string($graphicImage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($graphicImage, true), gettype($graphicImage)), __LINE__);
        }
        $this->GraphicImage = $graphicImage;
        return $this;
    }
}
