<?php

namespace Ups_label\UPSlabelStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TrackingCandidateType UPSlabelStruct
 * @package Ups_label
 * @subpackage Structs
 */
class Ups_labelTrackingCandidateType extends AbstractStructBase
{
    /**
     * The TrackingNumber
     * @var string
     */
    public $TrackingNumber;
    /**
     * The DestinationPostalCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DestinationPostalCode;
    /**
     * The DestinationCountryCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DestinationCountryCode;
    /**
     * The PickupDateRange
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_label\UPSlabelStruct\Ups_labelPickupDateRangeType
     */
    public $PickupDateRange;
    /**
     * Constructor method for TrackingCandidateType
     * @uses Ups_labelTrackingCandidateType::setTrackingNumber()
     * @uses Ups_labelTrackingCandidateType::setDestinationPostalCode()
     * @uses Ups_labelTrackingCandidateType::setDestinationCountryCode()
     * @uses Ups_labelTrackingCandidateType::setPickupDateRange()
     * @param string $trackingNumber
     * @param string $destinationPostalCode
     * @param string $destinationCountryCode
     * @param \Ups_label\UPSlabelStruct\Ups_labelPickupDateRangeType $pickupDateRange
     */
    public function __construct($trackingNumber = null, $destinationPostalCode = null, $destinationCountryCode = null, \Ups_label\UPSlabelStruct\Ups_labelPickupDateRangeType $pickupDateRange = null)
    {
        $this
            ->setTrackingNumber($trackingNumber)
            ->setDestinationPostalCode($destinationPostalCode)
            ->setDestinationCountryCode($destinationCountryCode)
            ->setPickupDateRange($pickupDateRange);
    }
    /**
     * Get TrackingNumber value
     * @return string|null
     */
    public function getTrackingNumber()
    {
        return $this->TrackingNumber;
    }
    /**
     * Set TrackingNumber value
     * @param string $trackingNumber
     * @return \Ups_label\UPSlabelStruct\Ups_labelTrackingCandidateType
     */
    public function setTrackingNumber($trackingNumber = null)
    {
        // validation for constraint: string
        if (!is_null($trackingNumber) && !is_string($trackingNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trackingNumber, true), gettype($trackingNumber)), __LINE__);
        }
        $this->TrackingNumber = $trackingNumber;
        return $this;
    }
    /**
     * Get DestinationPostalCode value
     * @return string|null
     */
    public function getDestinationPostalCode()
    {
        return $this->DestinationPostalCode;
    }
    /**
     * Set DestinationPostalCode value
     * @param string $destinationPostalCode
     * @return \Ups_label\UPSlabelStruct\Ups_labelTrackingCandidateType
     */
    public function setDestinationPostalCode($destinationPostalCode = null)
    {
        // validation for constraint: string
        if (!is_null($destinationPostalCode) && !is_string($destinationPostalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationPostalCode, true), gettype($destinationPostalCode)), __LINE__);
        }
        $this->DestinationPostalCode = $destinationPostalCode;
        return $this;
    }
    /**
     * Get DestinationCountryCode value
     * @return string|null
     */
    public function getDestinationCountryCode()
    {
        return $this->DestinationCountryCode;
    }
    /**
     * Set DestinationCountryCode value
     * @param string $destinationCountryCode
     * @return \Ups_label\UPSlabelStruct\Ups_labelTrackingCandidateType
     */
    public function setDestinationCountryCode($destinationCountryCode = null)
    {
        // validation for constraint: string
        if (!is_null($destinationCountryCode) && !is_string($destinationCountryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationCountryCode, true), gettype($destinationCountryCode)), __LINE__);
        }
        $this->DestinationCountryCode = $destinationCountryCode;
        return $this;
    }
    /**
     * Get PickupDateRange value
     * @return \Ups_label\UPSlabelStruct\Ups_labelPickupDateRangeType|null
     */
    public function getPickupDateRange()
    {
        return $this->PickupDateRange;
    }
    /**
     * Set PickupDateRange value
     * @param \Ups_label\UPSlabelStruct\Ups_labelPickupDateRangeType $pickupDateRange
     * @return \Ups_label\UPSlabelStruct\Ups_labelTrackingCandidateType
     */
    public function setPickupDateRange(\Ups_label\UPSlabelStruct\Ups_labelPickupDateRangeType $pickupDateRange = null)
    {
        $this->PickupDateRange = $pickupDateRange;
        return $this;
    }
}
