<?php

namespace Ups_label\UPSlabelStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResponseType UPSlabelStruct
 * @package Ups_label
 * @subpackage Structs
 */
class Ups_labelResponseType extends AbstractStructBase
{
    /**
     * The ResponseStatus
     * @var \Ups_label\UPSlabelStruct\Ups_labelCodeDescriptionType
     */
    public $ResponseStatus;
    /**
     * The Alert
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Ups_label\UPSlabelStruct\Ups_labelCodeDescriptionType[]
     */
    public $Alert;
    /**
     * The AlertDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Ups_label\UPSlabelStruct\Ups_labelDetailType[]
     */
    public $AlertDetail;
    /**
     * The TransactionReference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_label\UPSlabelStruct\Ups_labelTransactionReferenceType
     */
    public $TransactionReference;
    /**
     * Constructor method for ResponseType
     * @uses Ups_labelResponseType::setResponseStatus()
     * @uses Ups_labelResponseType::setAlert()
     * @uses Ups_labelResponseType::setAlertDetail()
     * @uses Ups_labelResponseType::setTransactionReference()
     * @param \Ups_label\UPSlabelStruct\Ups_labelCodeDescriptionType $responseStatus
     * @param \Ups_label\UPSlabelStruct\Ups_labelCodeDescriptionType[] $alert
     * @param \Ups_label\UPSlabelStruct\Ups_labelDetailType[] $alertDetail
     * @param \Ups_label\UPSlabelStruct\Ups_labelTransactionReferenceType $transactionReference
     */
    public function __construct(\Ups_label\UPSlabelStruct\Ups_labelCodeDescriptionType $responseStatus = null, array $alert = array(), array $alertDetail = array(), \Ups_label\UPSlabelStruct\Ups_labelTransactionReferenceType $transactionReference = null)
    {
        $this
            ->setResponseStatus($responseStatus)
            ->setAlert($alert)
            ->setAlertDetail($alertDetail)
            ->setTransactionReference($transactionReference);
    }
    /**
     * Get ResponseStatus value
     * @return \Ups_label\UPSlabelStruct\Ups_labelCodeDescriptionType|null
     */
    public function getResponseStatus()
    {
        return $this->ResponseStatus;
    }
    /**
     * Set ResponseStatus value
     * @param \Ups_label\UPSlabelStruct\Ups_labelCodeDescriptionType $responseStatus
     * @return \Ups_label\UPSlabelStruct\Ups_labelResponseType
     */
    public function setResponseStatus(\Ups_label\UPSlabelStruct\Ups_labelCodeDescriptionType $responseStatus = null)
    {
        $this->ResponseStatus = $responseStatus;
        return $this;
    }
    /**
     * Get Alert value
     * @return \Ups_label\UPSlabelStruct\Ups_labelCodeDescriptionType[]|null
     */
    public function getAlert()
    {
        return $this->Alert;
    }
    /**
     * This method is responsible for validating the values passed to the setAlert method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAlert method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAlertForArrayConstraintsFromSetAlert(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $responseTypeAlertItem) {
            // validation for constraint: itemType
            if (!$responseTypeAlertItem instanceof \Ups_label\UPSlabelStruct\Ups_labelCodeDescriptionType) {
                $invalidValues[] = is_object($responseTypeAlertItem) ? get_class($responseTypeAlertItem) : sprintf('%s(%s)', gettype($responseTypeAlertItem), var_export($responseTypeAlertItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Alert property can only contain items of type \Ups_label\UPSlabelStruct\Ups_labelCodeDescriptionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Alert value
     * @throws \InvalidArgumentException
     * @param \Ups_label\UPSlabelStruct\Ups_labelCodeDescriptionType[] $alert
     * @return \Ups_label\UPSlabelStruct\Ups_labelResponseType
     */
    public function setAlert(array $alert = array())
    {
        // validation for constraint: array
        if ('' !== ($alertArrayErrorMessage = self::validateAlertForArrayConstraintsFromSetAlert($alert))) {
            throw new \InvalidArgumentException($alertArrayErrorMessage, __LINE__);
        }
        $this->Alert = $alert;
        return $this;
    }
    /**
     * Add item to Alert value
     * @throws \InvalidArgumentException
     * @param \Ups_label\UPSlabelStruct\Ups_labelCodeDescriptionType $item
     * @return \Ups_label\UPSlabelStruct\Ups_labelResponseType
     */
    public function addToAlert(\Ups_label\UPSlabelStruct\Ups_labelCodeDescriptionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups_label\UPSlabelStruct\Ups_labelCodeDescriptionType) {
            throw new \InvalidArgumentException(sprintf('The Alert property can only contain items of type \Ups_label\UPSlabelStruct\Ups_labelCodeDescriptionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Alert[] = $item;
        return $this;
    }
    /**
     * Get AlertDetail value
     * @return \Ups_label\UPSlabelStruct\Ups_labelDetailType[]|null
     */
    public function getAlertDetail()
    {
        return $this->AlertDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setAlertDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAlertDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAlertDetailForArrayConstraintsFromSetAlertDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $responseTypeAlertDetailItem) {
            // validation for constraint: itemType
            if (!$responseTypeAlertDetailItem instanceof \Ups_label\UPSlabelStruct\Ups_labelDetailType) {
                $invalidValues[] = is_object($responseTypeAlertDetailItem) ? get_class($responseTypeAlertDetailItem) : sprintf('%s(%s)', gettype($responseTypeAlertDetailItem), var_export($responseTypeAlertDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AlertDetail property can only contain items of type \Ups_label\UPSlabelStruct\Ups_labelDetailType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AlertDetail value
     * @throws \InvalidArgumentException
     * @param \Ups_label\UPSlabelStruct\Ups_labelDetailType[] $alertDetail
     * @return \Ups_label\UPSlabelStruct\Ups_labelResponseType
     */
    public function setAlertDetail(array $alertDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($alertDetailArrayErrorMessage = self::validateAlertDetailForArrayConstraintsFromSetAlertDetail($alertDetail))) {
            throw new \InvalidArgumentException($alertDetailArrayErrorMessage, __LINE__);
        }
        $this->AlertDetail = $alertDetail;
        return $this;
    }
    /**
     * Add item to AlertDetail value
     * @throws \InvalidArgumentException
     * @param \Ups_label\UPSlabelStruct\Ups_labelDetailType $item
     * @return \Ups_label\UPSlabelStruct\Ups_labelResponseType
     */
    public function addToAlertDetail(\Ups_label\UPSlabelStruct\Ups_labelDetailType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups_label\UPSlabelStruct\Ups_labelDetailType) {
            throw new \InvalidArgumentException(sprintf('The AlertDetail property can only contain items of type \Ups_label\UPSlabelStruct\Ups_labelDetailType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AlertDetail[] = $item;
        return $this;
    }
    /**
     * Get TransactionReference value
     * @return \Ups_label\UPSlabelStruct\Ups_labelTransactionReferenceType|null
     */
    public function getTransactionReference()
    {
        return $this->TransactionReference;
    }
    /**
     * Set TransactionReference value
     * @param \Ups_label\UPSlabelStruct\Ups_labelTransactionReferenceType $transactionReference
     * @return \Ups_label\UPSlabelStruct\Ups_labelResponseType
     */
    public function setTransactionReference(\Ups_label\UPSlabelStruct\Ups_labelTransactionReferenceType $transactionReference = null)
    {
        $this->TransactionReference = $transactionReference;
        return $this;
    }
}
