<?php

namespace Ups_label\UPSlabelStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LabelResultsType UPSlabelStruct
 * @package Ups_label
 * @subpackage Structs
 */
class Ups_labelLabelResultsType extends AbstractStructBase
{
    /**
     * The TrackingNumber
     * @var string
     */
    public $TrackingNumber;
    /**
     * The LabelImage
     * @var \Ups_label\UPSlabelStruct\Ups_labelLabelImageType
     */
    public $LabelImage;
    /**
     * The Receipt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_label\UPSlabelStruct\Ups_labelReceiptType
     */
    public $Receipt;
    /**
     * The Form
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_label\UPSlabelStruct\Ups_labelFormType
     */
    public $Form;
    /**
     * The MailInnovationsTrackingNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $MailInnovationsTrackingNumber;
    /**
     * The MailInnovationsLabelImage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_label\UPSlabelStruct\Ups_labelLabelImageType
     */
    public $MailInnovationsLabelImage;
    /**
     * Constructor method for LabelResultsType
     * @uses Ups_labelLabelResultsType::setTrackingNumber()
     * @uses Ups_labelLabelResultsType::setLabelImage()
     * @uses Ups_labelLabelResultsType::setReceipt()
     * @uses Ups_labelLabelResultsType::setForm()
     * @uses Ups_labelLabelResultsType::setMailInnovationsTrackingNumber()
     * @uses Ups_labelLabelResultsType::setMailInnovationsLabelImage()
     * @param string $trackingNumber
     * @param \Ups_label\UPSlabelStruct\Ups_labelLabelImageType $labelImage
     * @param \Ups_label\UPSlabelStruct\Ups_labelReceiptType $receipt
     * @param \Ups_label\UPSlabelStruct\Ups_labelFormType $form
     * @param string $mailInnovationsTrackingNumber
     * @param \Ups_label\UPSlabelStruct\Ups_labelLabelImageType $mailInnovationsLabelImage
     */
    public function __construct($trackingNumber = null, \Ups_label\UPSlabelStruct\Ups_labelLabelImageType $labelImage = null, \Ups_label\UPSlabelStruct\Ups_labelReceiptType $receipt = null, \Ups_label\UPSlabelStruct\Ups_labelFormType $form = null, $mailInnovationsTrackingNumber = null, \Ups_label\UPSlabelStruct\Ups_labelLabelImageType $mailInnovationsLabelImage = null)
    {
        $this
            ->setTrackingNumber($trackingNumber)
            ->setLabelImage($labelImage)
            ->setReceipt($receipt)
            ->setForm($form)
            ->setMailInnovationsTrackingNumber($mailInnovationsTrackingNumber)
            ->setMailInnovationsLabelImage($mailInnovationsLabelImage);
    }
    /**
     * Get TrackingNumber value
     * @return string|null
     */
    public function getTrackingNumber()
    {
        return $this->TrackingNumber;
    }
    /**
     * Set TrackingNumber value
     * @param string $trackingNumber
     * @return \Ups_label\UPSlabelStruct\Ups_labelLabelResultsType
     */
    public function setTrackingNumber($trackingNumber = null)
    {
        // validation for constraint: string
        if (!is_null($trackingNumber) && !is_string($trackingNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trackingNumber, true), gettype($trackingNumber)), __LINE__);
        }
        $this->TrackingNumber = $trackingNumber;
        return $this;
    }
    /**
     * Get LabelImage value
     * @return \Ups_label\UPSlabelStruct\Ups_labelLabelImageType|null
     */
    public function getLabelImage()
    {
        return $this->LabelImage;
    }
    /**
     * Set LabelImage value
     * @param \Ups_label\UPSlabelStruct\Ups_labelLabelImageType $labelImage
     * @return \Ups_label\UPSlabelStruct\Ups_labelLabelResultsType
     */
    public function setLabelImage(\Ups_label\UPSlabelStruct\Ups_labelLabelImageType $labelImage = null)
    {
        $this->LabelImage = $labelImage;
        return $this;
    }
    /**
     * Get Receipt value
     * @return \Ups_label\UPSlabelStruct\Ups_labelReceiptType|null
     */
    public function getReceipt()
    {
        return $this->Receipt;
    }
    /**
     * Set Receipt value
     * @param \Ups_label\UPSlabelStruct\Ups_labelReceiptType $receipt
     * @return \Ups_label\UPSlabelStruct\Ups_labelLabelResultsType
     */
    public function setReceipt(\Ups_label\UPSlabelStruct\Ups_labelReceiptType $receipt = null)
    {
        $this->Receipt = $receipt;
        return $this;
    }
    /**
     * Get Form value
     * @return \Ups_label\UPSlabelStruct\Ups_labelFormType|null
     */
    public function getForm()
    {
        return $this->Form;
    }
    /**
     * Set Form value
     * @param \Ups_label\UPSlabelStruct\Ups_labelFormType $form
     * @return \Ups_label\UPSlabelStruct\Ups_labelLabelResultsType
     */
    public function setForm(\Ups_label\UPSlabelStruct\Ups_labelFormType $form = null)
    {
        $this->Form = $form;
        return $this;
    }
    /**
     * Get MailInnovationsTrackingNumber value
     * @return string|null
     */
    public function getMailInnovationsTrackingNumber()
    {
        return $this->MailInnovationsTrackingNumber;
    }
    /**
     * Set MailInnovationsTrackingNumber value
     * @param string $mailInnovationsTrackingNumber
     * @return \Ups_label\UPSlabelStruct\Ups_labelLabelResultsType
     */
    public function setMailInnovationsTrackingNumber($mailInnovationsTrackingNumber = null)
    {
        // validation for constraint: string
        if (!is_null($mailInnovationsTrackingNumber) && !is_string($mailInnovationsTrackingNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mailInnovationsTrackingNumber, true), gettype($mailInnovationsTrackingNumber)), __LINE__);
        }
        $this->MailInnovationsTrackingNumber = $mailInnovationsTrackingNumber;
        return $this;
    }
    /**
     * Get MailInnovationsLabelImage value
     * @return \Ups_label\UPSlabelStruct\Ups_labelLabelImageType|null
     */
    public function getMailInnovationsLabelImage()
    {
        return $this->MailInnovationsLabelImage;
    }
    /**
     * Set MailInnovationsLabelImage value
     * @param \Ups_label\UPSlabelStruct\Ups_labelLabelImageType $mailInnovationsLabelImage
     * @return \Ups_label\UPSlabelStruct\Ups_labelLabelResultsType
     */
    public function setMailInnovationsLabelImage(\Ups_label\UPSlabelStruct\Ups_labelLabelImageType $mailInnovationsLabelImage = null)
    {
        $this->MailInnovationsLabelImage = $mailInnovationsLabelImage;
        return $this;
    }
}
