<?php

namespace Ups_label\UPSlabelStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ElementLevelInformationType UPSlabelStruct
 * @package Ups_label
 * @subpackage Structs
 */
class Ups_labelElementLevelInformationType extends AbstractStructBase
{
    /**
     * The Level
     * @var string
     */
    public $Level;
    /**
     * The ElementIdentifier
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Ups_label\UPSlabelStruct\Ups_labelElementIdentifierType[]
     */
    public $ElementIdentifier;
    /**
     * Constructor method for ElementLevelInformationType
     * @uses Ups_labelElementLevelInformationType::setLevel()
     * @uses Ups_labelElementLevelInformationType::setElementIdentifier()
     * @param string $level
     * @param \Ups_label\UPSlabelStruct\Ups_labelElementIdentifierType[] $elementIdentifier
     */
    public function __construct($level = null, array $elementIdentifier = array())
    {
        $this
            ->setLevel($level)
            ->setElementIdentifier($elementIdentifier);
    }
    /**
     * Get Level value
     * @return string|null
     */
    public function getLevel()
    {
        return $this->Level;
    }
    /**
     * Set Level value
     * @param string $level
     * @return \Ups_label\UPSlabelStruct\Ups_labelElementLevelInformationType
     */
    public function setLevel($level = null)
    {
        // validation for constraint: string
        if (!is_null($level) && !is_string($level)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($level, true), gettype($level)), __LINE__);
        }
        $this->Level = $level;
        return $this;
    }
    /**
     * Get ElementIdentifier value
     * @return \Ups_label\UPSlabelStruct\Ups_labelElementIdentifierType[]|null
     */
    public function getElementIdentifier()
    {
        return $this->ElementIdentifier;
    }
    /**
     * This method is responsible for validating the values passed to the setElementIdentifier method
     * This method is willingly generated in order to preserve the one-line inline validation within the setElementIdentifier method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateElementIdentifierForArrayConstraintsFromSetElementIdentifier(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $elementLevelInformationTypeElementIdentifierItem) {
            // validation for constraint: itemType
            if (!$elementLevelInformationTypeElementIdentifierItem instanceof \Ups_label\UPSlabelStruct\Ups_labelElementIdentifierType) {
                $invalidValues[] = is_object($elementLevelInformationTypeElementIdentifierItem) ? get_class($elementLevelInformationTypeElementIdentifierItem) : sprintf('%s(%s)', gettype($elementLevelInformationTypeElementIdentifierItem), var_export($elementLevelInformationTypeElementIdentifierItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ElementIdentifier property can only contain items of type \Ups_label\UPSlabelStruct\Ups_labelElementIdentifierType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ElementIdentifier value
     * @throws \InvalidArgumentException
     * @param \Ups_label\UPSlabelStruct\Ups_labelElementIdentifierType[] $elementIdentifier
     * @return \Ups_label\UPSlabelStruct\Ups_labelElementLevelInformationType
     */
    public function setElementIdentifier(array $elementIdentifier = array())
    {
        // validation for constraint: array
        if ('' !== ($elementIdentifierArrayErrorMessage = self::validateElementIdentifierForArrayConstraintsFromSetElementIdentifier($elementIdentifier))) {
            throw new \InvalidArgumentException($elementIdentifierArrayErrorMessage, __LINE__);
        }
        $this->ElementIdentifier = $elementIdentifier;
        return $this;
    }
    /**
     * Add item to ElementIdentifier value
     * @throws \InvalidArgumentException
     * @param \Ups_label\UPSlabelStruct\Ups_labelElementIdentifierType $item
     * @return \Ups_label\UPSlabelStruct\Ups_labelElementLevelInformationType
     */
    public function addToElementIdentifier(\Ups_label\UPSlabelStruct\Ups_labelElementIdentifierType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups_label\UPSlabelStruct\Ups_labelElementIdentifierType) {
            throw new \InvalidArgumentException(sprintf('The ElementIdentifier property can only contain items of type \Ups_label\UPSlabelStruct\Ups_labelElementIdentifierType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ElementIdentifier[] = $item;
        return $this;
    }
}
