<?php

namespace Ups_label\UPSlabelStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LabelRecoveryRequest UPSlabelStruct
 * @package Ups_label
 * @subpackage Structs
 */
class Ups_labelLabelRecoveryRequest extends AbstractStructBase
{
    /**
     * The Request
     * Meta information extracted from the WSDL
     * - ref: common:Request
     * @var \Ups_label\UPSlabelStruct\Ups_labelRequestType
     */
    public $Request;
    /**
     * The LabelSpecification
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_label\UPSlabelStruct\Ups_labelLabelSpecificationType
     */
    public $LabelSpecification;
    /**
     * The Translate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_label\UPSlabelStruct\Ups_labelTranslateType
     */
    public $Translate;
    /**
     * The LabelDelivery
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_label\UPSlabelStruct\Ups_labelLabelDeliveryType
     */
    public $LabelDelivery;
    /**
     * The TrackingNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TrackingNumber;
    /**
     * The MailInnovationsTrackingNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $MailInnovationsTrackingNumber;
    /**
     * The ReferenceValues
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_label\UPSlabelStruct\Ups_labelReferenceValuesType
     */
    public $ReferenceValues;
    /**
     * The UPSPremiumCareForm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_label\UPSlabelStruct\Ups_labelLRUPSPremiumCareFormType
     */
    public $UPSPremiumCareForm;
    /**
     * Constructor method for LabelRecoveryRequest
     * @uses Ups_labelLabelRecoveryRequest::setRequest()
     * @uses Ups_labelLabelRecoveryRequest::setLabelSpecification()
     * @uses Ups_labelLabelRecoveryRequest::setTranslate()
     * @uses Ups_labelLabelRecoveryRequest::setLabelDelivery()
     * @uses Ups_labelLabelRecoveryRequest::setTrackingNumber()
     * @uses Ups_labelLabelRecoveryRequest::setMailInnovationsTrackingNumber()
     * @uses Ups_labelLabelRecoveryRequest::setReferenceValues()
     * @uses Ups_labelLabelRecoveryRequest::setUPSPremiumCareForm()
     * @param \Ups_label\UPSlabelStruct\Ups_labelRequestType $request
     * @param \Ups_label\UPSlabelStruct\Ups_labelLabelSpecificationType $labelSpecification
     * @param \Ups_label\UPSlabelStruct\Ups_labelTranslateType $translate
     * @param \Ups_label\UPSlabelStruct\Ups_labelLabelDeliveryType $labelDelivery
     * @param string $trackingNumber
     * @param string $mailInnovationsTrackingNumber
     * @param \Ups_label\UPSlabelStruct\Ups_labelReferenceValuesType $referenceValues
     * @param \Ups_label\UPSlabelStruct\Ups_labelLRUPSPremiumCareFormType $uPSPremiumCareForm
     */
    public function __construct(\Ups_label\UPSlabelStruct\Ups_labelRequestType $request = null, \Ups_label\UPSlabelStruct\Ups_labelLabelSpecificationType $labelSpecification = null, \Ups_label\UPSlabelStruct\Ups_labelTranslateType $translate = null, \Ups_label\UPSlabelStruct\Ups_labelLabelDeliveryType $labelDelivery = null, $trackingNumber = null, $mailInnovationsTrackingNumber = null, \Ups_label\UPSlabelStruct\Ups_labelReferenceValuesType $referenceValues = null, \Ups_label\UPSlabelStruct\Ups_labelLRUPSPremiumCareFormType $uPSPremiumCareForm = null)
    {
        $this
            ->setRequest($request)
            ->setLabelSpecification($labelSpecification)
            ->setTranslate($translate)
            ->setLabelDelivery($labelDelivery)
            ->setTrackingNumber($trackingNumber)
            ->setMailInnovationsTrackingNumber($mailInnovationsTrackingNumber)
            ->setReferenceValues($referenceValues)
            ->setUPSPremiumCareForm($uPSPremiumCareForm);
    }
    /**
     * Get Request value
     * @return \Ups_label\UPSlabelStruct\Ups_labelRequestType|null
     */
    public function getRequest()
    {
        return $this->Request;
    }
    /**
     * Set Request value
     * @param \Ups_label\UPSlabelStruct\Ups_labelRequestType $request
     * @return \Ups_label\UPSlabelStruct\Ups_labelLabelRecoveryRequest
     */
    public function setRequest(\Ups_label\UPSlabelStruct\Ups_labelRequestType $request = null)
    {
        $this->Request = $request;
        return $this;
    }
    /**
     * Get LabelSpecification value
     * @return \Ups_label\UPSlabelStruct\Ups_labelLabelSpecificationType|null
     */
    public function getLabelSpecification()
    {
        return $this->LabelSpecification;
    }
    /**
     * Set LabelSpecification value
     * @param \Ups_label\UPSlabelStruct\Ups_labelLabelSpecificationType $labelSpecification
     * @return \Ups_label\UPSlabelStruct\Ups_labelLabelRecoveryRequest
     */
    public function setLabelSpecification(\Ups_label\UPSlabelStruct\Ups_labelLabelSpecificationType $labelSpecification = null)
    {
        $this->LabelSpecification = $labelSpecification;
        return $this;
    }
    /**
     * Get Translate value
     * @return \Ups_label\UPSlabelStruct\Ups_labelTranslateType|null
     */
    public function getTranslate()
    {
        return $this->Translate;
    }
    /**
     * Set Translate value
     * @param \Ups_label\UPSlabelStruct\Ups_labelTranslateType $translate
     * @return \Ups_label\UPSlabelStruct\Ups_labelLabelRecoveryRequest
     */
    public function setTranslate(\Ups_label\UPSlabelStruct\Ups_labelTranslateType $translate = null)
    {
        $this->Translate = $translate;
        return $this;
    }
    /**
     * Get LabelDelivery value
     * @return \Ups_label\UPSlabelStruct\Ups_labelLabelDeliveryType|null
     */
    public function getLabelDelivery()
    {
        return $this->LabelDelivery;
    }
    /**
     * Set LabelDelivery value
     * @param \Ups_label\UPSlabelStruct\Ups_labelLabelDeliveryType $labelDelivery
     * @return \Ups_label\UPSlabelStruct\Ups_labelLabelRecoveryRequest
     */
    public function setLabelDelivery(\Ups_label\UPSlabelStruct\Ups_labelLabelDeliveryType $labelDelivery = null)
    {
        $this->LabelDelivery = $labelDelivery;
        return $this;
    }
    /**
     * Get TrackingNumber value
     * @return string|null
     */
    public function getTrackingNumber()
    {
        return $this->TrackingNumber;
    }
    /**
     * Set TrackingNumber value
     * @param string $trackingNumber
     * @return \Ups_label\UPSlabelStruct\Ups_labelLabelRecoveryRequest
     */
    public function setTrackingNumber($trackingNumber = null)
    {
        // validation for constraint: string
        if (!is_null($trackingNumber) && !is_string($trackingNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trackingNumber, true), gettype($trackingNumber)), __LINE__);
        }
        $this->TrackingNumber = $trackingNumber;
        return $this;
    }
    /**
     * Get MailInnovationsTrackingNumber value
     * @return string|null
     */
    public function getMailInnovationsTrackingNumber()
    {
        return $this->MailInnovationsTrackingNumber;
    }
    /**
     * Set MailInnovationsTrackingNumber value
     * @param string $mailInnovationsTrackingNumber
     * @return \Ups_label\UPSlabelStruct\Ups_labelLabelRecoveryRequest
     */
    public function setMailInnovationsTrackingNumber($mailInnovationsTrackingNumber = null)
    {
        // validation for constraint: string
        if (!is_null($mailInnovationsTrackingNumber) && !is_string($mailInnovationsTrackingNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mailInnovationsTrackingNumber, true), gettype($mailInnovationsTrackingNumber)), __LINE__);
        }
        $this->MailInnovationsTrackingNumber = $mailInnovationsTrackingNumber;
        return $this;
    }
    /**
     * Get ReferenceValues value
     * @return \Ups_label\UPSlabelStruct\Ups_labelReferenceValuesType|null
     */
    public function getReferenceValues()
    {
        return $this->ReferenceValues;
    }
    /**
     * Set ReferenceValues value
     * @param \Ups_label\UPSlabelStruct\Ups_labelReferenceValuesType $referenceValues
     * @return \Ups_label\UPSlabelStruct\Ups_labelLabelRecoveryRequest
     */
    public function setReferenceValues(\Ups_label\UPSlabelStruct\Ups_labelReferenceValuesType $referenceValues = null)
    {
        $this->ReferenceValues = $referenceValues;
        return $this;
    }
    /**
     * Get UPSPremiumCareForm value
     * @return \Ups_label\UPSlabelStruct\Ups_labelLRUPSPremiumCareFormType|null
     */
    public function getUPSPremiumCareForm()
    {
        return $this->UPSPremiumCareForm;
    }
    /**
     * Set UPSPremiumCareForm value
     * @param \Ups_label\UPSlabelStruct\Ups_labelLRUPSPremiumCareFormType $uPSPremiumCareForm
     * @return \Ups_label\UPSlabelStruct\Ups_labelLabelRecoveryRequest
     */
    public function setUPSPremiumCareForm(\Ups_label\UPSlabelStruct\Ups_labelLRUPSPremiumCareFormType $uPSPremiumCareForm = null)
    {
        $this->UPSPremiumCareForm = $uPSPremiumCareForm;
        return $this;
    }
}
