<?php

namespace Ups_rates\UPSratesStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipmentType UPSratesStruct
 * @package Ups_rates
 * @subpackage Structs
 */
class Ups_ratesShipmentType extends AbstractStructBase
{
    /**
     * The OriginRecordTransactionTimestamp
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $OriginRecordTransactionTimestamp;
    /**
     * The Shipper
     * @var \Ups_rates\UPSratesStruct\Ups_ratesShipperType
     */
    public $Shipper;
    /**
     * The ShipTo
     * @var \Ups_rates\UPSratesStruct\Ups_ratesShipToType
     */
    public $ShipTo;
    /**
     * The ShipFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_rates\UPSratesStruct\Ups_ratesShipFromType
     */
    public $ShipFrom;
    /**
     * The AlternateDeliveryAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_rates\UPSratesStruct\Ups_ratesAlternateDeliveryAddressType
     */
    public $AlternateDeliveryAddress;
    /**
     * The ShipmentIndicationType
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Ups_rates\UPSratesStruct\Ups_ratesIndicationType[]
     */
    public $ShipmentIndicationType;
    /**
     * The PaymentDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_rates\UPSratesStruct\Ups_ratesPaymentDetailsType
     */
    public $PaymentDetails;
    /**
     * The FRSPaymentInformation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_rates\UPSratesStruct\Ups_ratesFRSPaymentInfoType
     */
    public $FRSPaymentInformation;
    /**
     * The FreightShipmentInformation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_rates\UPSratesStruct\Ups_ratesFreightShipmentInformationType
     */
    public $FreightShipmentInformation;
    /**
     * The GoodsNotInFreeCirculationIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $GoodsNotInFreeCirculationIndicator;
    /**
     * The Service
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_rates\UPSratesStruct\Ups_ratesCodeDescriptionType
     */
    public $Service;
    /**
     * The NumOfPieces
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $NumOfPieces;
    /**
     * The ShipmentTotalWeight
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_rates\UPSratesStruct\Ups_ratesShipmentWeightType
     */
    public $ShipmentTotalWeight;
    /**
     * The DocumentsOnlyIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DocumentsOnlyIndicator;
    /**
     * The Package
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \Ups_rates\UPSratesStruct\Ups_ratesPackageType[]
     */
    public $Package;
    /**
     * The ShipmentServiceOptions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_rates\UPSratesStruct\Ups_ratesShipmentServiceOptionsType
     */
    public $ShipmentServiceOptions;
    /**
     * The ShipmentRatingOptions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_rates\UPSratesStruct\Ups_ratesShipmentRatingOptionsType
     */
    public $ShipmentRatingOptions;
    /**
     * The InvoiceLineTotal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_rates\UPSratesStruct\Ups_ratesInvoiceLineTotalType
     */
    public $InvoiceLineTotal;
    /**
     * The RatingMethodRequestedIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RatingMethodRequestedIndicator;
    /**
     * The TaxInformationIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TaxInformationIndicator;
    /**
     * The PromotionalDiscountInformation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_rates\UPSratesStruct\Ups_ratesPromotionalDiscountInformationType
     */
    public $PromotionalDiscountInformation;
    /**
     * The DeliveryTimeInformation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \Ups_rates\UPSratesStruct\Ups_ratesTimeInTransitRequestType
     */
    public $DeliveryTimeInformation;
    /**
     * The MasterCartonIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $MasterCartonIndicator;
    /**
     * The WWEShipmentIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $WWEShipmentIndicator;
    /**
     * Constructor method for ShipmentType
     * @uses Ups_ratesShipmentType::setOriginRecordTransactionTimestamp()
     * @uses Ups_ratesShipmentType::setShipper()
     * @uses Ups_ratesShipmentType::setShipTo()
     * @uses Ups_ratesShipmentType::setShipFrom()
     * @uses Ups_ratesShipmentType::setAlternateDeliveryAddress()
     * @uses Ups_ratesShipmentType::setShipmentIndicationType()
     * @uses Ups_ratesShipmentType::setPaymentDetails()
     * @uses Ups_ratesShipmentType::setFRSPaymentInformation()
     * @uses Ups_ratesShipmentType::setFreightShipmentInformation()
     * @uses Ups_ratesShipmentType::setGoodsNotInFreeCirculationIndicator()
     * @uses Ups_ratesShipmentType::setService()
     * @uses Ups_ratesShipmentType::setNumOfPieces()
     * @uses Ups_ratesShipmentType::setShipmentTotalWeight()
     * @uses Ups_ratesShipmentType::setDocumentsOnlyIndicator()
     * @uses Ups_ratesShipmentType::setPackage()
     * @uses Ups_ratesShipmentType::setShipmentServiceOptions()
     * @uses Ups_ratesShipmentType::setShipmentRatingOptions()
     * @uses Ups_ratesShipmentType::setInvoiceLineTotal()
     * @uses Ups_ratesShipmentType::setRatingMethodRequestedIndicator()
     * @uses Ups_ratesShipmentType::setTaxInformationIndicator()
     * @uses Ups_ratesShipmentType::setPromotionalDiscountInformation()
     * @uses Ups_ratesShipmentType::setDeliveryTimeInformation()
     * @uses Ups_ratesShipmentType::setMasterCartonIndicator()
     * @uses Ups_ratesShipmentType::setWWEShipmentIndicator()
     * @param string $originRecordTransactionTimestamp
     * @param \Ups_rates\UPSratesStruct\Ups_ratesShipperType $shipper
     * @param \Ups_rates\UPSratesStruct\Ups_ratesShipToType $shipTo
     * @param \Ups_rates\UPSratesStruct\Ups_ratesShipFromType $shipFrom
     * @param \Ups_rates\UPSratesStruct\Ups_ratesAlternateDeliveryAddressType $alternateDeliveryAddress
     * @param \Ups_rates\UPSratesStruct\Ups_ratesIndicationType[] $shipmentIndicationType
     * @param \Ups_rates\UPSratesStruct\Ups_ratesPaymentDetailsType $paymentDetails
     * @param \Ups_rates\UPSratesStruct\Ups_ratesFRSPaymentInfoType $fRSPaymentInformation
     * @param \Ups_rates\UPSratesStruct\Ups_ratesFreightShipmentInformationType $freightShipmentInformation
     * @param string $goodsNotInFreeCirculationIndicator
     * @param \Ups_rates\UPSratesStruct\Ups_ratesCodeDescriptionType $service
     * @param string $numOfPieces
     * @param \Ups_rates\UPSratesStruct\Ups_ratesShipmentWeightType $shipmentTotalWeight
     * @param string $documentsOnlyIndicator
     * @param \Ups_rates\UPSratesStruct\Ups_ratesPackageType[] $package
     * @param \Ups_rates\UPSratesStruct\Ups_ratesShipmentServiceOptionsType $shipmentServiceOptions
     * @param \Ups_rates\UPSratesStruct\Ups_ratesShipmentRatingOptionsType $shipmentRatingOptions
     * @param \Ups_rates\UPSratesStruct\Ups_ratesInvoiceLineTotalType $invoiceLineTotal
     * @param string $ratingMethodRequestedIndicator
     * @param string $taxInformationIndicator
     * @param \Ups_rates\UPSratesStruct\Ups_ratesPromotionalDiscountInformationType $promotionalDiscountInformation
     * @param \Ups_rates\UPSratesStruct\Ups_ratesTimeInTransitRequestType $deliveryTimeInformation
     * @param string $masterCartonIndicator
     * @param string $wWEShipmentIndicator
     */
    public function __construct($originRecordTransactionTimestamp = null, \Ups_rates\UPSratesStruct\Ups_ratesShipperType $shipper = null, \Ups_rates\UPSratesStruct\Ups_ratesShipToType $shipTo = null, \Ups_rates\UPSratesStruct\Ups_ratesShipFromType $shipFrom = null, \Ups_rates\UPSratesStruct\Ups_ratesAlternateDeliveryAddressType $alternateDeliveryAddress = null, array $shipmentIndicationType = array(), \Ups_rates\UPSratesStruct\Ups_ratesPaymentDetailsType $paymentDetails = null, \Ups_rates\UPSratesStruct\Ups_ratesFRSPaymentInfoType $fRSPaymentInformation = null, \Ups_rates\UPSratesStruct\Ups_ratesFreightShipmentInformationType $freightShipmentInformation = null, $goodsNotInFreeCirculationIndicator = null, \Ups_rates\UPSratesStruct\Ups_ratesCodeDescriptionType $service = null, $numOfPieces = null, \Ups_rates\UPSratesStruct\Ups_ratesShipmentWeightType $shipmentTotalWeight = null, $documentsOnlyIndicator = null, array $package = array(), \Ups_rates\UPSratesStruct\Ups_ratesShipmentServiceOptionsType $shipmentServiceOptions = null, \Ups_rates\UPSratesStruct\Ups_ratesShipmentRatingOptionsType $shipmentRatingOptions = null, \Ups_rates\UPSratesStruct\Ups_ratesInvoiceLineTotalType $invoiceLineTotal = null, $ratingMethodRequestedIndicator = null, $taxInformationIndicator = null, \Ups_rates\UPSratesStruct\Ups_ratesPromotionalDiscountInformationType $promotionalDiscountInformation = null, \Ups_rates\UPSratesStruct\Ups_ratesTimeInTransitRequestType $deliveryTimeInformation = null, $masterCartonIndicator = null, $wWEShipmentIndicator = null)
    {
        $this
            ->setOriginRecordTransactionTimestamp($originRecordTransactionTimestamp)
            ->setShipper($shipper)
            ->setShipTo($shipTo)
            ->setShipFrom($shipFrom)
            ->setAlternateDeliveryAddress($alternateDeliveryAddress)
            ->setShipmentIndicationType($shipmentIndicationType)
            ->setPaymentDetails($paymentDetails)
            ->setFRSPaymentInformation($fRSPaymentInformation)
            ->setFreightShipmentInformation($freightShipmentInformation)
            ->setGoodsNotInFreeCirculationIndicator($goodsNotInFreeCirculationIndicator)
            ->setService($service)
            ->setNumOfPieces($numOfPieces)
            ->setShipmentTotalWeight($shipmentTotalWeight)
            ->setDocumentsOnlyIndicator($documentsOnlyIndicator)
            ->setPackage($package)
            ->setShipmentServiceOptions($shipmentServiceOptions)
            ->setShipmentRatingOptions($shipmentRatingOptions)
            ->setInvoiceLineTotal($invoiceLineTotal)
            ->setRatingMethodRequestedIndicator($ratingMethodRequestedIndicator)
            ->setTaxInformationIndicator($taxInformationIndicator)
            ->setPromotionalDiscountInformation($promotionalDiscountInformation)
            ->setDeliveryTimeInformation($deliveryTimeInformation)
            ->setMasterCartonIndicator($masterCartonIndicator)
            ->setWWEShipmentIndicator($wWEShipmentIndicator);
    }
    /**
     * Get OriginRecordTransactionTimestamp value
     * @return string|null
     */
    public function getOriginRecordTransactionTimestamp()
    {
        return $this->OriginRecordTransactionTimestamp;
    }
    /**
     * Set OriginRecordTransactionTimestamp value
     * @param string $originRecordTransactionTimestamp
     * @return \Ups_rates\UPSratesStruct\Ups_ratesShipmentType
     */
    public function setOriginRecordTransactionTimestamp($originRecordTransactionTimestamp = null)
    {
        // validation for constraint: string
        if (!is_null($originRecordTransactionTimestamp) && !is_string($originRecordTransactionTimestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originRecordTransactionTimestamp, true), gettype($originRecordTransactionTimestamp)), __LINE__);
        }
        $this->OriginRecordTransactionTimestamp = $originRecordTransactionTimestamp;
        return $this;
    }
    /**
     * Get Shipper value
     * @return \Ups_rates\UPSratesStruct\Ups_ratesShipperType|null
     */
    public function getShipper()
    {
        return $this->Shipper;
    }
    /**
     * Set Shipper value
     * @param \Ups_rates\UPSratesStruct\Ups_ratesShipperType $shipper
     * @return \Ups_rates\UPSratesStruct\Ups_ratesShipmentType
     */
    public function setShipper(\Ups_rates\UPSratesStruct\Ups_ratesShipperType $shipper = null)
    {
        $this->Shipper = $shipper;
        return $this;
    }
    /**
     * Get ShipTo value
     * @return \Ups_rates\UPSratesStruct\Ups_ratesShipToType|null
     */
    public function getShipTo()
    {
        return $this->ShipTo;
    }
    /**
     * Set ShipTo value
     * @param \Ups_rates\UPSratesStruct\Ups_ratesShipToType $shipTo
     * @return \Ups_rates\UPSratesStruct\Ups_ratesShipmentType
     */
    public function setShipTo(\Ups_rates\UPSratesStruct\Ups_ratesShipToType $shipTo = null)
    {
        $this->ShipTo = $shipTo;
        return $this;
    }
    /**
     * Get ShipFrom value
     * @return \Ups_rates\UPSratesStruct\Ups_ratesShipFromType|null
     */
    public function getShipFrom()
    {
        return $this->ShipFrom;
    }
    /**
     * Set ShipFrom value
     * @param \Ups_rates\UPSratesStruct\Ups_ratesShipFromType $shipFrom
     * @return \Ups_rates\UPSratesStruct\Ups_ratesShipmentType
     */
    public function setShipFrom(\Ups_rates\UPSratesStruct\Ups_ratesShipFromType $shipFrom = null)
    {
        $this->ShipFrom = $shipFrom;
        return $this;
    }
    /**
     * Get AlternateDeliveryAddress value
     * @return \Ups_rates\UPSratesStruct\Ups_ratesAlternateDeliveryAddressType|null
     */
    public function getAlternateDeliveryAddress()
    {
        return $this->AlternateDeliveryAddress;
    }
    /**
     * Set AlternateDeliveryAddress value
     * @param \Ups_rates\UPSratesStruct\Ups_ratesAlternateDeliveryAddressType $alternateDeliveryAddress
     * @return \Ups_rates\UPSratesStruct\Ups_ratesShipmentType
     */
    public function setAlternateDeliveryAddress(\Ups_rates\UPSratesStruct\Ups_ratesAlternateDeliveryAddressType $alternateDeliveryAddress = null)
    {
        $this->AlternateDeliveryAddress = $alternateDeliveryAddress;
        return $this;
    }
    /**
     * Get ShipmentIndicationType value
     * @return \Ups_rates\UPSratesStruct\Ups_ratesIndicationType[]|null
     */
    public function getShipmentIndicationType()
    {
        return $this->ShipmentIndicationType;
    }
    /**
     * This method is responsible for validating the values passed to the setShipmentIndicationType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShipmentIndicationType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateShipmentIndicationTypeForArrayConstraintsFromSetShipmentIndicationType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shipmentTypeShipmentIndicationTypeItem) {
            // validation for constraint: itemType
            if (!$shipmentTypeShipmentIndicationTypeItem instanceof \Ups_rates\UPSratesStruct\Ups_ratesIndicationType) {
                $invalidValues[] = is_object($shipmentTypeShipmentIndicationTypeItem) ? get_class($shipmentTypeShipmentIndicationTypeItem) : sprintf('%s(%s)', gettype($shipmentTypeShipmentIndicationTypeItem), var_export($shipmentTypeShipmentIndicationTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ShipmentIndicationType property can only contain items of type \Ups_rates\UPSratesStruct\Ups_ratesIndicationType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ShipmentIndicationType value
     * @throws \InvalidArgumentException
     * @param \Ups_rates\UPSratesStruct\Ups_ratesIndicationType[] $shipmentIndicationType
     * @return \Ups_rates\UPSratesStruct\Ups_ratesShipmentType
     */
    public function setShipmentIndicationType(array $shipmentIndicationType = array())
    {
        // validation for constraint: array
        if ('' !== ($shipmentIndicationTypeArrayErrorMessage = self::validateShipmentIndicationTypeForArrayConstraintsFromSetShipmentIndicationType($shipmentIndicationType))) {
            throw new \InvalidArgumentException($shipmentIndicationTypeArrayErrorMessage, __LINE__);
        }
        $this->ShipmentIndicationType = $shipmentIndicationType;
        return $this;
    }
    /**
     * Add item to ShipmentIndicationType value
     * @throws \InvalidArgumentException
     * @param \Ups_rates\UPSratesStruct\Ups_ratesIndicationType $item
     * @return \Ups_rates\UPSratesStruct\Ups_ratesShipmentType
     */
    public function addToShipmentIndicationType(\Ups_rates\UPSratesStruct\Ups_ratesIndicationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups_rates\UPSratesStruct\Ups_ratesIndicationType) {
            throw new \InvalidArgumentException(sprintf('The ShipmentIndicationType property can only contain items of type \Ups_rates\UPSratesStruct\Ups_ratesIndicationType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ShipmentIndicationType[] = $item;
        return $this;
    }
    /**
     * Get PaymentDetails value
     * @return \Ups_rates\UPSratesStruct\Ups_ratesPaymentDetailsType|null
     */
    public function getPaymentDetails()
    {
        return $this->PaymentDetails;
    }
    /**
     * Set PaymentDetails value
     * @param \Ups_rates\UPSratesStruct\Ups_ratesPaymentDetailsType $paymentDetails
     * @return \Ups_rates\UPSratesStruct\Ups_ratesShipmentType
     */
    public function setPaymentDetails(\Ups_rates\UPSratesStruct\Ups_ratesPaymentDetailsType $paymentDetails = null)
    {
        $this->PaymentDetails = $paymentDetails;
        return $this;
    }
    /**
     * Get FRSPaymentInformation value
     * @return \Ups_rates\UPSratesStruct\Ups_ratesFRSPaymentInfoType|null
     */
    public function getFRSPaymentInformation()
    {
        return $this->FRSPaymentInformation;
    }
    /**
     * Set FRSPaymentInformation value
     * @param \Ups_rates\UPSratesStruct\Ups_ratesFRSPaymentInfoType $fRSPaymentInformation
     * @return \Ups_rates\UPSratesStruct\Ups_ratesShipmentType
     */
    public function setFRSPaymentInformation(\Ups_rates\UPSratesStruct\Ups_ratesFRSPaymentInfoType $fRSPaymentInformation = null)
    {
        $this->FRSPaymentInformation = $fRSPaymentInformation;
        return $this;
    }
    /**
     * Get FreightShipmentInformation value
     * @return \Ups_rates\UPSratesStruct\Ups_ratesFreightShipmentInformationType|null
     */
    public function getFreightShipmentInformation()
    {
        return $this->FreightShipmentInformation;
    }
    /**
     * Set FreightShipmentInformation value
     * @param \Ups_rates\UPSratesStruct\Ups_ratesFreightShipmentInformationType $freightShipmentInformation
     * @return \Ups_rates\UPSratesStruct\Ups_ratesShipmentType
     */
    public function setFreightShipmentInformation(\Ups_rates\UPSratesStruct\Ups_ratesFreightShipmentInformationType $freightShipmentInformation = null)
    {
        $this->FreightShipmentInformation = $freightShipmentInformation;
        return $this;
    }
    /**
     * Get GoodsNotInFreeCirculationIndicator value
     * @return string|null
     */
    public function getGoodsNotInFreeCirculationIndicator()
    {
        return $this->GoodsNotInFreeCirculationIndicator;
    }
    /**
     * Set GoodsNotInFreeCirculationIndicator value
     * @param string $goodsNotInFreeCirculationIndicator
     * @return \Ups_rates\UPSratesStruct\Ups_ratesShipmentType
     */
    public function setGoodsNotInFreeCirculationIndicator($goodsNotInFreeCirculationIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($goodsNotInFreeCirculationIndicator) && !is_string($goodsNotInFreeCirculationIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($goodsNotInFreeCirculationIndicator, true), gettype($goodsNotInFreeCirculationIndicator)), __LINE__);
        }
        $this->GoodsNotInFreeCirculationIndicator = $goodsNotInFreeCirculationIndicator;
        return $this;
    }
    /**
     * Get Service value
     * @return \Ups_rates\UPSratesStruct\Ups_ratesCodeDescriptionType|null
     */
    public function getService()
    {
        return $this->Service;
    }
    /**
     * Set Service value
     * @param \Ups_rates\UPSratesStruct\Ups_ratesCodeDescriptionType $service
     * @return \Ups_rates\UPSratesStruct\Ups_ratesShipmentType
     */
    public function setService(\Ups_rates\UPSratesStruct\Ups_ratesCodeDescriptionType $service = null)
    {
        $this->Service = $service;
        return $this;
    }
    /**
     * Get NumOfPieces value
     * @return string|null
     */
    public function getNumOfPieces()
    {
        return $this->NumOfPieces;
    }
    /**
     * Set NumOfPieces value
     * @param string $numOfPieces
     * @return \Ups_rates\UPSratesStruct\Ups_ratesShipmentType
     */
    public function setNumOfPieces($numOfPieces = null)
    {
        // validation for constraint: string
        if (!is_null($numOfPieces) && !is_string($numOfPieces)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numOfPieces, true), gettype($numOfPieces)), __LINE__);
        }
        $this->NumOfPieces = $numOfPieces;
        return $this;
    }
    /**
     * Get ShipmentTotalWeight value
     * @return \Ups_rates\UPSratesStruct\Ups_ratesShipmentWeightType|null
     */
    public function getShipmentTotalWeight()
    {
        return $this->ShipmentTotalWeight;
    }
    /**
     * Set ShipmentTotalWeight value
     * @param \Ups_rates\UPSratesStruct\Ups_ratesShipmentWeightType $shipmentTotalWeight
     * @return \Ups_rates\UPSratesStruct\Ups_ratesShipmentType
     */
    public function setShipmentTotalWeight(\Ups_rates\UPSratesStruct\Ups_ratesShipmentWeightType $shipmentTotalWeight = null)
    {
        $this->ShipmentTotalWeight = $shipmentTotalWeight;
        return $this;
    }
    /**
     * Get DocumentsOnlyIndicator value
     * @return string|null
     */
    public function getDocumentsOnlyIndicator()
    {
        return $this->DocumentsOnlyIndicator;
    }
    /**
     * Set DocumentsOnlyIndicator value
     * @param string $documentsOnlyIndicator
     * @return \Ups_rates\UPSratesStruct\Ups_ratesShipmentType
     */
    public function setDocumentsOnlyIndicator($documentsOnlyIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($documentsOnlyIndicator) && !is_string($documentsOnlyIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentsOnlyIndicator, true), gettype($documentsOnlyIndicator)), __LINE__);
        }
        $this->DocumentsOnlyIndicator = $documentsOnlyIndicator;
        return $this;
    }
    /**
     * Get Package value
     * @return \Ups_rates\UPSratesStruct\Ups_ratesPackageType[]|null
     */
    public function getPackage()
    {
        return $this->Package;
    }
    /**
     * This method is responsible for validating the values passed to the setPackage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPackage method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePackageForArrayConstraintsFromSetPackage(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shipmentTypePackageItem) {
            // validation for constraint: itemType
            if (!$shipmentTypePackageItem instanceof \Ups_rates\UPSratesStruct\Ups_ratesPackageType) {
                $invalidValues[] = is_object($shipmentTypePackageItem) ? get_class($shipmentTypePackageItem) : sprintf('%s(%s)', gettype($shipmentTypePackageItem), var_export($shipmentTypePackageItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Package property can only contain items of type \Ups_rates\UPSratesStruct\Ups_ratesPackageType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Package value
     * @throws \InvalidArgumentException
     * @param \Ups_rates\UPSratesStruct\Ups_ratesPackageType[] $package
     * @return \Ups_rates\UPSratesStruct\Ups_ratesShipmentType
     */
    public function setPackage(array $package = array())
    {
        // validation for constraint: array
        if ('' !== ($packageArrayErrorMessage = self::validatePackageForArrayConstraintsFromSetPackage($package))) {
            throw new \InvalidArgumentException($packageArrayErrorMessage, __LINE__);
        }
        $this->Package = $package;
        return $this;
    }
    /**
     * Add item to Package value
     * @throws \InvalidArgumentException
     * @param \Ups_rates\UPSratesStruct\Ups_ratesPackageType $item
     * @return \Ups_rates\UPSratesStruct\Ups_ratesShipmentType
     */
    public function addToPackage(\Ups_rates\UPSratesStruct\Ups_ratesPackageType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ups_rates\UPSratesStruct\Ups_ratesPackageType) {
            throw new \InvalidArgumentException(sprintf('The Package property can only contain items of type \Ups_rates\UPSratesStruct\Ups_ratesPackageType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Package[] = $item;
        return $this;
    }
    /**
     * Get ShipmentServiceOptions value
     * @return \Ups_rates\UPSratesStruct\Ups_ratesShipmentServiceOptionsType|null
     */
    public function getShipmentServiceOptions()
    {
        return $this->ShipmentServiceOptions;
    }
    /**
     * Set ShipmentServiceOptions value
     * @param \Ups_rates\UPSratesStruct\Ups_ratesShipmentServiceOptionsType $shipmentServiceOptions
     * @return \Ups_rates\UPSratesStruct\Ups_ratesShipmentType
     */
    public function setShipmentServiceOptions(\Ups_rates\UPSratesStruct\Ups_ratesShipmentServiceOptionsType $shipmentServiceOptions = null)
    {
        $this->ShipmentServiceOptions = $shipmentServiceOptions;
        return $this;
    }
    /**
     * Get ShipmentRatingOptions value
     * @return \Ups_rates\UPSratesStruct\Ups_ratesShipmentRatingOptionsType|null
     */
    public function getShipmentRatingOptions()
    {
        return $this->ShipmentRatingOptions;
    }
    /**
     * Set ShipmentRatingOptions value
     * @param \Ups_rates\UPSratesStruct\Ups_ratesShipmentRatingOptionsType $shipmentRatingOptions
     * @return \Ups_rates\UPSratesStruct\Ups_ratesShipmentType
     */
    public function setShipmentRatingOptions(\Ups_rates\UPSratesStruct\Ups_ratesShipmentRatingOptionsType $shipmentRatingOptions = null)
    {
        $this->ShipmentRatingOptions = $shipmentRatingOptions;
        return $this;
    }
    /**
     * Get InvoiceLineTotal value
     * @return \Ups_rates\UPSratesStruct\Ups_ratesInvoiceLineTotalType|null
     */
    public function getInvoiceLineTotal()
    {
        return $this->InvoiceLineTotal;
    }
    /**
     * Set InvoiceLineTotal value
     * @param \Ups_rates\UPSratesStruct\Ups_ratesInvoiceLineTotalType $invoiceLineTotal
     * @return \Ups_rates\UPSratesStruct\Ups_ratesShipmentType
     */
    public function setInvoiceLineTotal(\Ups_rates\UPSratesStruct\Ups_ratesInvoiceLineTotalType $invoiceLineTotal = null)
    {
        $this->InvoiceLineTotal = $invoiceLineTotal;
        return $this;
    }
    /**
     * Get RatingMethodRequestedIndicator value
     * @return string|null
     */
    public function getRatingMethodRequestedIndicator()
    {
        return $this->RatingMethodRequestedIndicator;
    }
    /**
     * Set RatingMethodRequestedIndicator value
     * @param string $ratingMethodRequestedIndicator
     * @return \Ups_rates\UPSratesStruct\Ups_ratesShipmentType
     */
    public function setRatingMethodRequestedIndicator($ratingMethodRequestedIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($ratingMethodRequestedIndicator) && !is_string($ratingMethodRequestedIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratingMethodRequestedIndicator, true), gettype($ratingMethodRequestedIndicator)), __LINE__);
        }
        $this->RatingMethodRequestedIndicator = $ratingMethodRequestedIndicator;
        return $this;
    }
    /**
     * Get TaxInformationIndicator value
     * @return string|null
     */
    public function getTaxInformationIndicator()
    {
        return $this->TaxInformationIndicator;
    }
    /**
     * Set TaxInformationIndicator value
     * @param string $taxInformationIndicator
     * @return \Ups_rates\UPSratesStruct\Ups_ratesShipmentType
     */
    public function setTaxInformationIndicator($taxInformationIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($taxInformationIndicator) && !is_string($taxInformationIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxInformationIndicator, true), gettype($taxInformationIndicator)), __LINE__);
        }
        $this->TaxInformationIndicator = $taxInformationIndicator;
        return $this;
    }
    /**
     * Get PromotionalDiscountInformation value
     * @return \Ups_rates\UPSratesStruct\Ups_ratesPromotionalDiscountInformationType|null
     */
    public function getPromotionalDiscountInformation()
    {
        return $this->PromotionalDiscountInformation;
    }
    /**
     * Set PromotionalDiscountInformation value
     * @param \Ups_rates\UPSratesStruct\Ups_ratesPromotionalDiscountInformationType $promotionalDiscountInformation
     * @return \Ups_rates\UPSratesStruct\Ups_ratesShipmentType
     */
    public function setPromotionalDiscountInformation(\Ups_rates\UPSratesStruct\Ups_ratesPromotionalDiscountInformationType $promotionalDiscountInformation = null)
    {
        $this->PromotionalDiscountInformation = $promotionalDiscountInformation;
        return $this;
    }
    /**
     * Get DeliveryTimeInformation value
     * @return \Ups_rates\UPSratesStruct\Ups_ratesTimeInTransitRequestType|null
     */
    public function getDeliveryTimeInformation()
    {
        return $this->DeliveryTimeInformation;
    }
    /**
     * Set DeliveryTimeInformation value
     * @param \Ups_rates\UPSratesStruct\Ups_ratesTimeInTransitRequestType $deliveryTimeInformation
     * @return \Ups_rates\UPSratesStruct\Ups_ratesShipmentType
     */
    public function setDeliveryTimeInformation(\Ups_rates\UPSratesStruct\Ups_ratesTimeInTransitRequestType $deliveryTimeInformation = null)
    {
        $this->DeliveryTimeInformation = $deliveryTimeInformation;
        return $this;
    }
    /**
     * Get MasterCartonIndicator value
     * @return string|null
     */
    public function getMasterCartonIndicator()
    {
        return $this->MasterCartonIndicator;
    }
    /**
     * Set MasterCartonIndicator value
     * @param string $masterCartonIndicator
     * @return \Ups_rates\UPSratesStruct\Ups_ratesShipmentType
     */
    public function setMasterCartonIndicator($masterCartonIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($masterCartonIndicator) && !is_string($masterCartonIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($masterCartonIndicator, true), gettype($masterCartonIndicator)), __LINE__);
        }
        $this->MasterCartonIndicator = $masterCartonIndicator;
        return $this;
    }
    /**
     * Get WWEShipmentIndicator value
     * @return string|null
     */
    public function getWWEShipmentIndicator()
    {
        return $this->WWEShipmentIndicator;
    }
    /**
     * Set WWEShipmentIndicator value
     * @param string $wWEShipmentIndicator
     * @return \Ups_rates\UPSratesStruct\Ups_ratesShipmentType
     */
    public function setWWEShipmentIndicator($wWEShipmentIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($wWEShipmentIndicator) && !is_string($wWEShipmentIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($wWEShipmentIndicator, true), gettype($wWEShipmentIndicator)), __LINE__);
        }
        $this->WWEShipmentIndicator = $wWEShipmentIndicator;
        return $this;
    }
}
